/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame;

import com.sun.star.wizards.tutorial.creator.frame.Framework;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class TutorialCreator
extends JFrame {
    private Framework m_frameWork;
    private String m_tutorialName;
    private JTextArea m_stepTextArea;
    private String m_ident;

    public TutorialCreator(Framework framework, String string) {
        this.m_frameWork = framework;
        this.m_tutorialName = string;
        this.m_ident = "    ";
        this.init();
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
        this.setBounds(200, 70, 600, 600);
        this.setTitle("TutorialCreator");
        this.m_stepTextArea = new JTextArea();
        this.m_stepTextArea.setBackground(new Color(255, 250, 240));
        this.m_stepTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_stepTextArea);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Tutorial macro");
        jScrollPane.setBorder(titledBorder);
        JButton jButton = new JButton("Create");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TutorialCreator.this.create();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TutorialCreator.this.cancel();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.setTutorialText();
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dispose();
            this.m_frameWork.showStepFrame(this.getBounds());
        }
    }

    private void create() {
        String string = this.m_frameWork.createDocumentMacro(this, "Standard", this.m_tutorialName, this.m_stepTextArea.getText(), false);
        JOptionPane.showMessageDialog(this, string, "Create Result", 1);
        this.cancel();
    }

    private void cancel() {
        this.dispose();
        this.m_frameWork.showStepFrame(this.getBounds());
    }

    private void setTutorialText() {
        Vector vector = this.m_frameWork.getStepFrame().getModel().getDataVector();
        if (!vector.isEmpty()) {
            this.setMacroHeader();
            this.setLibraryLoader();
            this.setMacroProperties();
            Hashtable hashtable = this.setMacroText(vector);
            this.setStepActionCheck(hashtable);
            this.setMacroActionHeader(hashtable);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(string);
                this.setMacroAction(vector2, string);
            }
        }
    }

    private void setMacroHeader() {
        String string = this.m_frameWork.getConnectedDocumentTyp();
        String string2 = "Sub Main" + this.m_tutorialName + "\n" + this.m_ident + "isLoaded()\n" + this.m_ident + "LoadTutorialDialog(" + this.m_tutorialName + ", " + '\"' + string + '\"' + ")\n" + "End Sub\n";
        this.m_stepTextArea.append(string2);
    }

    private void setLibraryLoader() {
        String string = "Sub isLoaded()\n" + this.m_ident + "If GlobalScope.BasicLibraries.isLibraryLoaded(" + '\"' + "Tutorials" + '\"' + ") = " + '\"' + "False" + '\"' + " Then\n" + this.m_ident + this.m_ident + "GlobalScope.BasicLibraries.LoadLibrary(" + '\"' + "Tutorials" + '\"' + ")\n" + this.m_ident + "End If\n" + "End Sub\n";
        this.m_stepTextArea.append(string);
    }

    private void setMacroProperties() {
        String string = "Function GetProperties() As com.sun.star.beans.NamedValue\n" + this.m_ident + "Dim properties(3) As new com.sun.star.beans.NamedValue\n" + this.m_ident + "properties(0).Name = " + '\"' + "MacroName" + '\"' + "\n" + this.m_ident + "properties(0).Value = " + '\"' + this.m_tutorialName + '\"' + "\n" + this.m_ident + "properties(1).Name = " + '\"' + "ExecuteForm" + '\"' + "\n" + this.m_ident + "properties(1).Value = " + '\"' + "Name" + '\"' + "\n" + this.m_ident + "properties(2).Name = " + '\"' + "Debug" + '\"' + "\n" + this.m_ident + "properties(2).Value = " + '\"' + "False" + '\"' + "\n" + this.m_ident + "properties(3).Name = " + '\"' + "Localisation" + '\"' + "\n" + this.m_ident + "properties(3).Value = " + '\"' + "False" + '\"' + "\n" + this.m_ident + "GetProperties = properties()\n" + "End Function\n";
        this.m_stepTextArea.append(string);
    }

    private Hashtable setMacroText(Vector vector) {
        Hashtable<Object, Vector> hashtable = new Hashtable<Object, Vector>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            String string = "Function LoadText()\n" + this.m_ident + "Dim LocTutorText(" + (n - 1) + ") as String\n";
            this.m_stepTextArea.append(string);
            for (int i = 0; i < n; ++i) {
                Object object;
                Vector vector2 = (Vector)vector.get(i);
                String string2 = (String)vector2.get(1);
                Vector vector3 = (Vector)vector2.get(2);
                if (vector3 != null && !vector3.isEmpty()) {
                    object = "" + i;
                    hashtable.put(object, vector3);
                }
                object = new StringTokenizer(string2);
                string = "";
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = string.equals("") ? this.m_ident + "LocTutorText(" + i + ") = " : this.m_ident + "LocTutorText(" + i + ") = LocTutorText(" + i + ") & ";
                    string = string + '\"' + ((StringTokenizer)object).nextToken("\n") + '\"' + " & CHR(13) & CHR(13)\n";
                    this.m_stepTextArea.append(string);
                }
            }
            string = this.m_ident + "LoadText() = LocTutorText()\n" + "End Function\n";
            this.m_stepTextArea.append(string);
        }
        return hashtable;
    }

    private void setStepActionCheck(Hashtable hashtable) {
        String string = "Function ContainsStepAction()\n" + this.m_ident + "Dim result As Boolean\n" + this.m_ident + "result = False\n";
        this.m_stepTextArea.append(string);
        if (!hashtable.isEmpty()) {
            string = this.m_ident + "Select Case TutorStep\n" + this.m_ident + this.m_ident + "Case";
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string + " " + string2 + ",";
            }
            string = string.substring(0, string.length() - 1);
            string = string + "\n" + this.m_ident + this.m_ident + this.m_ident + "result = True\n" + this.m_ident + "End Select\n";
            this.m_stepTextArea.append(string);
        }
        string = this.m_ident + "ContainsStepAction = result\n" + "End Function\n";
        this.m_stepTextArea.append(string);
    }

    private void setMacroActionHeader(Hashtable hashtable) {
        String string = "Sub Action()\n" + this.m_ident + "Select Case TutorStep\n";
        this.m_stepTextArea.append(string);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = this.m_ident + this.m_ident + "Case " + string2 + "\n" + this.m_ident + this.m_ident + this.m_ident + "Step_" + string2 + "_Action()\n";
            this.m_stepTextArea.append(string);
        }
        string = this.m_ident + "End Select\n" + "End Sub\n";
        this.m_stepTextArea.append(string);
    }

    private Vector parsParam(String string) {
        String string2;
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (string.indexOf("/>") > 0) {
            int n = string.indexOf("/>");
            string2 = string.substring(1, n);
            vector.add(string2);
            string = string.substring(n + 2);
        }
        if (!vector.isEmpty() && (string2 = (String)vector.get(0)).indexOf("Path=") == 0) {
            string2 = string2.substring("Path=".length());
            Vector<String> vector2 = new Vector<String>();
            stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken(";");
                vector2.add(string2);
            }
            vector.remove(0);
            vector.add(0, vector2);
        }
        return vector;
    }

    private void setMacroAction(Vector vector, String string) {
        if (!vector.isEmpty()) {
            String string2 = "Sub Step_" + string + "_Action()\n";
            this.m_stepTextArea.append(string2);
            string2 = this.m_ident + "isLoaded()\n" + this.m_ident + "Dim commands(" + vector.size() + ") As new com.sun.star.beans.NamedValue\n";
            this.m_stepTextArea.append(string2);
            int n = 0;
            int n2 = 0;
            string2 = this.m_ident + "commands(0).Name = " + '\"' + "Properties" + '\"' + "\n" + this.m_ident + "commands(0).Value = GetProperties()\n";
            this.m_stepTextArea.append(string2);
            n = 1;
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                String string3 = (String)vector2.get(0);
                String string4 = (String)vector2.get(1);
                String string5 = (String)vector2.get(2);
                Vector vector3 = this.parsParam(string5);
                string2 = this.m_ident + "Dim commands" + n + "(" + (1 + vector3.size()) + ") As new com.sun.star.beans.NamedValue\n" + this.m_ident + "commands" + n + "(0).Name = " + '\"' + "DocumentTYP" + '\"' + "\n" + this.m_ident + "commands" + n + "(0).Value = " + '\"' + string3 + '\"' + "\n" + this.m_ident + "commands" + n + "(1).Name = " + '\"' + "MethodName" + '\"' + "\n" + this.m_ident + "commands" + n + "(1).Value = " + '\"' + string4 + '\"' + "\n";
                this.m_stepTextArea.append(string2);
                if (!vector3.isEmpty()) {
                    for (int j = 0; j < vector3.size(); ++j) {
                        Object e = vector3.get(j);
                        if (e instanceof Vector) {
                            Vector vector4 = (Vector)e;
                            int n3 = vector4.size();
                            string2 = this.m_ident + "Dim path" + n2 + "(" + (n3 - 1) + ") As String\n";
                            for (int k = 0; k < vector4.size(); ++k) {
                                string2 = string2 + this.m_ident + "path" + n2 + "(" + k + ") = " + '\"' + (String)vector4.get(k) + '\"' + "\n";
                            }
                            string2 = string2 + this.m_ident + "CheckPath(path" + n2 + "())\n" + this.m_ident + "commands" + n + "(" + (j + 2) + ").Name = " + '\"' + "Path" + '\"' + "\n" + this.m_ident + "commands" + n + "(" + (j + 2) + ").Value = path" + n2 + "()\n";
                            ++n2;
                        } else {
                            string2 = this.m_ident + "commands" + n + "(" + (j + 2) + ").Name = " + '\"' + "Param" + '\"' + "\n" + this.m_ident + "commands" + n + "(" + (j + 2) + ").Value = " + '\"' + (String)e + '\"' + "\n";
                        }
                        this.m_stepTextArea.append(string2);
                    }
                    string2 = this.m_ident + "commands(" + n + ").Name = " + '\"' + "commands" + n + "()" + '\"' + "\n" + this.m_ident + "commands(" + n + ").Value = commands" + n + "()\n";
                    this.m_stepTextArea.append(string2);
                    ++n;
                    continue;
                }
                string2 = this.m_ident + "commands(" + n + ").Name = " + '\"' + "commands" + n + "()" + '\"' + "\n" + this.m_ident + "commands(" + n + ").Value = commands" + n + "()\n";
                this.m_stepTextArea.append(string2);
                ++n;
            }
            string2 = this.m_ident + "Init()\n" + this.m_ident + "myTutorial.execute(commands())\n";
            this.m_stepTextArea.append(string2);
            string2 = "End Sub\n";
            this.m_stepTextArea.append(string2);
        }
    }
}

