/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame;

import com.sun.star.wizards.tutorial.creator.frame.StepModel;
import com.sun.star.wizards.tutorial.creator.frame.objectFinder.XFramework;
import com.sun.star.wizards.tutorial.executer.util.FileChooser;
import com.sun.star.wizards.tutorial.executer.util.ObjectFileWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class StepFrame
extends JFrame {
    private XFramework m_parent;
    private JTextArea m_stepTextArea;
    private JTextArea m_descreptionTextArea;
    private JList m_list;
    private JTable m_table;
    private String m_typDialogTitel = "Tutorial - Creator v1.2";
    private String m_descreptionTitledBorder = "Comment:";
    private String m_stepTitledBorder = "Step :";
    private String m_nextButtonDescreption = "Next >";
    private String m_cancelButtonDescreption = "Close";
    private String m_backButtonDescreption = "< Previous";
    private String m_createButtonDescreption = "Create Macro";
    private String m_saveButton = "Save";
    private String m_loadButton = "Load";
    private String m_errorDescreption = "Please insert step text.";
    private String m_errorName = "Step Error";
    private int m_stepIndex;
    private TitledBorder m_message;
    private StepModel m_model;
    private JPanel m_contentPane;
    private static Vector m_cAction;
    private JButton create;
    private JButton back;
    private JButton next;
    private JButton add;
    private JButton remove;
    private JButton upList;
    private JButton downList;
    private JButton action;
    private JButton removeAction;
    private JButton upTable;
    private JButton downTable;
    private JButton save;

    public StepFrame(XFramework xFramework, StepModel stepModel) {
        this.m_parent = xFramework;
        this.m_model = stepModel;
        this.m_stepIndex = 0;
        m_cAction = new Vector();
        m_cAction.add("Typ");
        m_cAction.add("Name");
        m_cAction.add("Params");
        this.init();
    }

    private void init() {
        this.m_contentPane = (JPanel)this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_contentPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
        this.setBounds(200, 70, 750, 600);
        this.setTitle(this.m_typDialogTitel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, 50));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.m_list = new JList();
        this.m_list.setBackground(new Color(255, 250, 240));
        this.m_list.setModel(new DefaultComboBoxModel());
        this.m_list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        jScrollPane.setPreferredSize(new Dimension(200, 40));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Steps");
        jScrollPane.setBorder(titledBorder);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.add = new JButton("Add");
        this.remove = new JButton("Del");
        this.remove.setEnabled(false);
        jPanel4.add(this.add);
        jPanel4.add(this.remove);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.upList = new JButton("Up");
        this.downList = new JButton("Down");
        this.upList.setEnabled(false);
        this.downList.setEnabled(false);
        jPanel5.add(this.upList);
        jPanel5.add(this.downList);
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        jPanel6.setPreferredSize(new Dimension(83, 110));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 5));
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel6, "North");
        jPanel3.add((Component)jPanel7, "East");
        jPanel3.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(this.m_cancelButtonDescreption);
        this.create = new JButton(this.m_createButtonDescreption);
        this.create.setEnabled(false);
        this.save = new JButton(this.m_saveButton);
        this.save.setEnabled(false);
        JButton jButton2 = new JButton(this.m_loadButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel8.add(this.save);
        jPanel8.add(jButton2);
        jPanel8.add(this.create);
        jPanel8.add(jButton);
        jPanel2.add((Component)jPanel8, "East");
        JPanel jPanel9 = new JPanel();
        jPanel9.setPreferredSize(new Dimension(0, 70));
        jPanel9.setLayout(new BorderLayout());
        this.m_descreptionTextArea = new JTextArea();
        this.m_descreptionTextArea.setBackground(new Color(255, 250, 240));
        JScrollPane jScrollPane2 = new JScrollPane(this.m_descreptionTextArea);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), this.m_descreptionTitledBorder);
        jScrollPane2.setBorder(titledBorder2);
        jPanel9.add((Component)jScrollPane2, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setPreferredSize(new Dimension(0, 220));
        jPanel10.setLayout(new BorderLayout());
        this.m_stepTextArea = new JTextArea();
        this.m_stepTextArea.setLineWrap(true);
        this.m_stepTextArea.setBackground(new Color(255, 250, 240));
        JScrollPane jScrollPane3 = new JScrollPane(this.m_stepTextArea);
        this.m_message = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), this.m_stepTitledBorder + this.m_stepIndex);
        jScrollPane3.setBorder(this.m_message);
        jPanel10.add((Component)jScrollPane3, "Center");
        jPanel10.add((Component)jPanel3, "West");
        jPanel.add((Component)jPanel10, "South");
        this.back = new JButton(this.m_backButtonDescreption);
        this.next = new JButton(this.m_nextButtonDescreption);
        this.back.setEnabled(false);
        this.next.setEnabled(false);
        JPanel jPanel11 = new JPanel(new FlowLayout(2));
        jPanel11.add(this.back);
        jPanel11.add(this.next);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setPreferredSize(new Dimension(350, 350));
        jPanel12.add((Component)jPanel, "North");
        jPanel12.add((Component)jPanel11, "South");
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel(){

            public void moveColumn(int n, int n2) {
            }
        };
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        defaultTableModel.setColumnIdentifiers(new Object[]{"Typ", "Method Name", "Params"});
        this.m_table = new JTable();
        this.m_table.setColumnModel(defaultTableColumnModel);
        this.m_table.setModel(defaultTableModel);
        this.m_table.setBackground(new Color(255, 250, 240));
        this.m_table.setAutoResizeMode(0);
        this.setTableColumsMinWidth();
        JScrollPane jScrollPane4 = new JScrollPane();
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Actions");
        jScrollPane4.setBorder(titledBorder3);
        jScrollPane4.setPreferredSize(new Dimension(100, 40));
        jScrollPane4.getViewport().add(this.m_table);
        JPanel jPanel13 = new JPanel(new GridLayout(2, 1));
        jPanel13.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.action = new JButton("Add");
        this.removeAction = new JButton("Del");
        this.action.setEnabled(false);
        this.removeAction.setEnabled(false);
        jPanel13.add(this.action);
        jPanel13.add(this.removeAction);
        JPanel jPanel14 = new JPanel(new GridLayout(2, 1));
        jPanel14.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.upTable = new JButton("Up");
        this.downTable = new JButton("Down");
        this.upTable.setEnabled(false);
        this.downTable.setEnabled(false);
        jPanel14.add(this.upTable);
        jPanel14.add(this.downTable);
        JPanel jPanel15 = new JPanel(new GridLayout(2, 1));
        jPanel15.setPreferredSize(new Dimension(83, 110));
        jPanel15.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 5));
        jPanel15.add(jPanel13);
        jPanel15.add(jPanel14);
        JPanel jPanel16 = new JPanel(new BorderLayout());
        jPanel16.add((Component)jPanel15, "North");
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout());
        jPanel17.add((Component)jPanel16, "East");
        jPanel17.add((Component)jScrollPane4, "Center");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jPanel12);
        jSplitPane.setBottomComponent(jPanel17);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(15);
        jSplitPane.setDividerLocation(280);
        this.m_contentPane.add((Component)jSplitPane, "Center");
        this.m_contentPane.add((Component)jPanel2, "South");
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (StepFrame.this.m_list.getSelectedIndex() > -1 && StepFrame.this.m_list.getSelectedIndex() != StepFrame.this.m_stepIndex) {
                    StepFrame.this.selectStep(StepFrame.this.m_stepIndex, StepFrame.this.m_list.getSelectedIndex());
                }
            }
        });
        this.upList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)StepFrame.this.m_list.getModel();
                int n = StepFrame.this.m_list.getSelectedIndex();
                if (n > 0) {
                    StepFrame.this.getModel().changeStepsIndexes(n - 1, n);
                    StepFrame.this.openStepDialog(n - 1);
                }
            }
        });
        this.downList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)StepFrame.this.m_list.getModel();
                int n = StepFrame.this.m_list.getSelectedIndex();
                if (n > -1 && n + 1 < defaultComboBoxModel.getSize()) {
                    StepFrame.this.getModel().changeStepsIndexes(n, n + 1);
                    StepFrame.this.openStepDialog(n + 1);
                }
            }
        });
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.createTutorial();
            }
        });
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.save();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.load();
            }
        });
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StepFrame.this.getModel().isStepsEmpty()) {
                    StepFrame.this.m_stepIndex = 0;
                } else if (StepFrame.this.m_stepIndex + 1 <= StepFrame.this.getModel().getStepsSize()) {
                    StepFrame.this.m_stepIndex += 1;
                }
                StepFrame.this.getModel().addNewStep(StepFrame.this.m_stepIndex);
                StepFrame.this.initData(StepFrame.this.m_stepIndex);
                StepFrame.this.setProperties("new desc", "new step", StepFrame.this.m_stepIndex);
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!StepFrame.this.getModel().isStepsEmpty()) {
                    StepFrame.this.removeStep(StepFrame.this.m_stepIndex);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.cancel();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.backStep(StepFrame.this.m_stepIndex);
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.nextStep(StepFrame.this.m_stepIndex);
            }
        });
        this.action.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.m_parent.showActionsFrame(StepFrame.this.getBounds());
                StepFrame.this.dispose();
            }
        });
        this.removeAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StepFrame.this.removeAction();
            }
        });
        this.upTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StepFrame.this.m_table.getSelectedRow();
                if (n > 0) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)StepFrame.this.m_table.getModel();
                    defaultTableModel.moveRow(n, n, n - 1);
                    StepFrame.this.m_table.setRowSelectionInterval(n - 1, n - 1);
                }
            }
        });
        this.downTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StepFrame.this.m_table.getSelectedRow();
                DefaultTableModel defaultTableModel = (DefaultTableModel)StepFrame.this.m_table.getModel();
                if (n > -1 && n + 1 < defaultTableModel.getRowCount()) {
                    defaultTableModel.moveRow(n, n, n + 1);
                    StepFrame.this.m_table.setRowSelectionInterval(n + 1, n + 1);
                }
            }
        });
        this.m_stepTextArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                Vector vector = StepFrame.this.createStep(StepFrame.this.getDescreptionText(), StepFrame.this.getStepText());
                if (vector != null) {
                    if (StepFrame.this.getModel().isStepsEmpty()) {
                        StepFrame.this.m_stepIndex = 0;
                    }
                    try {
                        StepFrame.this.getModel().removeStep(StepFrame.this.m_stepIndex);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    StepFrame.this.getModel().addStep(StepFrame.this.m_stepIndex, vector);
                    StepFrame.this.initData(StepFrame.this.m_stepIndex);
                    StepFrame.this.setButtonsProperties();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.saveDialog(this);
        Vector vector = this.getModel().getDataVector();
        if (vector.isEmpty()) return;
        if (file.exists() && file.isFile()) {
            String string = file.getName() + " already exists.\n Do you want to replace it?";
            int n = JOptionPane.showConfirmDialog(this, string, "Save", 0, 3);
            if (n != 0) return;
            file.delete();
        } else if (file.exists() && file.isDirectory()) {
            String string = file.getName() + " already exists.\n This is a directory name!.";
            JOptionPane.showMessageDialog(this, string, "Save Error", 0);
            return;
        }
        boolean bl = ObjectFileWriter.writeObjekt(file, vector);
        if (bl) {
            JOptionPane.showMessageDialog(this, "Save successfull", "Save Info", 1);
            return;
        } else {
            JOptionPane.showMessageDialog(this, "Save failed", "Save Info", 0);
        }
    }

    public void load() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.openDialog(this);
        Object object = ObjectFileWriter.readObjekt(file);
        if (object != null && object instanceof Vector) {
            Vector vector = (Vector)object;
            this.getModel().setDataVector(vector);
            this.openStepDialog(0);
            JOptionPane.showMessageDialog(this, "Load successfull", "Load Info", 1);
            return;
        }
        JOptionPane.showMessageDialog(this, "Load failed", "Load Info", 0);
    }

    public void removeStep(int n) {
        if (n == 0) {
            try {
                this.getModel().removeStep(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (0 < this.getModel().getStepsSize()) {
                this.openStepDialog(n);
            } else {
                this.initData(n);
                this.setProperties("", "", n);
            }
        } else if (n > 0) {
            try {
                this.getModel().removeStep(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (!this.getModel().isStepsEmpty()) {
                this.openStepDialog(--n);
            }
        }
    }

    public void openStepDialog(int n) {
        Vector vector;
        if (n < this.getModel().getStepsSize() && (vector = this.getModel().getStep(n)) != null) {
            String string = (String)vector.get(0);
            String string2 = (String)vector.get(1);
            this.initData(n);
            this.setProperties(string, string2, n);
        }
    }

    public void addAction(Vector vector) {
        if (vector != null && !vector.isEmpty()) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.m_table.getModel();
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                defaultTableModel.addRow(vector2);
            }
        }
    }

    public void removeAction() {
        int[] nArray = this.m_table.getSelectedRows();
        if (nArray.length > 0) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.m_table.getModel();
            for (int i = nArray.length - 1; i > -1; --i) {
                defaultTableModel.removeRow(nArray[i]);
            }
            this.setButtonsProperties();
        }
    }

    public void initData(int n) {
        this.initListData();
        this.initTableData(n);
    }

    public void initTableData(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.m_table.getModel();
        Vector vector = this.getModel().getStep(n);
        if (vector != null) {
            Vector vector2 = (Vector)vector.get(2);
            defaultTableModel.setDataVector(vector2, m_cAction);
        } else {
            defaultTableModel.setDataVector(new Vector(), m_cAction);
        }
        this.setTableColumsMinWidth();
    }

    private void setTableColumsMinWidth() {
        this.m_table.getColumnModel().getColumn(0).setMinWidth(50);
        this.m_table.getColumnModel().getColumn(1).setMinWidth(100);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(400);
    }

    public void initListData() {
        DefaultComboBoxModel defaultComboBoxModel;
        String[] stringArray = null;
        int n = this.getModel().getStepsSize();
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "Step :" + i;
            }
        }
        if ((defaultComboBoxModel = (DefaultComboBoxModel)this.m_list.getModel()).getSize() > 0) {
            defaultComboBoxModel.removeAllElements();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultComboBoxModel.addElement(stringArray[i]);
            }
        }
    }

    public Vector getStepActions() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.m_table.getModel();
        return defaultTableModel.getDataVector();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        int n;
        if (windowEvent.getID() == 201 && (n = JOptionPane.showConfirmDialog(this, "Do you want to close?.", "Close", 0, 3)) == 0) {
            this.dispose();
            super.processWindowEvent(windowEvent);
        }
    }

    private void createTutorial() {
        if (this.getStepText() == null || this.getStepText().equals("")) {
            JOptionPane.showMessageDialog(this, this.m_errorDescreption, this.m_errorName, 0);
            return;
        }
        String string = JOptionPane.showInputDialog(this, (Object)"Please insert tutorial name:");
        if (string != null && string.equals("")) {
            JOptionPane.showMessageDialog(this, "Please insert tutorial name.", "Name Error", 0);
            return;
        }
        if (string == null) {
            return;
        }
        this.dispose();
        this.m_parent.showTutorialCreator(this.getBounds(), string);
    }

    private void cancel() {
        int n = JOptionPane.showConfirmDialog(this, "Do you want to close?.", "Close", 0, 3);
        if (n == 0) {
            this.dispose();
        }
    }

    public void setProperties(String string, String string2, int n) {
        this.m_descreptionTextArea.setText(string);
        this.m_stepIndex = n;
        this.setButtonsProperties();
        this.m_stepTextArea.setText(string2);
        this.m_message.setTitle(this.m_stepTitledBorder + this.m_stepIndex);
        this.m_contentPane.updateUI();
    }

    public void setButtonsProperties() {
        if (this.getModel().getStepsSize() > 0) {
            this.back.setEnabled(true);
            this.next.setEnabled(true);
            if (this.m_stepIndex == 0) {
                this.back.setEnabled(false);
            }
            if (this.m_stepIndex == this.getModel().getStepsSize() - 1 || this.getModel().getStepsSize() == 0) {
                this.next.setEnabled(false);
            }
            this.create.setEnabled(true);
            this.save.setEnabled(true);
            this.remove.setEnabled(true);
            if (this.getModel().getStepsSize() > 1) {
                this.upList.setEnabled(true);
                this.downList.setEnabled(true);
            } else {
                this.upList.setEnabled(false);
                this.downList.setEnabled(false);
            }
            this.action.setEnabled(true);
            if (this.getStepActions().size() > 0) {
                this.removeAction.setEnabled(true);
                if (this.getStepActions().size() > 1) {
                    this.upTable.setEnabled(true);
                    this.downTable.setEnabled(true);
                } else {
                    this.upTable.setEnabled(false);
                    this.downTable.setEnabled(false);
                }
            } else {
                this.removeAction.setEnabled(false);
                this.upTable.setEnabled(false);
                this.downTable.setEnabled(false);
            }
        } else {
            this.back.setEnabled(false);
            this.next.setEnabled(false);
            this.create.setEnabled(false);
            this.save.setEnabled(false);
            this.remove.setEnabled(false);
            this.upList.setEnabled(false);
            this.downList.setEnabled(false);
            this.action.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.upTable.setEnabled(false);
            this.downTable.setEnabled(false);
        }
    }

    public String getStepText() {
        return this.m_stepTextArea.getText();
    }

    public String getDescreptionText() {
        return "";
    }

    public StepModel getModel() {
        return this.m_model;
    }

    private Vector createStep(String string, String string2) {
        Vector<Object> vector = null;
        if (!string.equals("") || !string2.equals("")) {
            Vector vector2 = this.getStepActions();
            vector = new Vector<Object>();
            vector.add(0, string);
            vector.add(1, string2);
            vector.add(2, vector2);
        }
        return vector;
    }

    public void selectStep(int n, int n2) {
        Vector vector = this.createStep(this.getDescreptionText(), this.getStepText());
        try {
            this.getModel().removeStep(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (vector != null && !this.getStepText().equals("")) {
            this.getModel().addStep(n, vector);
        }
        this.openStepDialog(n2);
    }

    public void nextStep(int n) {
        if (this.getStepText() == null || this.getStepText().equals("")) {
            JOptionPane.showMessageDialog(this, this.m_errorDescreption, this.m_errorName, 0);
            return;
        }
        this.openStepDialog(++n);
    }

    public void backStep(int n) {
        if (this.getStepText() == null || this.getStepText().equals("")) {
            JOptionPane.showMessageDialog(this, this.m_errorDescreption, this.m_errorName, 0);
            return;
        }
        this.openStepDialog(--n);
    }
}

