/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.tutorial.creator.frame;

import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.tutorial.creator.frame.Framework;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class ConnectFrame
extends JFrame {
    private Framework m_parent;
    private JTextField m_hostTextField;
    private JTextField m_portTextField;
    private JTextPane m_textPane;
    private Helper m_helper;
    private String m_connectDialogTitel = "Connect";
    private String m_hostLabelTitel = "Host  : ";
    private String m_portLabelTitel = "Port  : ";
    private String m_defaultHost = "localhost";
    private String m_defaultPort = "8100";
    private String m_connectDescreption = "Please insert StarOffice Hostname and port.";
    private String m_connectButtonDescreption = "Connect";
    private String m_cancelButtonDescreption = "Cancel";

    public ConnectFrame(Framework framework) {
        this.m_parent = framework;
        this.init();
    }

    public ConnectFrame(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        this.m_helper = new Helper(xMultiServiceFactory);
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
        this.setBounds(300, 300, 320, 170);
        this.setTitle(this.m_connectDialogTitel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(this.m_hostLabelTitel);
        JLabel jLabel2 = new JLabel(this.m_portLabelTitel);
        this.m_hostTextField = new JTextField(this.m_defaultHost);
        this.m_portTextField = new JTextField(this.m_defaultPort);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagLayout.setConstraints(this.m_hostTextField, gridBagConstraints);
        jPanel2.add(this.m_hostTextField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.m_portTextField, gridBagConstraints);
        jPanel2.add(this.m_portTextField);
        this.m_textPane = new JTextPane();
        this.m_textPane.setBackground(new Color(204, 204, 204));
        this.m_textPane.setText(this.m_connectDescreption);
        JButton jButton = new JButton(this.m_connectButtonDescreption);
        JButton jButton2 = new JButton(this.m_cancelButtonDescreption);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectFrame.this.connect();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectFrame.this.cancel();
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add((Component)this.m_textPane, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dispose();
            System.exit(0);
        }
    }

    private void connect() {
        try {
            if (this.getHost().equals("") || this.getPort().equals("")) {
                throw new Exception();
            }
            String string = "uno:socket,host=" + this.getHost() + ",port=" + this.getPort() + ";urp;StarOffice.ServiceManager";
            this.m_helper = new Helper(string);
            if (!this.m_helper.isConnected() || this.getConnectedDocumentTyp() == null || this.getConnectedDocumentTyp().equals("")) {
                throw new Exception();
            }
            this.setVisible(false);
            this.m_parent.init();
            this.m_parent.showStepFrame(this.getBounds());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Cannot connect to StarOffice", "Connect Error", 0);
            return;
        }
    }

    public XExtendedToolkit getXExtendedToolkit() {
        XExtendedToolkit xExtendedToolkit = null;
        try {
            xExtendedToolkit = this.m_helper.getXExtendedToolkit();
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return xExtendedToolkit;
    }

    public XMultiServiceFactory getXMultiServiceFactory() {
        return this.m_helper.getxMSF();
    }

    public XModel getXModel() {
        XModel xModel = null;
        try {
            xModel = this.m_helper.getXModel();
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return xModel;
    }

    public String getConnectedDocumentTitle() {
        return this.m_helper.getCurrentDocumentTitle();
    }

    public String getConnectedDocumentTyp() {
        String string = "";
        try {
            string = this.m_helper.getCurrentDocumentTyp();
            if (string != null && !string.equals("")) {
                string = string.substring(string.lastIndexOf(".") + 1).trim();
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean isConnected() {
        return this.m_helper.isConnected();
    }

    private void cancel() {
        this.dispose();
        System.exit(0);
    }

    public String getHost() {
        return this.m_hostTextField.getText();
    }

    public String getPort() {
        return this.m_portTextField.getText();
    }
}

