/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShapes;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;

public class DatabaseControl
extends Control {
    int ifieldtype;

    public DatabaseControl(GridControl gridControl, FieldColumn fieldColumn) {
        if (fieldColumn.FieldType != 93) {
            this.createGridColumn(gridControl, fieldColumn, fieldColumn.FieldType, fieldColumn.FieldTitle);
        }
    }

    public DatabaseControl(GridControl gridControl, FieldColumn fieldColumn, int n, String string) {
        this.createGridColumn(gridControl, fieldColumn, n, string);
    }

    private void createGridColumn(GridControl gridControl, FieldColumn fieldColumn, int n, String string) {
        try {
            this.ifieldtype = n;
            String string2 = Desktop.getUniqueName(gridControl.xNameAccess, fieldColumn.FieldName);
            XPropertySet xPropertySet = gridControl.xGridColumnFactory.createColumn(this.getGridColumnName());
            xPropertySet.setPropertyValue("Name", (Object)string2);
            xPropertySet.setPropertyValue("Hidden", (Object)new Boolean(n == -4));
            xPropertySet.setPropertyValue("DataField", (Object)fieldColumn.FieldName);
            xPropertySet.setPropertyValue("Label", (Object)string);
            xPropertySet.setPropertyValue("Width", (Object)new Integer(0));
            this.setNumerics();
            gridControl.xNameContainer.insertByName(fieldColumn.FieldName, (Object)xPropertySet);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public DatabaseControl(FormHandler formHandler, String string, Point point) {
        super(formHandler, string, point);
    }

    public DatabaseControl(FormHandler formHandler, XNameContainer xNameContainer, String string, int n, Point point) {
        super(formHandler, xNameContainer, formHandler.getControlType(n), point, null);
        try {
            this.ifieldtype = n;
            Helper.setUnoPropertyValue(this.xControlModel, "DataField", string);
            this.setNumerics();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public DatabaseControl(FormHandler formHandler, XShapes xShapes, XNameContainer xNameContainer, String string, int n, Point point) {
        super(formHandler, xShapes, xNameContainer, formHandler.getControlType(n), point, null);
        try {
            this.ifieldtype = n;
            Helper.setUnoPropertyValue(this.xControlModel, "DataField", string);
            this.setNumerics();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private String getGridColumnName() {
        for (int i = 0; i < FormHandler.oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != this.ifieldtype) continue;
            return FormHandler.oControlData[i].GridColumnName;
        }
        return null;
    }

    public String getDefaultControlName() {
        return "DBControl";
    }

    public int getDBHeight() {
        if (this.icontroltype == 7) {
            return this.oFormHandler.getImageControlHeight();
        }
        if (this.icontroltype == -1) {
            Helper.setUnoPropertyValue(this.xControlModel, "MultiLine", Boolean.TRUE);
            return this.oFormHandler.getDBRefHeight() * 4;
        }
        return this.oFormHandler.getDBRefHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNumerics() {
        try {
            if (this.icontroltype == 5) {
                this.xPropertySet.setPropertyValue("TreatAsNumber", (Object)Boolean.TRUE);
                switch (this.ifieldtype) {
                    case -5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(1.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(0.0));
                        return;
                    }
                    case 4: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(2.147483647E9));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-2.147483648E9));
                        return;
                    }
                    case 5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(32767.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-32768.0));
                        return;
                    }
                    case -6: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(127.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-128.0));
                        return;
                    }
                    case 6: {
                        this.xPropertySet.setPropertyValue("EffectiveDefault", (Object)new Double(1000.0));
                        return;
                    }
                    case 7: {
                        this.xPropertySet.setPropertyValue("EffectiveDefault", (Object)new Double(1000.0));
                        return;
                    }
                    case 8: {
                        this.xPropertySet.setPropertyValue("EffectiveDefault", (Object)new Double(1000.0));
                        return;
                    }
                    case 3: {
                        this.xPropertySet.setPropertyValue("EffectiveDefault", (Object)new Double(1000.0));
                        return;
                    }
                    case 2: {
                        this.xPropertySet.setPropertyValue("EffectiveDefault", (Object)new Integer(1000));
                    }
                }
                return;
            }
            if (this.icontroltype == 1) return;
            if (this.icontroltype == 4) {
                this.xPropertySet.setPropertyValue("DefaultTime", (Object)new Integer(3000));
                return;
            }
            if (this.icontroltype != 2) return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

