/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XSQLQueryComposer;
import com.sun.star.sdb.XSQLQueryComposerFactory;
import com.sun.star.sdb.XSingleSelectQueryAnalyzer;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.Vector;

public class SQLQueryComposer {
    public XColumnsSupplier xColSuppl;
    XSQLQueryComposerFactory xSQLComposerFactory;
    XSQLQueryComposer xSQLQueryComposer;
    QueryMetaData CurDBMetaData;
    String selectclause;
    String fromclause;
    String sIdentifierQuoteString = "";
    public XSingleSelectQueryAnalyzer xQueryAnalyzer;
    Vector composedCommandNames = new Vector(1);
    public XSingleSelectQueryComposer xQueryComposer;
    String sCatalogSep;
    boolean bCatalogAtStart;
    XMultiServiceFactory xMSF;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$sdb$XSingleSelectQueryAnalyzer;
    static /* synthetic */ Class class$com$sun$star$sdb$XSingleSelectQueryComposer;
    static /* synthetic */ Class class$com$sun$star$sdb$XSQLQueryComposerFactory;
    static /* synthetic */ Class class$com$sun$star$lang$XInitialization;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XExecutableDialog;

    public SQLQueryComposer(QueryMetaData queryMetaData) {
        try {
            this.CurDBMetaData = queryMetaData;
            this.xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = SQLQueryComposer.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)this.CurDBMetaData.DBConnection);
            Object object = this.xMSF.createInstance("com.sun.star.sdb.SingleSelectQueryComposer");
            this.xQueryAnalyzer = (XSingleSelectQueryAnalyzer)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XSingleSelectQueryAnalyzer == null ? (class$com$sun$star$sdb$XSingleSelectQueryAnalyzer = SQLQueryComposer.class$("com.sun.star.sdb.XSingleSelectQueryAnalyzer")) : class$com$sun$star$sdb$XSingleSelectQueryAnalyzer), (Object)object);
            this.xQueryComposer = (XSingleSelectQueryComposer)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XSingleSelectQueryComposer == null ? (class$com$sun$star$sdb$XSingleSelectQueryComposer = SQLQueryComposer.class$("com.sun.star.sdb.XSingleSelectQueryComposer")) : class$com$sun$star$sdb$XSingleSelectQueryComposer), (Object)this.xQueryAnalyzer);
            this.xSQLComposerFactory = (XSQLQueryComposerFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XSQLQueryComposerFactory == null ? (class$com$sun$star$sdb$XSQLQueryComposerFactory = SQLQueryComposer.class$("com.sun.star.sdb.XSQLQueryComposerFactory")) : class$com$sun$star$sdb$XSQLQueryComposerFactory), (Object)this.CurDBMetaData.DBConnection);
            XSQLQueryComposer xSQLQueryComposer = this.xSQLComposerFactory.createQueryComposer();
            this.sIdentifierQuoteString = this.CurDBMetaData.xDBMetaData.getIdentifierQuoteString();
            this.sCatalogSep = this.CurDBMetaData.xDBMetaData.getCatalogSeparator();
            this.bCatalogAtStart = this.CurDBMetaData.xDBMetaData.isCatalogAtStart();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private boolean addtoSelectClause(String string) throws SQLException {
        return !this.CurDBMetaData.xDBMetaData.supportsGroupByUnrelated() || this.CurDBMetaData.GroupFieldNames == null || JavaTools.FieldInList(this.CurDBMetaData.GroupFieldNames, string) <= -1;
    }

    public void appendSelectClause() throws SQLException {
        this.selectclause = "SELECT ";
        for (int i = 0; i < this.CurDBMetaData.FieldNames.length; ++i) {
            if (!this.addtoSelectClause(this.CurDBMetaData.FieldNames[i])) continue;
            int n = this.CurDBMetaData.getAggregateIndex(this.CurDBMetaData.FieldNames[i]);
            if (n > -1) {
                this.selectclause = this.selectclause + this.CurDBMetaData.AggregateFieldNames[n][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[n][0]) + ")";
                this.selectclause = this.selectclause + this.getAliasFieldNameClause(this.CurDBMetaData.AggregateFieldNames[n][0]);
            } else {
                this.selectclause = this.selectclause + this.getComposedAliasFieldName(this.CurDBMetaData.FieldNames[i]);
                this.selectclause = this.selectclause + this.getAliasFieldNameClause(this.CurDBMetaData.FieldNames[i]);
            }
            this.selectclause = this.selectclause + ", ";
        }
        this.selectclause = this.selectclause.substring(0, this.selectclause.length() - 2);
    }

    public String getAliasFieldNameClause(String string) {
        String string2 = this.CurDBMetaData.getFieldTitle(string);
        if (!string2.equals(string)) {
            return " AS " + this.quoteName(string2);
        }
        return "";
    }

    public void appendFilterConditions() throws SQLException {
        try {
            for (int i = 0; i < this.CurDBMetaData.FilterConditions.length; ++i) {
                String string = this.CurDBMetaData.FilterConditions[i][0].Name;
                this.xQueryComposer.setStructuredFilter(this.CurDBMetaData.FilterConditions);
            }
            String string = this.xQueryAnalyzer.getQuery();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void appendSortingcriteria() throws SQLException {
        String string = "";
        for (int i = 0; i < this.CurDBMetaData.SortFieldNames.length; ++i) {
            int n = this.CurDBMetaData.getAggregateIndex(this.CurDBMetaData.SortFieldNames[i][0]);
            if (n > -1) {
                string = this.xQueryAnalyzer.getOrder();
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + this.CurDBMetaData.AggregateFieldNames[n][1] + "(" + this.CurDBMetaData.AggregateFieldNames[n][0] + ")";
                string = string + " " + this.CurDBMetaData.SortFieldNames[i][1];
                this.xQueryComposer.setOrder(string);
            } else {
                XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(this.CurDBMetaData.SortFieldNames[i][0]);
                boolean bl = this.CurDBMetaData.SortFieldNames[i][1] == "ASC";
                this.xQueryComposer.appendOrderByColumn(xPropertySet, bl);
            }
            string = this.xQueryAnalyzer.getOrder();
        }
    }

    public void appendGroupByColumns() throws SQLException {
        for (int i = 0; i < this.CurDBMetaData.GroupFieldNames.length; ++i) {
            XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(this.CurDBMetaData.GroupFieldNames[i]);
            this.xQueryComposer.appendGroupByColumn(xPropertySet);
        }
        String string = this.xQueryAnalyzer.getQuery();
    }

    public void setDBMetaData(QueryMetaData queryMetaData) {
        this.CurDBMetaData = queryMetaData;
    }

    private PropertyValue[][] replaceConditionsByAlias(PropertyValue[][] propertyValueArray) {
        for (int i = 0; i < propertyValueArray.length; ++i) {
            for (int j = 0; j < propertyValueArray[i].length; ++j) {
                propertyValueArray[i][j].Name = this.getComposedAliasFieldName(propertyValueArray[i][j].Name);
            }
        }
        return propertyValueArray;
    }

    public String getQuery() {
        return this.xQueryAnalyzer.getQuery();
    }

    public boolean setQueryCommand(String string, XWindow xWindow, boolean bl) {
        try {
            this.CurDBMetaData.setfieldtitles();
            this.fromclause = "FROM";
            String[] stringArray = this.CurDBMetaData.getIncludedCommandNames();
            for (int i = 0; i < stringArray.length; ++i) {
                ComposedCommandName composedCommandName = new ComposedCommandName(stringArray[i]);
                this.fromclause = this.fromclause + " " + composedCommandName.sComposedName;
                if (i < stringArray.length - 1) {
                    this.fromclause = this.fromclause + ", ";
                }
                this.composedCommandNames.add(composedCommandName);
            }
            this.appendSelectClause();
            String string2 = this.selectclause + " " + this.fromclause;
            this.xQueryAnalyzer.setQuery(string2);
            if (this.CurDBMetaData.FilterConditions != null && this.CurDBMetaData.FilterConditions.length > 0) {
                this.CurDBMetaData.FilterConditions = this.replaceConditionsByAlias(this.CurDBMetaData.FilterConditions);
                this.xQueryComposer.setStructuredFilter(this.CurDBMetaData.FilterConditions);
            }
            String string3 = this.xQueryAnalyzer.getQuery();
            if (bl) {
                this.appendGroupByColumns();
                if (this.CurDBMetaData.GroupByFilterConditions.length > 0) {
                    this.xQueryComposer.setStructuredHavingClause(this.CurDBMetaData.GroupByFilterConditions);
                }
            }
            string3 = this.xQueryAnalyzer.getQuery();
            this.appendSortingcriteria();
            string3 = this.xQueryAnalyzer.getQuery();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.displaySQLErrorDialog(exception, xWindow);
            return false;
        }
    }

    private String getComposedAliasFieldName(String string) {
        FieldColumn fieldColumn = this.CurDBMetaData.getFieldColumnByDisplayName(string);
        ComposedCommandName composedCommandName = this.getComposedCommandByDisplayName(fieldColumn.getCommandName());
        String string2 = composedCommandName.AliasName;
        return this.quoteName(string2) + "." + this.quoteName(fieldColumn.FieldName);
    }

    private ComposedCommandName getComposedCommandByAliasName(String string) {
        if (this.composedCommandNames != null) {
            for (int i = 0; i < this.composedCommandNames.size(); ++i) {
                ComposedCommandName composedCommandName = (ComposedCommandName)this.composedCommandNames.elementAt(i);
                if (!composedCommandName.AliasName.equals(string)) continue;
                return composedCommandName;
            }
        }
        return null;
    }

    private ComposedCommandName getComposedCommandByDisplayName(String string) {
        if (this.composedCommandNames != null) {
            for (int i = 0; i < this.composedCommandNames.size(); ++i) {
                ComposedCommandName composedCommandName = (ComposedCommandName)this.composedCommandNames.elementAt(i);
                if (!composedCommandName.DisplayName.equals(string)) continue;
                return composedCommandName;
            }
        }
        return null;
    }

    private String quoteName(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = "";
        string2 = this.sIdentifierQuoteString + string + this.sIdentifierQuoteString;
        return string2;
    }

    public void displaySQLErrorDialog(Exception exception, XWindow xWindow) {
        try {
            Object object = this.CurDBMetaData.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XInitialization == null ? (class$com$sun$star$lang$XInitialization = SQLQueryComposer.class$("com.sun.star.lang.XInitialization")) : class$com$sun$star$lang$XInitialization), (Object)object);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XExecutableDialog == null ? (class$com$sun$star$ui$dialogs$XExecutableDialog = SQLQueryComposer.class$("com.sun.star.ui.dialogs.XExecutableDialog")) : class$com$sun$star$ui$dialogs$XExecutableDialog), (Object)object);
            Object[] objectArray = new PropertyValue[]{Properties.createProperty("Title", Configuration.getProductName(this.CurDBMetaData.xMSF) + "Base"), Properties.createProperty("ParentWindow", xWindow), Properties.createProperty("SQLException", (Object)exception)};
            xInitialization.initialize(objectArray);
            xExecutableDialog.execute();
        }
        catch (Exception exception2) {
            exception2.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ComposedCommandName {
        public String CatalogName;
        public String SchemaName;
        public String TableName;
        public String AliasName;
        public String DisplayName;
        public String sComposedName = "";

        public ComposedCommandName(String string) {
            try {
                int n;
                this.DisplayName = string;
                if (SQLQueryComposer.this.CurDBMetaData.xDBMetaData.supportsCatalogsInDataManipulation() && (n = string.indexOf(SQLQueryComposer.this.sCatalogSep)) >= 0) {
                    if (SQLQueryComposer.this.bCatalogAtStart) {
                        this.CatalogName = string.substring(0, n);
                        string = string.substring(n + 1, string.length());
                    } else {
                        this.CatalogName = string.substring(n + 1, string.length());
                        string = string.substring(0, n);
                    }
                }
                if (SQLQueryComposer.this.CurDBMetaData.xDBMetaData.supportsSchemasInDataManipulation()) {
                    String[] stringArray = new String[]{};
                    stringArray = JavaTools.ArrayoutofString(string, ".");
                    this.SchemaName = stringArray[0];
                    this.TableName = stringArray[1];
                } else {
                    this.TableName = string;
                }
                this.setComposedCommandName();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void setuniqueAliasName(String string) {
            int n = 0;
            boolean bl = true;
            String string2 = string;
            while (bl) {
                boolean bl2 = bl = SQLQueryComposer.this.getComposedCommandByAliasName(string2) != null;
                if (bl) {
                    string2 = string + "_" + String.valueOf(++n);
                    continue;
                }
                this.AliasName = string2;
            }
        }

        public void setComposedCommandName() {
            if (this.CatalogName != null && SQLQueryComposer.this.bCatalogAtStart) {
                this.sComposedName = SQLQueryComposer.this.quoteName(this.CatalogName) + SQLQueryComposer.this.sCatalogSep;
            }
            if (this.SchemaName != null) {
                this.sComposedName = this.sComposedName + SQLQueryComposer.this.quoteName(this.SchemaName) + ".";
            }
            this.sComposedName = this.sComposedName == "" ? SQLQueryComposer.this.quoteName(this.TableName) : this.sComposedName + SQLQueryComposer.this.quoteName(this.TableName);
            if (!SQLQueryComposer.this.bCatalogAtStart && this.CatalogName != null) {
                this.sComposedName = this.sComposedName + SQLQueryComposer.this.sCatalogSep + SQLQueryComposer.this.quoteName(this.CatalogName);
            }
            this.setuniqueAliasName(this.TableName);
            this.sComposedName = this.sComposedName + " " + SQLQueryComposer.this.quoteName(this.AliasName);
        }
    }
}

