/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.util.XNumberFormats;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import java.util.HashMap;
import java.util.Vector;

public class QueryMetaData
extends CommandMetaData {
    public Vector QueryFields;
    FieldColumn CurFieldColumn;
    public String Command;
    Vector CommandNames;
    public PropertyValue[][] FilterConditions = new PropertyValue[0][];
    public PropertyValue[][] GroupByFilterConditions = new PropertyValue[0][];
    public String[] FieldTitles = new String[0];
    public String[] UniqueAggregateFieldNames = new String[0];
    public int Type = 1;

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, XNumberFormats xNumberFormats) {
        super(xMultiServiceFactory, locale, xNumberFormats);
        this.QueryFields = new Vector(0);
    }

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.QueryFields = new Vector(0);
    }

    public void setFilterConditions(PropertyValue[][] propertyValueArray) {
        this.FilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getFilterConditions() {
        return this.FilterConditions;
    }

    public void setGroupByFilterConditions(PropertyValue[][] propertyValueArray) {
        this.GroupByFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getGroupByFilterConditions() {
        return this.GroupByFilterConditions;
    }

    public Vector getQueryFields() {
        return this.QueryFields;
    }

    void removeQueryField() {
    }

    public void setFieldNames(String[] stringArray, XNameAccess xNameAccess) {
        int n = stringArray.length;
        this.FieldNames = new String[n];
        this.QueryFields.removeAllElements();
        for (int i = 0; i < n; ++i) {
            this.CurFieldColumn = new FieldColumn(this, xNameAccess, stringArray[i]);
            this.QueryFields.add(this.QueryFields.size(), this.CurFieldColumn);
            this.FieldNames[i] = stringArray[i];
        }
    }

    public void setFieldNames(String[] stringArray) {
        int n = stringArray.length;
        this.FieldNames = new String[n];
        this.QueryFields.removeAllElements();
        for (int i = 0; i < n; ++i) {
            this.CurFieldColumn = new FieldColumn(this, stringArray[i]);
            this.QueryFields.add(this.QueryFields.size(), this.CurFieldColumn);
            this.FieldNames[i] = stringArray[i];
            if (this.FieldTitleSet == null || !this.FieldTitleSet.containsKey(this.FieldNames[i])) continue;
            this.CurFieldColumn.AliasName = (String)this.FieldTitleSet.get(this.FieldNames[i]);
            if (this.CurFieldColumn.AliasName != null) continue;
            this.CurFieldColumn.AliasName = stringArray[i];
            this.FieldTitleSet.put(this.FieldNames[i], stringArray[i]);
        }
    }

    public String[] getIncludedCommandNames() {
        this.CommandNames = new Vector(1);
        for (int i = 0; i < this.QueryFields.size(); ++i) {
            FieldColumn fieldColumn = (FieldColumn)this.QueryFields.elementAt(i);
            String string = fieldColumn.getCommandName();
            if (this.CommandNames.contains(string)) continue;
            this.CommandNames.addElement(string);
        }
        String[] stringArray = new String[this.CommandNames.size()];
        this.CommandNames.toArray(stringArray);
        return stringArray;
    }

    public static String[] getIncludedCommandNames(String[] stringArray) {
        Vector<String> vector = new Vector<String>(1);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            String[] stringArray2 = JavaTools.ArrayoutofString(stringArray[i], ".");
            if (stringArray2.length <= 1) continue;
            for (int j = 0; j < stringArray2.length - 1; ++j) {
                string = string + stringArray2[j];
            }
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        return stringArray3;
    }

    public String[] getAllFieldNames() {
        return this.AllFieldNames;
    }

    public void setAllIncludedFieldNames(boolean bl) {
        try {
            this.getIncludedCommandNames();
            if (this.FieldTitleSet == null) {
                this.FieldTitleSet = new HashMap();
            }
            for (int i = 0; i < this.CommandNames.size(); ++i) {
                DBMetaData.CommandObject commandObject = this.getTableByName((String)this.CommandNames.elementAt(i));
                String[] stringArray = commandObject.xColumns.getElementNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = "";
                    string = bl ? (String)this.CommandNames.elementAt(i) + "." + stringArray[j] : stringArray[j];
                    if (this.FieldTitleSet.containsKey(string)) continue;
                    this.FieldTitleSet.put(string, null);
                }
            }
            this.FieldTitleSet.keySet().toArray(this.AllFieldNames);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public FieldColumn getFieldColumnByDisplayName(String string) {
        for (int i = 0; i < this.QueryFields.size(); ++i) {
            FieldColumn fieldColumn = (FieldColumn)this.QueryFields.elementAt(i);
            if (!fieldColumn.DisplayFieldName.equals(string)) continue;
            return fieldColumn;
        }
        return null;
    }

    public String[] getUniqueAggregateFieldNames() {
        Vector<String> vector = new Vector<String>(0);
        for (int i = 0; i < this.AggregateFieldNames.length; ++i) {
            if (vector.contains(this.AggregateFieldNames[i][0])) continue;
            vector.add(this.AggregateFieldNames[i][0]);
        }
        this.UniqueAggregateFieldNames = new String[vector.size()];
        vector.toArray(this.UniqueAggregateFieldNames);
        return this.UniqueAggregateFieldNames;
    }

    public boolean hasNumericalFields() {
        FieldColumn fieldColumn = null;
        for (int i = 0; i < this.QueryFields.size(); ++i) {
            fieldColumn = (FieldColumn)this.QueryFields.elementAt(i);
            if (!fieldColumn.bIsNumberFormat) continue;
            return true;
        }
        return false;
    }

    public void setfieldtitles() {
        this.FieldTitles = new String[this.FieldNames.length];
        for (int i = 0; i < this.FieldNames.length; ++i) {
            if (!this.FieldTitleSet.containsKey(this.FieldNames[i])) continue;
            String string = (String)this.FieldTitleSet.get(this.FieldNames[i]);
            if (string == null || string.equals(this.FieldNames[i])) {
                string = this.FieldNames[i];
            } else {
                this.CurFieldColumn = this.getFieldColumnByDisplayName(this.FieldNames[i]);
                this.CurFieldColumn.AliasName = string;
            }
            this.FieldTitles[i] = string;
        }
    }

    public int getAggregateIndex(String string) {
        int n = -1;
        if (this.Type == 0) {
            n = JavaTools.FieldInTable(this.AggregateFieldNames, string);
        }
        return n;
    }

    public String getFieldName(String string) {
        int n = JavaTools.FieldInList(this.FieldTitles, string);
        if (n > -1) {
            return this.FieldNames[n];
        }
        return null;
    }

    public static interface QueryType {
        public static final int SOSUMMARYQUERY = 0;
        public static final int SODETAILQUERY = 1;
    }
}

