/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.agenda;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.agenda.AgendaTemplate;
import com.sun.star.wizards.agenda.AgendaWizardDialog;
import com.sun.star.wizards.agenda.CGAgenda;
import com.sun.star.wizards.agenda.TopicsControl;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class AgendaWizardDialogImpl
extends AgendaWizardDialog {
    static boolean running;
    AgendaTemplate agendaTemplate;
    private CGAgenda agenda;
    private TopicsControl topicsControl;
    private String[][] agendaTemplates;
    private FileAccess fileAccess1;
    private boolean filenameChanged = false;
    static /* synthetic */ Class class$com$sun$star$awt$XWindowPeer;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$util$XCloseable;

    public AgendaWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void startWizard() {
        running = true;
        try {
            this.agenda = new CGAgenda();
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Agenda", false);
            this.agenda.readConfiguration(object, "cp_");
            this.agendaTemplate = new AgendaTemplate(this.xMSF, this.agenda, this.resources, (XTerminateListener)this);
            this.initializeTemplates();
            this.agendaTemplate.load(this.agendaTemplates[1][this.agenda.cp_AgendaType], new Vector());
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.topicsControl = new TopicsControl(this, this.xMSF, this.agenda);
            this.buildStep6();
            this.drawNaviBar();
            XWindow xWindow = this.agendaTemplate.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XWindowPeer == null ? (class$com$sun$star$awt$XWindowPeer = AgendaWizardDialogImpl.class$("com.sun.star.awt.XWindowPeer")) : class$com$sun$star$awt$XWindowPeer), (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.addRoadmap();
            this.insertRoadMapItems(new String[]{this.resources.resStep1, this.resources.resStep2, this.resources.resStep3, this.resources.resStep4, this.resources.resStep5, this.resources.resStep6}, new int[]{1, 2, 3, 4, 5, 6}, new boolean[]{true, true, true, true, true, true});
            this.setMaxStep(6);
            this.makeDA();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            running = false;
            return;
        }
        this.xWindow.setVisible(true);
    }

    private void checkSavePath() {
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("") || !this.getFileAccess().exists(FileAccess.getParentDir(this.agenda.cp_TemplatePath), false) || !this.getFileAccess().isDirectory(FileAccess.getParentDir(this.agenda.cp_TemplatePath))) {
            try {
                this.agenda.cp_TemplatePath = FileAccess.connectURLs(FileAccess.getOfficePath(this.xMSF, "Work", ""), this.resources.resDefaultFilename);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeDA() {
        this.setControlProperty("listPageDesign", "StringItemList", this.agendaTemplates[0]);
        this.checkSavePath();
        this.setFilename(this.agenda.cp_TemplatePath);
        UnoDataAware.attachListBox(this.agenda, "cp_AgendaType", this.listPageDesign, null, true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_IncludeMinutes", this.chkMinutes, null, true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_Title", this.txtTitle, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachDateControl(this.agenda, "cp_Date", this.txtDate, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachTimeControl(this.agenda, "cp_Time", this.txtTime, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_Location", this.cbLocation, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowMeetingType", this.chkMeetingTitle, new RedrawListener("<meeting-type>"), true);
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowRead", this.chkRead, new RedrawListener("<read>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowBring", this.chkBring, new RedrawListener("<bring>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowNotes", this.chkNotes, new RedrawListener("<notes>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowCalledBy", this.chkConvenedBy, new RedrawListener("<called-by>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowFacilitator", this.chkPresiding, new RedrawListener("<facilitator>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowNotetaker", this.chkNoteTaker, new RedrawListener("<notetaker>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowTimekeeper", this.chkTimekeeper, new RedrawListener("<timekeeper>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowAttendees", this.chkAttendees, new RedrawListener("<attendees>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowObservers", this.chkObservers, new RedrawListener("<observers>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowResourcePersons", this.chkResourcePersons, new RedrawListener("<resource-persons>"), true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_TemplateName", this.txtTemplateName, null, true).updateUI();
        RadioDataAware.attachRadioButtons(this.agenda, "cp_ProceedMethod", new Object[]{this.optCreateAgenda, this.optMakeChanges}, null, true).updateUI();
        this.listPageDesign.addItemListener(new XItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AgendaWizardDialogImpl.this.pageDesignChanged(itemEvent);
            }

            public void disposing(EventObject eventObject) {
            }
        });
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            AgendaWizardDialogImpl agendaWizardDialogImpl = new AgendaWizardDialogImpl(xMultiServiceFactory);
            agendaWizardDialogImpl.startWizard();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean initializeTemplates() {
        try {
            String string = FileAccess.getOfficePath(this.xMSF, "Template", "share");
            String string2 = FileAccess.combinePaths(this.xMSF, string, "/wizard/agenda");
            this.agendaTemplates = FileAccess.getFolderTitles(this.xMSF, "aw", string2);
            return true;
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void pageDesignChanged(ItemEvent itemEvent) {
        int n = itemEvent.Selected;
        try {
            this.agendaTemplate.load(this.agendaTemplates[1][n], this.topicsControl.getTopicsData());
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox(this.xMSF, "ErrBox", 0x400000, this.resources.resErrOpenTemplate);
            exception.printStackTrace();
        }
    }

    public void templateTitleChanged() {
        String string = (String)Helper.getUnoPropertyValue(AgendaWizardDialogImpl.getModel(this.txtTemplateName), "Text");
        this.agendaTemplate.setTemplateTitle(string);
    }

    private FileAccess getFileAccess() {
        if (this.fileAccess1 == null) {
            try {
                this.fileAccess1 = new FileAccess(this.xMSF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fileAccess1;
    }

    public void saveAs() {
        try {
            this.checkSavePath();
            SystemDialog systemDialog = SystemDialog.createStoreDialog(this.xMSF);
            systemDialog.addFilterToDialog("stw", "writer_StarOffice_XML_Writer_Template", true);
            String string = systemDialog.callStoreDialog(FileAccess.getParentDir(this.agenda.cp_TemplatePath), FileAccess.getFilename(this.agenda.cp_TemplatePath));
            if (string != null) {
                this.agenda.cp_TemplatePath = string;
                this.setFilename(string);
                this.filenameChanged = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFilename(String string) {
        try {
            String string2 = this.getFileAccess().getPath(string, "");
            Helper.setUnoPropertyValue(AgendaWizardDialogImpl.getModel(this.txtTemplatePath), "Text", string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertRow() {
        this.topicsControl.insertRow();
    }

    public void removeRow() {
        this.topicsControl.removeRow();
    }

    public void rowUp() {
        this.topicsControl.rowUp();
    }

    public void rowDown() {
        this.topicsControl.rowDown();
    }

    public void cancelWizard() {
        this.xWindow.setVisible(false);
        this.closeDocument();
        running = false;
    }

    public void finishWizard() {
        XTextDocument xTextDocument;
        int n;
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("")) {
            return;
        }
        if (!this.filenameChanged && this.getFileAccess().exists(this.agenda.cp_TemplatePath, true) && (n = SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "MessBox", -2130706432, this.resources.resFileExists)) == 3) {
            return;
        }
        n = 0;
        try {
            this.agendaTemplate.xTextDocument.lockControllers();
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = AgendaWizardDialogImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.agendaTemplate.document);
            n = OfficeDocument.store(this.xMSF, (XComponent)xTextDocument, this.agenda.cp_TemplatePath, "writer_StarOffice_XML_Writer_Template", false, this.resources.resErrSaveTemplate) ? 1 : 0;
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "ErrBox", 0x400000, this.resources.resErrSaveTemplate);
        }
        if (n != 0) {
            PropertyValue[] propertyValueArray;
            try {
                this.topicsControl.saveTopics(this.agenda);
                propertyValueArray = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Agenda", true);
                this.agenda.writeConfiguration(propertyValueArray, "cp_");
                Configuration.commit(propertyValueArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.agendaTemplate.finish(this.topicsControl.getTopicsData());
            try {
                propertyValueArray = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = AgendaWizardDialogImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.agendaTemplate.document);
                propertyValueArray.store();
            }
            catch (Exception exception) {
                SystemDialog.showMessageBox(this.xMSF, "ErrBox", 0x400000, this.resources.resErrSaveTemplate);
                exception.printStackTrace();
            }
            this.xWindow.setVisible(false);
            running = false;
            this.closeDocument();
            this.agendaTemplate.xTextDocument.unlockControllers();
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "AsTemplate";
            propertyValueArray[0].Value = this.agenda.cp_ProceedMethod == 1 ? Boolean.TRUE : Boolean.FALSE;
            Object object = OfficeDocument.load((XInterface)Desktop.getDesktop(this.xMSF), this.agenda.cp_TemplatePath, "_default", new PropertyValue[0]);
            xTextDocument = (XTextDocument)object;
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = AgendaWizardDialogImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)xTextDocument);
            ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
            try {
                viewHandler.setViewSetting("ZoomType", new Short(0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.agendaTemplate.xTextDocument.unlockControllers();
            return;
        }
    }

    private void closeDocument() {
        try {
            this.xComponent.dispose();
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XCloseable == null ? (class$com$sun$star$util$XCloseable = AgendaWizardDialogImpl.class$("com.sun.star.util.XCloseable")) : class$com$sun$star$util$XCloseable), (Object)this.agendaTemplate.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RedrawListener
    implements DataAware.Listener {
        private String itemName;

        public RedrawListener(String string) {
            this.itemName = string;
        }

        public void eventPerformed(Object object) {
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.lockControllers();
            AgendaWizardDialogImpl.this.agendaTemplate.redraw(this.itemName);
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.unlockControllers();
        }
    }
}

