/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.awt.Size;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.media.XPlayer;
import com.sun.star.media.XPlayerWindow;
import com.sun.star.media.ZoomLevel;
import com.sun.star.uno.AnyConverter;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.StopAtTimeEvent;
import javax.media.Time;

public class Player
implements ControllerListener,
XServiceInfo,
XPlayer,
XComponent {
    private String maURL;
    private javax.media.Player maPlayer;
    private GainControl maGainControl;
    private boolean mbStarted = false;
    private boolean mbLooping = false;
    private static final String s_implName = "com.sun.star.comp.Player_Java";
    private static final String s_serviceName = "com.sun.star.media.Player_Java";

    public Player(javax.media.Player player) {
        this.maPlayer = player;
        this.maPlayer.addControllerListener((ControllerListener)this);
        this.maGainControl = this.maPlayer.getGainControl();
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof EndOfMediaEvent || controllerEvent instanceof StopAtTimeEvent) {
            this.mbStarted = false;
            if (this.mbLooping) {
                this.setMediaTime(0.0);
                this.start();
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                this.setMediaTime(this.getDuration());
            }
        }
    }

    public synchronized void start() {
        if (!this.mbStarted) {
            this.maPlayer.start();
            this.mbStarted = true;
        }
    }

    public synchronized void stop() {
        if (this.mbStarted) {
            this.maPlayer.stop();
            this.mbStarted = false;
        }
    }

    public synchronized boolean isPlaying() {
        return this.mbStarted;
    }

    public synchronized double getDuration() {
        return this.maPlayer.getDuration().getSeconds();
    }

    public synchronized void setMediaTime(double d) {
        if (d >= 0.0 && d <= this.getDuration()) {
            this.maPlayer.setMediaTime(new Time(d));
        }
    }

    public synchronized double getMediaTime() {
        return this.maPlayer.getMediaTime().getSeconds();
    }

    public synchronized void setStopTime(double d) {
        boolean bl = this.mbStarted;
        if (this.mbStarted) {
            this.stop();
        }
        this.maPlayer.setStopTime(new Time(d));
        if (bl) {
            this.start();
        }
    }

    public synchronized double getStopTime() {
        return this.maPlayer.getStopTime().getSeconds();
    }

    public synchronized void setRate(double d) {
        boolean bl = this.mbStarted;
        if (this.mbStarted) {
            this.stop();
        }
        this.maPlayer.setRate((float)d);
        if (bl) {
            this.start();
        }
    }

    public synchronized double getRate() {
        return this.maPlayer.getRate();
    }

    public synchronized void setPlaybackLoop(boolean bl) {
        this.mbLooping = bl;
    }

    public synchronized boolean isPlaybackLoop() {
        return this.mbLooping;
    }

    public synchronized void setVolumeDB(short s) {
        if (this.maGainControl != null) {
            this.maGainControl.setDB((float)s);
        }
    }

    public synchronized short getVolumeDB() {
        return this.maGainControl != null ? (short)this.maGainControl.getDB() : (short)0;
    }

    public synchronized void setMute(boolean bl) {
        if (this.maGainControl != null) {
            this.maGainControl.setMute(bl);
        }
    }

    public synchronized boolean isMute() {
        return this.maGainControl != null ? this.maGainControl.getMute() : false;
    }

    public synchronized Size getPreferredPlayerWindowSize() {
        Component component = this.maPlayer.getVisualComponent();
        Size size = new Size(0, 0);
        if (component != null) {
            Dimension dimension = component.getPreferredSize();
            size.Width = Math.max(dimension.width, 0);
            size.Height = Math.max(dimension.height, 0);
        }
        return size;
    }

    public synchronized XPlayerWindow createPlayerWindow(Object[] objectArray) {
        try {
            PlayerWindow playerWindow;
            PlayerWindow playerWindow2 = playerWindow = objectArray.length > 1 && AnyConverter.toInt((Object)objectArray[0]) > 0 ? new PlayerWindow(objectArray, this.maPlayer) : null;
            if (playerWindow != null && playerWindow.getZoomLevel() == ZoomLevel.NOT_AVAILABLE) {
                playerWindow = null;
            }
            return playerWindow;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public synchronized void addEventListener(XEventListener xEventListener) {
    }

    public synchronized void removeEventListener(XEventListener xEventListener) {
    }

    public synchronized void dispose() {
        if (this.maPlayer != null) {
            this.maPlayer.stop();
            this.maPlayer.close();
            this.maPlayer = null;
        }
    }

    public synchronized String getImplementationName() {
        return s_implName;
    }

    public synchronized String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public synchronized boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

