/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import org.hsqldb.lib.FileStorage;
import org.hsqldb.util.ConnectionDialog;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferCommon;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferSQLText;
import org.hsqldb.util.TransferTable;

public class Transfer
extends Applet
implements WindowListener,
ActionListener,
ItemListener,
Traceable {
    Frame fMain;
    Image imgEmpty;
    DataAccessPoint sourceDb;
    DataAccessPoint targetDb;
    TransferTable tCurrent;
    int iMaxRows;
    int iSelectionStep;
    Vector tTable;
    List lTable;
    String[] sSourceSchemas;
    String sSourceCatalog;
    String sDestSchema;
    String sDestCatalog;
    TextField tSourceTable;
    TextField tDestTable;
    TextField tDestDropIndex;
    TextField tDestCreateIndex;
    TextField tDestDrop;
    TextField tDestCreate;
    TextField tDestDelete;
    TextField tDestAlter;
    TextField tSourceSelect;
    TextField tDestInsert;
    Checkbox cTransfer;
    Checkbox cDrop;
    Checkbox cCreate;
    Checkbox cDelete;
    Checkbox cInsert;
    Checkbox cAlter;
    Checkbox cCreateIndex;
    Checkbox cDropIndex;
    Checkbox cFKForced;
    Checkbox cIdxForced;
    Button bStart;
    Button bContinue;
    TextField tMessage;
    int iTransferMode;
    static boolean bMustExit;
    int CurrentTransfer;
    int CurrentAlter;
    static final int SELECT_SOURCE_CATALOG = 1;
    static final int SELECT_SOURCE_SCHEMA = 2;
    static final int SELECT_DEST_CATALOG = 3;
    static final int SELECT_DEST_SCHEMA = 4;
    static final int SELECT_SOURCE_TABLES = 5;
    static final int TRFM_TRANSFER = 1;
    static final int TRFM_DUMP = 2;
    static final int TRFM_RESTORE = 3;

    public void trace(String string) {
        if (string != null && !string.equals("")) {
            this.tMessage.setText(string);
            if (Traceable.TRACE) {
                System.out.println(string);
            }
        }
    }

    public void init() {
        Transfer transfer = new Transfer();
        transfer._main(null);
    }

    public static void work(String[] stringArray) {
        Transfer transfer = new Transfer();
        transfer._main(stringArray);
    }

    public static void main(String[] stringArray) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        bMustExit = true;
        Transfer.work(stringArray);
    }

    private boolean CatalogToSelect() {
        Vector vector = null;
        try {
            this.lTable.removeAll();
            if (this.iSelectionStep == 1) {
                vector = this.sourceDb.getCatalog();
            } else if (this.iSelectionStep == 3) {
                vector = this.targetDb.getCatalog();
            } else {
                this.Exit();
            }
            if (vector.size() > 1) {
                this.lTable.setMultipleMode(true);
                if (this.iSelectionStep == 1) {
                    this.bStart.setLabel("Select Catalog: Source");
                } else {
                    this.bStart.setLabel("Select Catalog: Destination");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(true);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.lTable.add(enumeration.nextElement().toString());
                }
            } else {
                if (vector.size() == 1) {
                    if (this.iSelectionStep == 1) {
                        this.sSourceCatalog = (String)vector.firstElement();
                        this.sSourceSchemas = null;
                    } else {
                        this.sDestCatalog = (String)vector.firstElement();
                        this.sDestSchema = null;
                    }
                } else if (this.iSelectionStep == 1) {
                    this.sSourceCatalog = null;
                    this.sSourceSchemas = null;
                } else {
                    this.sDestCatalog = null;
                    this.sDestSchema = null;
                }
                if (this.iSelectionStep == 3 && this.sDestCatalog != null) {
                    try {
                        this.targetDb.setCatalog(this.sDestCatalog);
                    }
                    catch (Exception exception) {
                        this.trace("Catalog " + this.sSourceCatalog + " could not be selected in the target database");
                        this.sSourceCatalog = null;
                    }
                }
                ++this.iSelectionStep;
                this.ProcessNextStep();
                return false;
            }
            this.lTable.repaint();
            this.trace("Select correct Catalog");
        }
        catch (Exception exception) {
            this.lTable.removeAll();
            this.trace("Exception reading catalog: " + exception);
            exception.printStackTrace();
        }
        return this.lTable.getItemCount() > 0;
    }

    private boolean SchemaToSelect() {
        Vector vector = null;
        try {
            this.lTable.removeAll();
            if (this.iSelectionStep == 2) {
                vector = this.sourceDb.getSchemas();
            } else if (this.iSelectionStep == 4) {
                vector = this.targetDb.getSchemas();
            } else {
                this.Exit();
            }
            if (vector.size() > 1) {
                this.lTable.setMultipleMode(true);
                if (this.iSelectionStep == 2) {
                    this.bStart.setLabel("Select Schema: Source");
                } else {
                    this.bStart.setLabel("Select Schema: Destination");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(true);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.lTable.add(enumeration.nextElement().toString());
                }
            } else {
                if (vector.size() == 1) {
                    if (this.iSelectionStep == 2) {
                        this.sSourceSchemas = new String[1];
                        this.sSourceSchemas[0] = (String)vector.firstElement();
                    } else {
                        this.sDestSchema = (String)vector.firstElement();
                    }
                } else if (this.iSelectionStep == 2) {
                    this.sSourceSchemas = null;
                } else {
                    this.sDestSchema = null;
                }
                this.iSelectionStep = this.iTransferMode == 2 ? 5 : ++this.iSelectionStep;
                this.ProcessNextStep();
                return false;
            }
            this.lTable.repaint();
            this.trace("Select correct Schema or load Settings file");
        }
        catch (Exception exception) {
            this.lTable.removeAll();
            this.trace("Exception reading schemas: " + exception);
            exception.printStackTrace();
        }
        return this.lTable.getItemCount() > 0;
    }

    void _main(String[] stringArray) {
        this.iTransferMode = 1;
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray[0].toLowerCase().equals("-r") || stringArray[0].toLowerCase().equals("--restore")) {
                this.iTransferMode = 3;
            } else if (stringArray[0].toLowerCase().equals("-d") || stringArray[0].toLowerCase().equals("--dump")) {
                this.iTransferMode = 2;
            }
        }
        this.fMain = new Frame("HSQL Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        this.fMain.setSize(640, 480);
        this.fMain.add("Center", this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray2 = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows", "-", "Load Settings...", "Save Settings...", "-", "Exit"};
        Menu menu = new Menu("Options");
        this.addMenuItems(menu, stringArray2);
        menuBar.add(menu);
        this.fMain.setMenuBar(menuBar);
        this.initGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        if (dimension.width >= 640) {
            this.fMain.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(dimension);
        }
        this.fMain.setVisible(true);
        this.CurrentAlter = 0;
        this.CurrentTransfer = 0;
        try {
            String string;
            String string2;
            FileDialog fileDialog;
            if (this.iTransferMode == 2 || this.iTransferMode == 1) {
                this.sourceDb = new TransferDb(ConnectionDialog.createConnection(this.fMain, "Source Database"), this);
                if (!this.sourceDb.isConnected()) {
                    this.Exit();
                    return;
                }
            } else {
                fileDialog = new FileDialog(this.fMain, "Restore FileName", 0);
                fileDialog.show();
                string2 = fileDialog.getFile();
                string = fileDialog.getDirectory();
                if (string2 == null || string2.equals("")) {
                    this.Exit();
                    return;
                }
                this.sourceDb = new TransferSQLText(string + string2, this);
            }
            if (this.iTransferMode == 3 || this.iTransferMode == 1) {
                this.targetDb = new TransferDb(ConnectionDialog.createConnection(this.fMain, "Target Database"), this);
                if (!this.targetDb.isConnected()) {
                    this.Exit();
                    return;
                }
            } else {
                fileDialog = new FileDialog(this.fMain, "Dump FileName", 1);
                fileDialog.show();
                string2 = fileDialog.getFile();
                string = fileDialog.getDirectory();
                if (string2 == null || string2.equals("")) {
                    this.Exit();
                    return;
                }
                this.targetDb = new TransferSQLText(string + string2, this);
            }
        }
        catch (Exception exception) {
            this.Exit();
            exception.printStackTrace();
            return;
        }
        if (this.iTransferMode == 2 || this.iTransferMode == 1) {
            this.iSelectionStep = 1;
            this.sSourceCatalog = null;
        } else {
            this.iSelectionStep = 3;
            this.sDestCatalog = null;
        }
        this.ProcessNextStep();
        this.fMain.show();
    }

    private void RefreshMainDisplay() {
        this.lTable.removeAll();
        this.lTable.repaint();
        try {
            this.tTable = this.sourceDb.getTables(this.sSourceCatalog, this.sSourceSchemas);
            for (int i = 0; i < this.tTable.size(); ++i) {
                TransferTable transferTable = (TransferTable)this.tTable.elementAt(i);
                transferTable.setDest(this.sDestSchema, this.targetDb);
                transferTable.extractTableStructure(this.sourceDb, this.targetDb);
                this.lTable.add(transferTable.Stmts.sSourceTable);
                this.lTable.select(i);
                this.displayTable(transferTable);
            }
            this.bStart.setEnabled(true);
            if (this.iTransferMode == 1) {
                this.trace("Edit definitions and press [Start Transfer]");
            } else if (this.iTransferMode == 2) {
                this.trace("Edit definitions and press [Start Dump]");
            }
        }
        catch (Exception exception) {
            this.trace("Exception reading source tables: " + exception);
            exception.printStackTrace();
        }
        this.fMain.show();
    }

    private void addMenuItems(Menu menu, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            MenuItem menuItem = new MenuItem(stringArray[i]);
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.lTable) {
            if (this.iSelectionStep == 5) {
                String string = this.lTable.getSelectedItem();
                int n = (Integer)itemEvent.getItem();
                for (int i = 0; i < this.tTable.size(); ++i) {
                    TransferTable transferTable = (TransferTable)this.tTable.elementAt(i);
                    if (transferTable == null || i != n) continue;
                    this.saveTable();
                    this.displayTable(transferTable);
                    this.updateEnabled(true);
                }
            }
        } else {
            this.saveTable();
            this.updateEnabled(true);
        }
    }

    private void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        TransferTable transferTable = this.tCurrent;
        transferTable.Stmts.sSourceTable = this.tSourceTable.getText();
        transferTable.Stmts.sDestTable = this.tDestTable.getText();
        transferTable.Stmts.sDestDrop = this.tDestDrop.getText();
        transferTable.Stmts.sDestCreateIndex = this.tDestCreateIndex.getText();
        transferTable.Stmts.sDestDropIndex = this.tDestDropIndex.getText();
        transferTable.Stmts.sDestCreate = this.tDestCreate.getText();
        transferTable.Stmts.sDestDelete = this.tDestDelete.getText();
        transferTable.Stmts.sSourceSelect = this.tSourceSelect.getText();
        transferTable.Stmts.sDestInsert = this.tDestInsert.getText();
        transferTable.Stmts.sDestAlter = this.tDestAlter.getText();
        transferTable.Stmts.bTransfer = this.cTransfer.getState();
        transferTable.Stmts.bDrop = this.cDrop.getState();
        transferTable.Stmts.bCreate = this.cCreate.getState();
        transferTable.Stmts.bDelete = this.cDelete.getState();
        transferTable.Stmts.bInsert = this.cInsert.getState();
        transferTable.Stmts.bAlter = this.cAlter.getState();
        transferTable.Stmts.bCreateIndex = this.cCreateIndex.getState();
        transferTable.Stmts.bDropIndex = this.cDropIndex.getState();
        if (!transferTable.Stmts.bTransfer) {
            transferTable.Stmts.bInsert = false;
            this.cInsert.setState(false);
        }
        boolean bl = transferTable.Stmts.bFKForced != this.cFKForced.getState() || transferTable.Stmts.bIdxForced != this.cIdxForced.getState();
        transferTable.Stmts.bFKForced = this.cFKForced.getState();
        transferTable.Stmts.bIdxForced = this.cIdxForced.getState();
        if (bl) {
            try {
                this.sourceDb.getTableStructure(transferTable, this.targetDb);
            }
            catch (Exception exception) {
                this.trace("Exception reading source tables: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void displayTable(TransferTable transferTable) {
        this.tCurrent = transferTable;
        if (transferTable == null) {
            return;
        }
        this.tSourceTable.setText(transferTable.Stmts.sSourceTable);
        this.tDestTable.setText(transferTable.Stmts.sDestTable);
        this.tDestDrop.setText(transferTable.Stmts.sDestDrop);
        this.tDestCreateIndex.setText(transferTable.Stmts.sDestCreateIndex);
        this.tDestDropIndex.setText(transferTable.Stmts.sDestDropIndex);
        this.tDestCreate.setText(transferTable.Stmts.sDestCreate);
        this.tDestDelete.setText(transferTable.Stmts.sDestDelete);
        this.tSourceSelect.setText(transferTable.Stmts.sSourceSelect);
        this.tDestInsert.setText(transferTable.Stmts.sDestInsert);
        this.tDestAlter.setText(transferTable.Stmts.sDestAlter);
        this.cTransfer.setState(transferTable.Stmts.bTransfer);
        this.cDrop.setState(transferTable.Stmts.bDrop);
        this.cCreate.setState(transferTable.Stmts.bCreate);
        this.cDropIndex.setState(transferTable.Stmts.bDropIndex);
        this.cCreateIndex.setState(transferTable.Stmts.bCreateIndex);
        this.cDelete.setState(transferTable.Stmts.bDelete);
        this.cInsert.setState(transferTable.Stmts.bInsert);
        this.cAlter.setState(transferTable.Stmts.bAlter);
        this.cFKForced.setState(transferTable.Stmts.bFKForced);
        this.cIdxForced.setState(transferTable.Stmts.bIdxForced);
    }

    private void updateEnabled(boolean bl) {
        boolean bl2 = this.cTransfer.getState();
        this.tDestTable.setEnabled(bl && bl2);
        this.tDestDrop.setEnabled(bl && bl2 && this.cDrop.getState());
        this.tDestCreate.setEnabled(bl && bl2 && this.cCreate.getState());
        this.tDestDelete.setEnabled(bl && bl2 && this.cDelete.getState());
        this.tDestCreateIndex.setEnabled(bl && bl2 && this.cCreateIndex.getState());
        this.tDestDropIndex.setEnabled(bl && bl2 && this.cDropIndex.getState());
        this.tSourceSelect.setEnabled(bl && bl2);
        this.tDestInsert.setEnabled(bl && bl2 && this.cInsert.getState());
        this.tDestAlter.setEnabled(bl && bl2 && this.cAlter.getState());
        this.cDrop.setEnabled(bl && bl2);
        this.cCreate.setEnabled(bl && bl2);
        this.cDelete.setEnabled(bl && bl2);
        this.cCreateIndex.setEnabled(bl && bl2);
        this.cDropIndex.setEnabled(bl && bl2);
        this.cInsert.setEnabled(bl && bl2);
        this.cAlter.setEnabled(bl && bl2);
        this.cFKForced.setEnabled(this.cAlter.getState());
        this.cIdxForced.setEnabled(this.cCreateIndex.getState());
        this.bStart.setEnabled(bl);
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(bl);
        }
    }

    private void ProcessNextStep() {
        switch (this.iSelectionStep) {
            case 1: 
            case 3: {
                if (!this.CatalogToSelect()) break;
                this.fMain.show();
                return;
            }
            case 2: 
            case 4: {
                if (!this.SchemaToSelect()) break;
                this.fMain.show();
                return;
            }
            case 5: {
                if (this.iTransferMode == 1) {
                    this.bStart.setLabel("Start Transfer");
                } else if (this.iTransferMode == 2) {
                    this.bStart.setLabel("Start Dump");
                } else if (this.iTransferMode == 3) {
                    this.bStart.setLabel("Start Restore");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(false);
                this.lTable.setMultipleMode(false);
                this.RefreshMainDisplay();
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof TextField) {
            this.saveTable();
            return;
        }
        String string = actionEvent.getActionCommand();
        MenuItem menuItem = new MenuItem();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            menuItem = (MenuItem)actionEvent.getSource();
            string = menuItem.getLabel();
        }
        if (string.equals("Start Transfer") || string.equals("ReStart Transfer")) {
            this.bStart.setLabel("ReStart Transfer");
            this.bStart.invalidate();
            this.CurrentTransfer = 0;
            this.CurrentAlter = 0;
            this.transfer();
        } else if (string.equals("Continue Transfer")) {
            this.transfer();
        } else if (string.equals("Start Dump") || string.equals("Start Restore")) {
            this.CurrentTransfer = 0;
            this.CurrentAlter = 0;
            this.transfer();
        } else if (string.equals("Quit")) {
            this.Exit();
        } else if (string.indexOf("Select Schema") >= 0) {
            String[] stringArray = this.lTable.getSelectedItems();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            if (this.iSelectionStep == 2) {
                this.sSourceSchemas = stringArray;
            } else {
                this.sDestSchema = stringArray[0];
            }
            this.iSelectionStep = this.iTransferMode == 2 ? 5 : ++this.iSelectionStep;
            this.ProcessNextStep();
        } else if (string.indexOf("Select Catalog") >= 0) {
            String string2 = this.lTable.getSelectedItem();
            if (string2 == null || string2.equals("")) {
                return;
            }
            if (this.iSelectionStep == 1) {
                this.sSourceCatalog = string2;
                this.sSourceSchemas = null;
            } else {
                this.sDestCatalog = string2;
                this.sDestSchema = null;
                try {
                    this.targetDb.setCatalog(this.sDestCatalog);
                }
                catch (Exception exception) {
                    this.trace("Catalog " + this.sDestCatalog + " could not be selected in the target database");
                    this.sDestCatalog = null;
                }
            }
            ++this.iSelectionStep;
            this.ProcessNextStep();
        } else if (string.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (string.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (string.equals("Insert all rows")) {
            this.iMaxRows = 0;
        } else if (string.equals("Load Settings...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Load Settings", 0);
            fileDialog.show();
            String string3 = fileDialog.getDirectory() + fileDialog.getFile();
            if (string3 != null) {
                this.LoadPrefs(string3);
                this.displayTable(this.tCurrent);
            }
        } else if (string.equals("Save Settings...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Settings", 1);
            fileDialog.show();
            String string4 = fileDialog.getDirectory() + fileDialog.getFile();
            if (string4 != null) {
                this.SavePrefs(string4);
            }
        } else if (string.equals("Exit")) {
            this.windowClosing(null);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    private void cleanup() {
        try {
            if (this.sourceDb != null) {
                this.sourceDb.close();
            }
            if (this.targetDb != null) {
                this.targetDb.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void initGUI() {
        Font font = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new GridLayout(16, 1));
        this.tSourceTable = new TextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new TextField();
        this.tDestTable.addActionListener(this);
        this.tDestDrop = new TextField();
        this.tDestDrop.addActionListener(this);
        this.tDestCreate = new TextField();
        this.tDestCreate.addActionListener(this);
        this.tDestDelete = new TextField();
        this.tDestDelete.addActionListener(this);
        this.tDestCreateIndex = new TextField();
        this.tDestCreateIndex.addActionListener(this);
        this.tDestDropIndex = new TextField();
        this.tDestDropIndex.addActionListener(this);
        this.tSourceSelect = new TextField();
        this.tSourceSelect.addActionListener(this);
        this.tDestInsert = new TextField();
        this.tDestInsert.addActionListener(this);
        this.tDestAlter = new TextField();
        this.tDestAlter.addActionListener(this);
        this.cTransfer = new Checkbox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new Checkbox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new Checkbox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDropIndex = new Checkbox("Drop destination index (ignore error)", true);
        this.cDropIndex.addItemListener(this);
        this.cIdxForced = new Checkbox("force Idx_ prefix for indexes names", false);
        this.cIdxForced.addItemListener(this);
        this.cCreateIndex = new Checkbox("Create destination index", true);
        this.cCreateIndex.addItemListener(this);
        this.cDelete = new Checkbox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new Checkbox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        this.cFKForced = new Checkbox("force FK_ prefix for foreign key names", false);
        this.cFKForced.addItemListener(this);
        this.cAlter = new Checkbox("Alter destination table", true);
        this.cAlter.addItemListener(this);
        panel.add(this.createLabel("Source table"));
        panel.add(this.tSourceTable);
        panel.add(this.cTransfer);
        panel.add(this.tDestTable);
        panel.add(this.cDrop);
        panel.add(this.tDestDrop);
        panel.add(this.cCreate);
        panel.add(this.tDestCreate);
        panel.add(this.cDropIndex);
        panel.add(this.tDestDropIndex);
        panel.add(this.cCreateIndex);
        panel.add(this.tDestCreateIndex);
        panel.add(this.cDelete);
        panel.add(this.tDestDelete);
        panel.add(this.cAlter);
        panel.add(this.tDestAlter);
        panel.add(this.createLabel("Select source records"));
        panel.add(this.tSourceSelect);
        panel.add(this.cInsert);
        panel.add(this.tDestInsert);
        panel.add(this.createLabel(""));
        panel.add(this.createLabel(""));
        panel.add(this.cIdxForced);
        panel.add(this.cFKForced);
        panel.add(this.createLabel(""));
        panel.add(this.createLabel(""));
        if (this.iTransferMode == 1) {
            this.bStart = new Button("Start Transfer");
            this.bContinue = new Button("Continue Transfer");
            this.bContinue.setEnabled(false);
        } else if (this.iTransferMode == 2) {
            this.bStart = new Button("Start Dump");
        } else if (this.iTransferMode == 3) {
            this.bStart = new Button("Start Restore");
        }
        this.bStart.addActionListener(this);
        panel.add(this.bStart);
        if (this.iTransferMode == 1) {
            this.bContinue.addActionListener(this);
            panel.add(this.bContinue);
        }
        this.bStart.setEnabled(false);
        this.fMain.add("Center", this.createBorderPanel(panel));
        this.lTable = new List(10);
        this.lTable.addItemListener(this);
        this.fMain.add("West", this.createBorderPanel(this.lTable));
        this.tMessage = new TextField();
        Panel panel2 = this.createBorderPanel(this.tMessage);
        this.fMain.add("South", panel2);
    }

    private Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("South", this.createLabel(""));
        panel.add("East", this.createLabel(""));
        panel.add("West", this.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    private Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    private void SavePrefs(String string) {
        this.saveTable();
        TransferCommon.savePrefs(string, this.sourceDb, this.targetDb, this, this.tTable, new FileStorage());
    }

    private void LoadPrefs(String string) {
        TransferTable transferTable;
        this.trace("Parsing Settings file");
        this.bStart.setEnabled(false);
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(false);
        }
        this.tTable = TransferCommon.loadPrefs(string, this.sourceDb, this.targetDb, this, new FileStorage());
        this.iSelectionStep = 5;
        this.lTable.removeAll();
        for (int i = 0; i < this.tTable.size(); ++i) {
            transferTable = (TransferTable)this.tTable.elementAt(i);
            this.lTable.add(transferTable.Stmts.sSourceTable);
        }
        transferTable = (TransferTable)this.tTable.elementAt(0);
        this.displayTable(transferTable);
        this.lTable.select(0);
        this.updateEnabled(true);
        this.lTable.invalidate();
        if (this.iTransferMode == 1) {
            this.bStart.setLabel("Start Transfer");
            this.trace("Edit definitions and press [Start Transfer]");
        } else if (this.iTransferMode == 2) {
            this.bStart.setLabel("Start Dump");
            this.trace("Edit definitions and press [Start Dump]");
        } else if (this.iTransferMode == 3) {
            this.bStart.setLabel("Start Restore");
            this.trace("Edit definitions and press [Start Restore]");
        }
        this.bStart.invalidate();
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(false);
        }
    }

    private void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        int n = this.CurrentTransfer;
        int n2 = this.CurrentAlter;
        TransferTable transferTable = null;
        long l = System.currentTimeMillis();
        try {
            int n3;
            for (n3 = n; n3 < this.tTable.size(); ++n3) {
                this.CurrentTransfer = n3;
                transferTable = (TransferTable)this.tTable.elementAt(n3);
                this.lTable.select(n3);
                this.displayTable(transferTable);
                transferTable.transferStructure();
                transferTable.transferData(this.iMaxRows);
            }
            for (n3 = n2; n3 < this.tTable.size(); ++n3) {
                this.CurrentAlter = n3;
                transferTable = (TransferTable)this.tTable.elementAt(n3);
                this.lTable.select(n3);
                this.displayTable(transferTable);
                transferTable.transferAlter();
            }
            long l2 = System.currentTimeMillis();
            this.trace("Transfer finished successfully in: " + (double)(l2 - l) / 1000.0 + " sec");
            if (this.iTransferMode == 1) {
                this.bContinue.setLabel("Quit");
                this.bContinue.setEnabled(true);
                this.bContinue.invalidate();
            } else {
                this.bStart.setLabel("Quit");
                this.bStart.setEnabled(true);
                this.bStart.invalidate();
            }
        }
        catch (Exception exception) {
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " /  / Error: " + exception.getMessage());
            exception.printStackTrace();
        }
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(this.CurrentAlter < this.tTable.size());
        }
        this.updateEnabled(true);
        System.gc();
    }

    protected void Exit() {
        this.cleanup();
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }
}

