/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.scriptio.ScriptWriterBinary;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.scriptio.ScriptWriterZipped;

public abstract class ScriptWriterBase {
    protected Database db;
    String outFile;
    OutputStream fileStreamOut;
    int tableRowCount;
    boolean includeCachedData;
    long byteCount;
    int writeDelay;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    static final int INSERT = 0;
    int sessionId;
    public static String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    public static final int SCRIPT_TEXT_170 = 0;
    public static final int SCRIPT_BINARY_172 = 1;
    public static final int SCRIPT_ZIPPED_BINARY_172 = 3;

    public static ScriptWriterBase newScriptWriter(Database database, String string, boolean bl, boolean bl2, int n) throws HsqlException {
        if (n == 0) {
            return new ScriptWriterText(database, string, bl, bl2);
        }
        if (n == 1) {
            return new ScriptWriterBinary(database, string, bl, bl2);
        }
        return new ScriptWriterZipped(database, string, bl, bl2);
    }

    ScriptWriterBase(Database database, String string, boolean bl, boolean bl2) throws HsqlException {
        this.initBuffers();
        try {
            if (database.getFileAccess().isStreamElement(string)) {
                if (bl2) {
                    throw Trace.error(29, string);
                }
                InputStream inputStream = database.getFileAccess().openInputStreamElement(string);
                this.byteCount = inputStream.available();
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.db = database;
        this.includeCachedData = bl;
        this.outFile = string;
        this.openFile();
    }

    protected abstract void initBuffers();

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public synchronized void sync() {
        if (this.needsSync) {
            if (this.busyWriting) {
                this.forceSync = true;
                return;
            }
            try {
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.flush();
                }
            }
            catch (IOException iOException) {
                Trace.printSystemOut("flush() or sync() error: " + iOException.getMessage());
            }
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    public void close() throws HsqlException {
        try {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.flush();
                this.fileStreamOut.close();
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() throws HsqlException {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    protected void openFile() throws HsqlException {
        try {
            OutputStream outputStream = this.db.getFileAccess().openOutputStreamElement(this.outFile);
            this.fileStreamOut = new BufferedOutputStream(outputStream, 8192);
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.outFile);
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException, HsqlException {
        Result result = DatabaseScript.getScript(this.db, !this.includeCachedData);
        this.writeSingleColumnResult(result);
    }

    protected void writeExistingData() throws HsqlException, IOException {
        boolean bl = false;
        HsqlArrayList hsqlArrayList = this.db.getTables();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            boolean bl2 = false;
            switch (table.getTableType()) {
                case 3: {
                    bl2 = true;
                    break;
                }
                case 4: {
                    bl2 = this.includeCachedData;
                    break;
                }
                case 6: {
                    bl2 = this.includeCachedData && !table.isReadOnly();
                }
            }
            try {
                if (!bl2) continue;
                this.writeTableInit(table);
                Iterator iterator = table.iterator();
                while (iterator.hasNext()) {
                    this.writeRow(0, table, (Object[])iterator.next());
                }
                this.writeTableTerm(table);
                continue;
            }
            catch (Exception exception) {
                throw Trace.error(38, exception.getMessage());
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table table) throws HsqlException, IOException {
    }

    protected void writeTableTerm(Table table) throws HsqlException, IOException {
        if (table.isDataReadOnly() && !table.isTemp() && !table.isText()) {
            StringBuffer stringBuffer = new StringBuffer("SET TABLE ");
            stringBuffer.append(table.getName().statementName);
            stringBuffer.append(" READONLY TRUE");
            this.writeLogStatement(stringBuffer.toString(), this.sessionId);
        }
    }

    protected void writeSingleColumnResult(Result result) throws HsqlException, IOException {
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            this.writeLogStatement((String)objectArray[0], this.sessionId);
        }
    }

    abstract void writeRow(int var1, Table var2, Object[] var3) throws HsqlException, IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void writeSessionId(int var1) throws IOException;

    abstract void writeLogStatement(String var1, int var2) throws IOException, HsqlException;
}

