/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.lib.FileAccess;

public class FileStorage
implements FileAccess {
    String filename;

    public boolean isStreamElement(String string) throws NoSuchElementException, IOException {
        try {
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            throw FileStorage.toIOException(throwable);
        }
    }

    public InputStream openInputStreamElement(String string) throws IOException {
        try {
            return new FileInputStream(new File(string));
        }
        catch (Throwable throwable) {
            throw FileStorage.toIOException(throwable);
        }
    }

    static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public void createParentDirs(String string) {
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            new File(string2).mkdirs();
        } else {
            string2 = file.getPath();
            int n = string2.lastIndexOf(47);
            if (n > 0) {
                string2 = string2.substring(0, n);
                new File(string2).mkdirs();
            }
        }
    }

    public void removeElement(String string) throws NoSuchElementException, IOException {
        if (this.isStreamElement(string)) {
            FileStorage.delete(string);
        }
    }

    public void renameElement(String string, String string2) throws NoSuchElementException, IOException {
        if (!this.isStreamElement(string) || this.isStreamElement(string2)) {
            throw new IOException();
        }
        FileStorage.renameOverwrite(string, string2);
    }

    static void delete(String string) throws IOException {
        try {
            new File(string).delete();
        }
        catch (Throwable throwable) {
            throw FileStorage.toIOException(throwable);
        }
    }

    static void renameOverwrite(String string, String string2) throws IOException {
        try {
            if (FileStorage.exists(string)) {
                FileStorage.delete(string2);
                File file = new File(string);
                file.renameTo(new File(string2));
            }
        }
        catch (Throwable throwable) {
            throw FileStorage.toIOException(throwable);
        }
    }

    static boolean exists(String string) throws IOException {
        try {
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            throw FileStorage.toIOException(throwable);
        }
    }

    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new FileOutputStream(new File(string));
    }
}

