/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.DataFileCache;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.PointerCachedDataRow;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;

public class TextCache
extends DataFileCache {
    protected boolean isIndexingSource;
    public static final String NL = System.getProperty("line.separator");
    String fs;
    String vs;
    String lvs;
    String stringEncoding;
    protected boolean readOnly;
    protected RowInputText rowIn;
    protected boolean isQuoted;
    protected boolean isAllQuoted;
    protected boolean ignoreFirst;
    protected String ignoredFirst = NL;
    protected Table table;

    TextCache(String string, Table table) throws HsqlException {
        super(string, table.database);
        this.table = table;
    }

    protected void initParams() throws HsqlException {
        this.storeOnInsert = true;
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(this.sName, "=", ";", null);
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                throw Trace.error(75, 172);
            }
            case 1: {
                this.sName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Trace.error(75, 173, hsqlProperties.errorKeys[1]);
            }
        }
        this.fs = this.translateSep(hsqlProperties.getProperty("fs", this.dbProps.getProperty("textdb.fs", ",")));
        this.vs = this.translateSep(hsqlProperties.getProperty("vs", this.dbProps.getProperty("textdb.vs", this.fs)));
        this.lvs = this.translateSep(hsqlProperties.getProperty("lvs", this.dbProps.getProperty("textdb.lvs", this.fs)));
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Trace.error(75, 174);
        }
        this.ignoreFirst = hsqlProperties.isPropertyTrue("ignore_first", this.dbProps.isPropertyTrue("textdb.ignore_first", false));
        this.isQuoted = hsqlProperties.isPropertyTrue("quoted", this.dbProps.isPropertyTrue("textdb.quoted", true));
        this.isAllQuoted = hsqlProperties.isPropertyTrue("all_quoted", this.dbProps.isPropertyTrue("textdb.all_quoted", false));
        this.stringEncoding = this.translateSep(hsqlProperties.getProperty("encoding", this.dbProps.getProperty("textdb.encoding", "ASCII")));
        this.cacheScale = hsqlProperties.getIntegerProperty("cache_scale", this.dbProps.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
        this.cacheSizeScale = hsqlProperties.getIntegerProperty("cache_size_scale", this.dbProps.getIntegerProperty("textdb.cache_size_scale", 12, 8, 20));
        try {
            if (this.isQuoted || this.isAllQuoted) {
                this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
                this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
            } else {
                this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
                this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(75, "invalid file: " + iOException);
        }
    }

    protected void initBuffers() throws HsqlException {
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = 0;
        n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }

    void open(boolean bl) throws HsqlException {
        block4: {
            try {
                this.rFile = ScaledRAFile.newScaledRAFile(this.sName, this.dDatabase.getURLProperties().getProperty("storage_class_name"), this.dDatabase.getURLProperties().getProperty("storage_key"), bl, 1);
                this.iFreePos = (int)this.rFile.length();
                if (this.iFreePos != 0 || !this.ignoreFirst) break block4;
                byte[] byArray = null;
                try {
                    byArray = this.ignoredFirst.getBytes(this.stringEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = this.ignoredFirst.getBytes();
                }
                this.rFile.write(byArray, 0, byArray.length);
                this.iFreePos = this.ignoredFirst.length();
            }
            catch (Exception exception) {
                throw Trace.error(29, 188, new Object[]{this.sName, exception});
            }
        }
        this.readOnly = bl;
    }

    void reopen() throws HsqlException {
        this.open(this.readOnly);
        this.rowIn.reset();
    }

    void close() throws HsqlException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.saveAll();
            boolean bl = this.rFile.length() <= (long)NL.length();
            this.rFile.close();
            this.rFile = null;
            if (bl && !this.readOnly) {
                this.dDatabase.getFileAccess().removeElement(this.sName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 189, new Object[]{this.sName, exception});
        }
    }

    void purge() throws HsqlException {
        if (this.rFile == null) {
            return;
        }
        try {
            if (this.readOnly) {
                this.close();
            } else {
                this.rFile.close();
                this.rFile = null;
                this.dDatabase.getFileAccess().removeElement(this.sName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 190, new Object[]{this.sName, exception});
        }
    }

    void free(CachedRow cachedRow) throws HsqlException {
        if (this.storeOnInsert && !this.isIndexingSource) {
            int n = cachedRow.iPos;
            int n2 = cachedRow.storageSize - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            try {
                hsqlByteArrayOutputStream.fill(32, n2);
                hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
                this.rFile.seek(n);
                this.rFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
            }
            catch (IOException iOException) {
                throw Trace.error(29, iOException.toString());
            }
        }
        this.remove(cachedRow);
    }

    protected void setStorageSize(CachedRow cachedRow) throws HsqlException {
        cachedRow.storageSize = this.rowOut.getSize(cachedRow);
    }

    protected CachedRow makeRow(int n, Table table) throws HsqlException {
        CachedDataRow cachedDataRow = null;
        try {
            ByteArray byteArray = new ByteArray(80);
            boolean bl = true;
            boolean bl2 = false;
            try {
                int n2;
                this.rFile.seek(n);
                while ((n2 = this.rFile.read()) != -1) {
                    int n3 = n2;
                    if (n3 == 10) {
                        byteArray.append(10);
                        if (this.ignoreFirst && n == 0) {
                            this.ignoredFirst = byteArray.toString();
                            bl = true;
                        }
                        if (!bl) {
                            bl2 = true;
                            break;
                        }
                        n += byteArray.length();
                        byteArray.setLength(0);
                        bl = true;
                        this.rowIn.skippedLine();
                        continue;
                    }
                    if (n3 == 13) {
                        try {
                            n2 = this.rFile.read();
                            if (n2 == -1) break;
                            n3 = n2;
                            if (n3 == 10) {
                                byteArray.append(10);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        byteArray.append(10);
                        if (this.ignoreFirst && n == 0) {
                            this.ignoredFirst = byteArray.toString();
                            bl = true;
                        }
                        if (!bl) {
                            bl2 = true;
                            break;
                        }
                        n += byteArray.length();
                        byteArray.setLength(0);
                        bl = true;
                        this.rowIn.skippedLine();
                        continue;
                    }
                    if (n3 != 32) {
                        bl = false;
                    }
                    byteArray.append(n3);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                this.rowIn.setSource(byteArray.toString(), n, byteArray.length());
                cachedDataRow = this.isIndexingSource ? new PointerCachedDataRow(table, this.rowIn) : new CachedDataRow(table, this.rowIn);
            }
        }
        catch (Exception exception) {
            throw Trace.error(76, exception);
        }
        return cachedDataRow;
    }

    int getLineNumber() {
        return this.rowIn.getLineNumber();
    }

    void setSourceIndexing(boolean bl) {
        this.isIndexingSource = bl;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int n) {
            if (this.buflen >= this.buffer.length) {
                byte[] byArray = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buflen);
                this.buffer = byArray;
            }
            this.buffer[this.buflen] = (byte)n;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int n) {
            this.buflen = n;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

