/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import org.hsqldb.Storage;

class ScaledRAFile {
    final Storage storage;
    final int scale;
    final boolean readOnly;
    boolean isNio = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    static ScaledRAFile newScaledRAFile(String string, String string2, Object object, boolean bl, int n) throws FileNotFoundException, IOException {
        return new ScaledRAFile(string, string2, object, bl, n);
    }

    ScaledRAFile(String string, String string2, Object object, boolean bl, int n) throws FileNotFoundException, IOException {
        try {
            if (string2 == null) {
                this.storage = new RandomAccessStorage(string, bl);
            } else {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = ScaledRAFile.class$("java.lang.Object")) : class$java$lang$Object);
                this.storage = (Storage)constructor.newInstance(string, bl ? "r" : "rw", object);
            }
            this.readOnly = bl;
            this.scale = n;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    long length() throws IOException {
        try {
            return this.storage.length();
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    void seek(long l) throws IOException {
        try {
            this.storage.seek(l);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    long getFilePointer() throws IOException {
        try {
            return (this.storage.getFilePointer() + (long)this.scale - 1L) / (long)this.scale;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    int read() throws IOException {
        try {
            return this.storage.read();
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.storage.read(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    int readInt() throws IOException {
        try {
            return this.storage.readInt();
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.storage.write(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    void writeInt(int n) throws IOException {
        try {
            this.storage.writeInt(n);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    void close() throws IOException {
        try {
            this.storage.close();
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class RandomAccessStorage
    implements Storage {
        final RandomAccessFile file;

        public RandomAccessStorage(String string, boolean bl) throws Exception {
            this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        }

        public void close() throws Exception {
            this.file.close();
        }

        public long getFilePointer() throws Exception {
            return this.file.getFilePointer();
        }

        public long length() throws Exception {
            return this.file.length();
        }

        public int read() throws Exception {
            return this.file.read();
        }

        public void read(byte[] byArray, int n, int n2) throws Exception {
            this.file.readFully(byArray, n, n2);
        }

        public int readInt() throws Exception {
            return this.file.readInt();
        }

        public void seek(long l) throws Exception {
            if (this.file.length() < l) {
                this.file.seek(this.file.length());
                for (long i = this.file.length(); i < l; ++i) {
                    this.file.write(0);
                }
            }
            this.file.seek(l);
        }

        public void write(byte[] byArray, int n, int n2) throws Exception {
            this.file.write(byArray, n, n2);
        }

        public void writeInt(int n) throws Exception {
            this.file.writeInt(n);
        }
    }
}

