/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;

class HsqlNameManager {
    private static HsqlNameManager staticManager = new HsqlNameManager();
    private static int serialNumber = 0;
    private int sysNumber = 0;

    HsqlNameManager() {
    }

    static HsqlName newHsqlSystemTableName(String string) {
        return new HsqlName(staticManager, string);
    }

    HsqlName newHsqlName(String string, boolean bl) throws HsqlException {
        return new HsqlName(this, string, bl);
    }

    HsqlName newHsqlName(String string, String string2, boolean bl) throws HsqlException {
        return new HsqlName(this, string, string2, bl);
    }

    HsqlName newHsqlName(String string) {
        return new HsqlName(this, string);
    }

    HsqlName newAutoName(String string) {
        return this.newAutoName(string, null);
    }

    HsqlName newAutoName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            if (string.length() != 0) {
                stringBuffer.append("SYS_");
                stringBuffer.append(string);
                stringBuffer.append('_');
                if (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('_');
                }
                stringBuffer.append(++this.sysNumber);
            }
        } else {
            stringBuffer.append(string2);
        }
        return new HsqlName(this, stringBuffer.toString());
    }

    void resetNumbering() {
        this.sysNumber = 0;
        serialNumber = 0;
    }

    public static class HsqlName {
        HsqlNameManager manager;
        public String name;
        boolean isNameQuoted;
        public String statementName;
        private final int hashCode;

        private HsqlName(HsqlNameManager hsqlNameManager) {
            this.manager = hsqlNameManager;
            this.hashCode = serialNumber++;
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, boolean bl) throws HsqlException {
            this(hsqlNameManager);
            this.rename(string, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, String string2, boolean bl) throws HsqlException {
            this(hsqlNameManager);
            this.rename(string, string2, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string) {
            this(hsqlNameManager);
            this.name = this.statementName = string;
        }

        void rename(String string, boolean bl) throws HsqlException {
            this.name = string;
            this.statementName = string;
            this.isNameQuoted = bl;
            if (string == null || string.length() == 0) {
                throw Trace.error(74);
            }
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string, '\"', true);
            }
            if (string.startsWith("SYS_")) {
                int n = string.lastIndexOf(95) + 1;
                try {
                    int n2;
                    String string2 = string.substring(n);
                    if (string2.matches("[0-9]+") && (n2 = Integer.parseInt(string2)) > this.manager.sysNumber) {
                        this.manager.sysNumber = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String string, String string2, boolean bl) throws HsqlException {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('_');
            stringBuffer.append(string2);
            this.rename(stringBuffer.toString(), bl);
        }

        public boolean equals(HsqlName hsqlName) {
            return this.hashCode == hsqlName.hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static boolean isReservedIndexName(String string) {
            return string.startsWith("SYS_IDX_") || string.startsWith("SYS_PK_") || string.startsWith("SYS_REF_");
        }

        boolean isReservedIndexName() {
            return HsqlName.isReservedIndexName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object object) {
            return this.hashCode - object.hashCode();
        }
    }
}

