/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.DoubleIntTable;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rowio.RowOutputBinary;

class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long filePos;
    StopWatch stopw = new StopWatch();

    DataFileDefrag() {
    }

    HsqlArrayList defrag(Database database, String string) throws IOException, HsqlException {
        int[] nArray;
        int n;
        Trace.printSystemOut("Defrag Transfer begins");
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = database.getTables();
        try {
            OutputStream outputStream = database.getFileAccess().openOutputStreamElement(string + ".new");
            this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
        }
        catch (IOException iOException) {
            throw Trace.error(29, string + ".new");
        }
        for (n = 0; n < 32; ++n) {
            this.fileStreamOut.write(0);
        }
        this.filePos = 32L;
        int n2 = hsqlArrayList2.size();
        for (n = 0; n < n2; ++n) {
            Table table = (Table)hsqlArrayList2.get(n);
            if (table.tableType == 4) {
                nArray = this.writeTableToDataFile(table);
                hsqlArrayList.add(nArray);
            } else {
                hsqlArrayList.add(null);
            }
            Trace.printSystemOut(table.getName().name + " complete");
        }
        this.fileStreamOut.flush();
        this.fileStreamOut.close();
        ScaledRAFile scaledRAFile = ScaledRAFile.newScaledRAFile(string + ".new", database.getURLProperties().getProperty("storage_class_name"), database.getURLProperties().getProperty("storage_key"), false, 1);
        scaledRAFile.seek(16L);
        scaledRAFile.writeInt((int)this.filePos);
        scaledRAFile.close();
        int n3 = hsqlArrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray = (int[])hsqlArrayList.get(n2);
            if (nArray == null) continue;
            Trace.printSystemOut(StringUtil.getList(nArray, ",", ""));
        }
        Trace.printSystemOut("Transfer complete: ", this.stopw.elapsedTime());
        return hsqlArrayList;
    }

    static void updateTableIndexRoots(HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.tableType != 4) continue;
            int[] nArray = (int[])hsqlArrayList2.get(i);
            table.setIndexRoots(nArray);
        }
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        CachedRow cachedRow;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntTable doubleIntTable = new DoubleIntTable(1000000);
        int[] nArray = table.getIndexRootsArray();
        Index index = table.getPrimaryIndex();
        long l = this.filePos;
        int n = 0;
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        Node node = index.first();
        while (node != null) {
            cachedRow = (CachedRow)node.getRow();
            doubleIntTable.add(cachedRow.iPos, (int)l);
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + cachedRow.iPos + " " + l);
            }
            l += (long)cachedRow.storageSize;
            node = index.next(node);
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        node = index.first();
        while (node != null) {
            cachedRow = (CachedRow)node.getRow();
            rowOutputBinary.reset();
            rowOutputBinary.writeSize(cachedRow.storageSize);
            Node node2 = cachedRow.nPrimaryNode;
            while (node2 != null) {
                ((DiskNode)node2).writeTranslate(rowOutputBinary, doubleIntTable);
                node2 = node2.nNext;
            }
            rowOutputBinary.writeData(cachedRow.getData(), cachedRow.getTable());
            rowOutputBinary.writePos((int)this.filePos);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.filePos += (long)cachedRow.storageSize;
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            node = index.next(node);
            ++n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = doubleIntTable.find(0, nArray[i]);
            if (n2 == -1) {
                throw Trace.error(129);
            }
            nArray[i] = doubleIntTable.get(n2, 1);
        }
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }
}

