/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hsqldb.DIProcedureInfo;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;

final class DINameSpace {
    private Database database;
    private String catalogName;
    private static HashSet builtin = new HashSet();
    static final String DEFN_SCHEMA = "DEFINITION_SCHEMA";
    private static final String DEFN_SCHEMA_DOT = "DEFINITION_SCHEMA.";
    private static final int DEFN_SCHEMA_DOT_LEN = "DEFINITION_SCHEMA.".length();
    static final String INFO_SCHEMA = "INFORMATION_SCHEMA";
    private static final String INFO_SCHEMA_DOT = "INFORMATION_SCHEMA.";
    private static final int INFO_SCHEMA_DOT_LEN = "INFORMATION_SCHEMA.".length();
    static final String PUB_SCHEMA = "PUBLIC";
    private static final String PUB_SCHEMA_DOT = "PUBLIC.";
    private static final int PUB_SCHEMA_DOT_LEN = "PUBLIC.".length();
    private static final HsqlArrayList sysSchemas = new HsqlArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public DINameSpace(Database database) throws HsqlException {
        try {
            this.database = database;
            this.catalogName = database.getURI();
        }
        catch (Exception exception) {
            Trace.throwerror(40, exception.toString());
        }
    }

    Class classForMethodFQN(String string) {
        try {
            return this.classForName(string.substring(0, string.lastIndexOf(46)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    Class classForName(String string) throws ClassNotFoundException {
        try {
            if (this.database.classLoader == null) {
                return Class.forName(string);
            }
            if (string != null) {
                return this.database.classLoader.loadClass(string);
            }
            throw new ClassNotFoundException();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(noClassDefFoundError.toString());
        }
    }

    Iterator iterateCatalogNames() throws HsqlException {
        return this.isReportCatalogs() ? new WrapperIterator(this.catalogName) : new WrapperIterator();
    }

    Iterator iterateSysSchemaNames() throws HsqlException {
        return this.isReportSchemas() ? sysSchemas.iterator() : new WrapperIterator();
    }

    Iterator iterateVisibleSchemaNames(Session session) throws HsqlException {
        if (!this.isReportSchemas() || session == null) {
            return new WrapperIterator();
        }
        UserManager userManager = this.database.getUserManager();
        HsqlArrayList hsqlArrayList = userManager.listVisibleUsers(session, false);
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            User user = (User)hsqlArrayList.get(i);
            hsqlArrayList2.add(user.getName());
        }
        return new WrapperIterator(this.iterateSysSchemaNames(), hsqlArrayList2.iterator());
    }

    HsqlNameManager.HsqlName findOrCreateHsqlName(String string, HashMap hashMap) {
        HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)hashMap.get(string);
        if (hsqlName == null) {
            try {
                hsqlName = this.database.nameManager.newHsqlName(string, false);
                hashMap.put(string, hsqlName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hsqlName;
    }

    Table findPubSchemaTable(String string) {
        return !this.isReportSchemas() || string == null || !string.startsWith(PUB_SCHEMA_DOT) ? null : this.database.findUserTable(string.substring(PUB_SCHEMA_DOT_LEN));
    }

    Table findUserSchemaTable(Session session, String string) {
        if (!this.isReportSchemas() || string == null || session == null) {
            return null;
        }
        String string2 = session.getUsername() + ".";
        return string.startsWith(string2) ? this.database.findUserTable(session, string.substring(string2.length())) : null;
    }

    String getCatalogName(Object object) {
        return this.isReportCatalogs() ? this.catalogName : null;
    }

    HashMap getInverseAliasMap() {
        HashMap hashMap = this.database.getAliasMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = hashMap.get(object);
            HsqlArrayList hsqlArrayList = (HsqlArrayList)hashMap2.get(object2);
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
                hashMap2.put(object2, hsqlArrayList);
            }
            hsqlArrayList.add(object);
        }
        return hashMap2;
    }

    static String getMethodFQN(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + method.getName();
    }

    static String getMethodSpecificName(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + DIProcedureInfo.getSignature(method);
    }

    String getSchemaName(Object object) {
        if (object == null || !this.isReportSchemas()) {
            return null;
        }
        if (object instanceof NumberSequence) {
            return PUB_SCHEMA;
        }
        if (object instanceof Table) {
            return ((Table)object).getSchemaName();
        }
        if (object instanceof Index) {
            Table table = this.tableForIndex((Index)object);
            return table == null ? null : table.getSchemaName();
        }
        if (object instanceof String) {
            if (Types.typeAliases.get(object, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                return DEFN_SCHEMA;
            }
            if (this.isBuiltin((String)object)) {
                return DEFN_SCHEMA;
            }
            try {
                object = this.classForName((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        Class clazz = null;
        if (object instanceof Method) {
            clazz = ((Method)object).getDeclaringClass();
        } else if (object instanceof Class) {
            clazz = (Class)object;
        }
        return clazz == null ? null : (this.isBuiltin(clazz) ? DEFN_SCHEMA : PUB_SCHEMA);
    }

    void addBuiltinToSet(HashSet hashSet) {
        hashSet.addAll(builtin.toArray(new String[builtin.size()]));
    }

    boolean isBuiltin(Class clazz) {
        return clazz == null ? false : builtin.contains(clazz.getName());
    }

    boolean isBuiltin(String string) {
        return string == null ? false : builtin.contains(string);
    }

    Table tableForIndex(Index index) {
        return index == null ? null : this.tableForIndexName(index.getName().name);
    }

    Table tableForIndexName(String string) {
        HsqlNameManager.HsqlName hsqlName = this.database.indexNameList.getOwner(string);
        return this.database.findUserTable(hsqlName.name);
    }

    String withoutCatalog(String string) {
        if (!this.isReportCatalogs()) {
            return string;
        }
        String string2 = this.getCatalogName(string) + ".";
        String string3 = string.startsWith(string2) ? string.substring(string2.length()) : string;
        return string3;
    }

    String withoutDefnSchema(String string) {
        return this.isReportSchemas() && string.startsWith(DEFN_SCHEMA_DOT) ? string.substring(DEFN_SCHEMA_DOT_LEN) : string;
    }

    String withoutInfoSchema(String string) {
        return this.isReportSchemas() && string.startsWith(INFO_SCHEMA_DOT) ? string.substring(INFO_SCHEMA_DOT_LEN) : string;
    }

    Iterator iterateRoutineMethods(String string, boolean bl) throws HsqlException {
        Method[] methodArray;
        Class clazz;
        try {
            clazz = this.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new WrapperIterator();
        }
        HashMap hashMap = bl ? this.getInverseAliasMap() : null;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Exception exception) {
            methodArray = clazz.getMethods();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
            Object[] objectArray = new Object[]{method, null, "ROUTINE"};
            if (bl) {
                objectArray[1] = hashMap.get(DINameSpace.getMethodFQN(method));
            }
            hsqlArrayList.add(objectArray);
        }
        return hsqlArrayList.iterator();
    }

    Iterator iterateAccessibleTriggerClassNames(User user) throws HsqlException {
        HashSet hashSet = new HashSet();
        HsqlArrayList hsqlArrayList = this.database.getTables();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            HsqlArrayList[] hsqlArrayListArray;
            Table table = (Table)hsqlArrayList.get(i);
            if (!user.isAccessible(table.getName()) || (hsqlArrayListArray = table.triggerLists) == null) continue;
            for (int j = 0; j < hsqlArrayListArray.length; ++j) {
                HsqlArrayList hsqlArrayList2 = hsqlArrayListArray[j];
                if (hsqlArrayList2 == null) continue;
                int n = hsqlArrayList2.size();
                for (int k = 0; k < n; ++k) {
                    TriggerDef triggerDef = (TriggerDef)hsqlArrayList2.get(k);
                    if (triggerDef == null || !triggerDef.valid || triggerDef.trig == null || !user.isAccessible(table, TriggerDef.indexToRight(k))) continue;
                    hashSet.add(triggerDef.trig.getClass().getName());
                }
            }
        }
        return hashSet.iterator();
    }

    Iterator iterateAccessibleTriggerMethods(Session session) throws HsqlException {
        Class[] classArray = new Class[]{Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = DINameSpace.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DINameSpace.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DINameSpace.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DINameSpace.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = this.database.getTables();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < hsqlArrayList2.size(); ++i) {
            HsqlArrayList[] hsqlArrayListArray;
            Table table = (Table)hsqlArrayList2.get(i);
            if (!session.isAccessible(table.getName()) || (hsqlArrayListArray = table.triggerLists) == null) continue;
            for (int j = 0; j < hsqlArrayListArray.length; ++j) {
                HsqlArrayList hsqlArrayList3 = hsqlArrayListArray[j];
                if (hsqlArrayList3 == null) continue;
                int n = hsqlArrayList3.size();
                for (int k = 0; k < n; ++k) {
                    try {
                        Class<?> clazz;
                        String string;
                        TriggerDef triggerDef = (TriggerDef)hsqlArrayList3.get(k);
                        if (triggerDef == null || hashSet.contains(string = (clazz = triggerDef.trig.getClass()).getName())) continue;
                        hashSet.add(string);
                        Method method = clazz.getMethod("fire", classArray);
                        hsqlArrayList.add(new Object[]{method, null, "TRIGGER"});
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return hsqlArrayList.iterator();
    }

    Iterator iterateAllAccessibleMethods(Session session, boolean bl) throws HsqlException {
        WrapperIterator wrapperIterator = new WrapperIterator();
        HashSet hashSet = session.getGrantedClassNames(true);
        this.addBuiltinToSet(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.iterateRoutineMethods(string, bl);
            wrapperIterator = new WrapperIterator(wrapperIterator, iterator2);
        }
        return new WrapperIterator(wrapperIterator, this.iterateAccessibleTriggerMethods(session));
    }

    Session[] listVisibleSessions(Session session) {
        return this.database.sessionManager.getVisibleSessions(session);
    }

    boolean isReportCatalogs() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs");
    }

    boolean isReportSchemas() {
        return this.database.getProperties().isPropertyTrue("hsqldb.schemas");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sysSchemas.add(DEFN_SCHEMA);
        sysSchemas.add(INFO_SCHEMA);
        sysSchemas.add(PUB_SCHEMA);
        builtin.add("org.hsqldb.Library");
        builtin.add("java.lang.Math");
    }
}

