/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.agenda;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.agenda.AgendaTemplate;
import com.sun.star.wizards.agenda.AgendaWizardDialog;
import com.sun.star.wizards.agenda.CGAgenda;
import com.sun.star.wizards.agenda.TopicsControl;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class AgendaWizardDialogImpl
extends AgendaWizardDialog {
    static boolean running;
    AgendaTemplate agendaTemplate;
    private CGAgenda agenda;
    private TopicsControl topicsControl;
    private String[][] agendaTemplates;
    private FileAccess fileAccess1;
    private boolean filenameChanged = false;
    static /* synthetic */ Class class$com$sun$star$awt$XWindowPeer;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$util$XCloseable;

    public AgendaWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void startWizard() {
        running = true;
        try {
            this.agenda = new CGAgenda();
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Agenda", (boolean)false);
            this.agenda.readConfiguration(object, "cp_");
            this.agendaTemplate = new AgendaTemplate(this.xMSF, this.agenda, this.resources, (XTerminateListener)this);
            this.initializeTemplates();
            this.agendaTemplate.load(this.agendaTemplates[1][this.agenda.cp_AgendaType], new Vector());
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.topicsControl = new TopicsControl(this, this.xMSF, this.agenda);
            this.buildStep6();
            this.drawNaviBar();
            XWindow xWindow = this.agendaTemplate.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XWindowPeer == null ? (class$com$sun$star$awt$XWindowPeer = AgendaWizardDialogImpl.class$("com.sun.star.awt.XWindowPeer")) : class$com$sun$star$awt$XWindowPeer), (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.addRoadmap();
            this.insertRoadMapItems(new String[]{this.resources.resStep1, this.resources.resStep2, this.resources.resStep3, this.resources.resStep4, this.resources.resStep5, this.resources.resStep6}, new int[]{1, 2, 3, 4, 5, 6}, new boolean[]{true, true, true, true, true, true});
            this.setMaxStep(6);
            this.makeDA();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            running = false;
            return;
        }
        this.xWindow.setVisible(true);
    }

    private void checkSavePath() {
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("") || !this.getFileAccess().exists(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath), false) || !this.getFileAccess().isDirectory(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath))) {
            try {
                this.agenda.cp_TemplatePath = FileAccess.connectURLs((String)FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Work", (String)""), (String)this.resources.resDefaultFilename);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeDA() {
        this.setControlProperty("listPageDesign", "StringItemList", this.agendaTemplates[0]);
        this.checkSavePath();
        this.setFilename(this.agenda.cp_TemplatePath);
        UnoDataAware.attachListBox((Object)((Object)this.agenda), (String)"cp_AgendaType", (Object)this.listPageDesign, null, (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_IncludeMinutes", (Object)this.chkMinutes, null, (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_Title", (Object)this.txtTitle, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachDateControl((Object)((Object)this.agenda), (String)"cp_Date", (Object)this.txtDate, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachTimeControl((Object)((Object)this.agenda), (String)"cp_Time", (Object)this.txtTime, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_Location", (Object)this.cbLocation, (DataAware.Listener)this.agendaTemplate, (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowMeetingType", (Object)this.chkMeetingTitle, (DataAware.Listener)new RedrawListener("<meeting-type>"), (boolean)true);
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowRead", (Object)this.chkRead, (DataAware.Listener)new RedrawListener("<read>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowBring", (Object)this.chkBring, (DataAware.Listener)new RedrawListener("<bring>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowNotes", (Object)this.chkNotes, (DataAware.Listener)new RedrawListener("<notes>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowCalledBy", (Object)this.chkConvenedBy, (DataAware.Listener)new RedrawListener("<called-by>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowFacilitator", (Object)this.chkPresiding, (DataAware.Listener)new RedrawListener("<facilitator>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowNotetaker", (Object)this.chkNoteTaker, (DataAware.Listener)new RedrawListener("<notetaker>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowTimekeeper", (Object)this.chkTimekeeper, (DataAware.Listener)new RedrawListener("<timekeeper>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowAttendees", (Object)this.chkAttendees, (DataAware.Listener)new RedrawListener("<attendees>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowObservers", (Object)this.chkObservers, (DataAware.Listener)new RedrawListener("<observers>"), (boolean)true).updateUI();
        UnoDataAware.attachCheckBox((Object)((Object)this.agenda), (String)"cp_ShowResourcePersons", (Object)this.chkResourcePersons, (DataAware.Listener)new RedrawListener("<resource-persons>"), (boolean)true).updateUI();
        UnoDataAware.attachEditControl((Object)((Object)this.agenda), (String)"cp_TemplateName", (Object)this.txtTemplateName, null, (boolean)true).updateUI();
        RadioDataAware.attachRadioButtons((Object)((Object)this.agenda), (String)"cp_ProceedMethod", (Object[])new Object[]{this.optCreateAgenda, this.optMakeChanges}, null, (boolean)true).updateUI();
        this.listPageDesign.addItemListener(new XItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AgendaWizardDialogImpl.this.pageDesignChanged(itemEvent);
            }

            public void disposing(EventObject eventObject) {
            }
        });
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect((String)string);
            AgendaWizardDialogImpl agendaWizardDialogImpl = new AgendaWizardDialogImpl(xMultiServiceFactory);
            agendaWizardDialogImpl.startWizard();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean initializeTemplates() {
        try {
            String string = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Template", (String)"share");
            String string2 = FileAccess.combinePaths((XMultiServiceFactory)this.xMSF, (String)string, (String)"/wizard/agenda");
            this.agendaTemplates = FileAccess.getFolderTitles((XMultiServiceFactory)this.xMSF, (String)"aw", (String)string2);
            return true;
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void pageDesignChanged(ItemEvent itemEvent) {
        int n = itemEvent.Selected;
        try {
            this.agendaTemplate.load(this.agendaTemplates[1][n], this.topicsControl.getTopicsData());
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (String)"ErrBox", (int)0x400000, (String)this.resources.resErrOpenTemplate);
            exception.printStackTrace();
        }
    }

    public void templateTitleChanged() {
        String string = (String)Helper.getUnoPropertyValue((Object)AgendaWizardDialogImpl.getModel((Object)this.txtTemplateName), (String)"Text");
        this.agendaTemplate.setTemplateTitle(string);
    }

    private FileAccess getFileAccess() {
        if (this.fileAccess1 == null) {
            try {
                this.fileAccess1 = new FileAccess(this.xMSF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fileAccess1;
    }

    public void saveAs() {
        try {
            this.checkSavePath();
            SystemDialog systemDialog = SystemDialog.createStoreDialog((XMultiServiceFactory)this.xMSF);
            systemDialog.addFilterToDialog("stw", "writer_StarOffice_XML_Writer_Template", true);
            String string = systemDialog.callStoreDialog(FileAccess.getParentDir((String)this.agenda.cp_TemplatePath), FileAccess.getFilename((String)this.agenda.cp_TemplatePath));
            if (string != null) {
                this.agenda.cp_TemplatePath = string;
                this.setFilename(string);
                this.filenameChanged = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFilename(String string) {
        try {
            String string2 = this.getFileAccess().getPath(string, "");
            Helper.setUnoPropertyValue((Object)AgendaWizardDialogImpl.getModel((Object)this.txtTemplatePath), (String)"Text", (Object)string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertRow() {
        this.topicsControl.insertRow();
    }

    public void removeRow() {
        this.topicsControl.removeRow();
    }

    public void rowUp() {
        this.topicsControl.rowUp();
    }

    public void rowDown() {
        this.topicsControl.rowDown();
    }

    public void cancelWizard() {
        this.xWindow.setVisible(false);
        this.closeDocument();
        running = false;
    }

    public void finishWizard() {
        XTextDocument xTextDocument;
        int n;
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("")) {
            return;
        }
        if (!this.filenameChanged && this.getFileAccess().exists(this.agenda.cp_TemplatePath, true) && (n = SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (XWindowPeer)this.xControl.getPeer(), (String)"MessBox", (int)-2130706432, (String)this.resources.resFileExists)) == 3) {
            return;
        }
        n = 0;
        try {
            this.agendaTemplate.xTextDocument.lockControllers();
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = AgendaWizardDialogImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.agendaTemplate.document);
            n = OfficeDocument.store((XMultiServiceFactory)this.xMSF, (XComponent)xTextDocument, (String)this.agenda.cp_TemplatePath, (String)"writer_StarOffice_XML_Writer_Template", (boolean)false, (String)this.resources.resErrSaveTemplate) ? 1 : 0;
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (XWindowPeer)this.xControl.getPeer(), (String)"ErrBox", (int)0x400000, (String)this.resources.resErrSaveTemplate);
        }
        if (n != 0) {
            PropertyValue[] propertyValueArray;
            try {
                this.topicsControl.saveTopics(this.agenda);
                propertyValueArray = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"/org.openoffice.Office.Writer/Wizards/Agenda", (boolean)true);
                this.agenda.writeConfiguration(propertyValueArray, "cp_");
                Configuration.commit((Object)propertyValueArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.agendaTemplate.finish(this.topicsControl.getTopicsData());
            try {
                propertyValueArray = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = AgendaWizardDialogImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.agendaTemplate.document);
                propertyValueArray.store();
            }
            catch (Exception exception) {
                SystemDialog.showMessageBox((XMultiServiceFactory)this.xMSF, (String)"ErrBox", (int)0x400000, (String)this.resources.resErrSaveTemplate);
                exception.printStackTrace();
            }
            this.xWindow.setVisible(false);
            running = false;
            this.closeDocument();
            this.agendaTemplate.xTextDocument.unlockControllers();
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "AsTemplate";
            propertyValueArray[0].Value = this.agenda.cp_ProceedMethod == 1 ? Boolean.TRUE : Boolean.FALSE;
            Object object = OfficeDocument.load((XInterface)Desktop.getDesktop((XMultiServiceFactory)this.xMSF), (String)this.agenda.cp_TemplatePath, (String)"_default", (PropertyValue[])new PropertyValue[0]);
            xTextDocument = (XTextDocument)object;
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = AgendaWizardDialogImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)xTextDocument);
            ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
            try {
                viewHandler.setViewSetting("ZoomType", (Object)new Short(0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.agendaTemplate.xTextDocument.unlockControllers();
            return;
        }
    }

    private void closeDocument() {
        try {
            this.xComponent.dispose();
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XCloseable == null ? (class$com$sun$star$util$XCloseable = AgendaWizardDialogImpl.class$("com.sun.star.util.XCloseable")) : class$com$sun$star$util$XCloseable), (Object)this.agendaTemplate.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RedrawListener
    implements DataAware.Listener {
        private String itemName;

        public RedrawListener(String string) {
            this.itemName = string;
        }

        public void eventPerformed(Object object) {
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.lockControllers();
            AgendaWizardDialogImpl.this.agendaTemplate.redraw(this.itemName);
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.unlockControllers();
        }
    }
}

