/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleSelectionImpl;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public class Container
extends java.awt.Container
implements Accessible {
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent = null;
    protected AccessibleRole accessibleRole;
    protected AccessibleText accessibleText;
    protected boolean disposed = false;
    protected AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEventBroadcaster;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;

    protected Container(AccessibleRole accessibleRole, XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.accessibleRole = accessibleRole;
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = Container.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xAccessibleContext);
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEventBroadcaster == null ? (class$com$sun$star$accessibility$XAccessibleEventBroadcaster = Container.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster")) : class$com$sun$star$accessibility$XAccessibleEventBroadcaster), (Object)this.unoAccessibleContext);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener(this.createEventListener());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            java.awt.Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean bl) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean bl) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, bl));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] objectArray) {
        try {
            ArrayList<Component> arrayList = new ArrayList<Component>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Component component = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? Container.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible), (Object)objectArray[i]));
                if (component == null) continue;
                arrayList.add(component);
            }
            arrayList.trimToSize();
            return arrayList.toArray();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getEventQueue();
        EventQueue.invokeLater(new PropertyChangeBroadcaster(string, object, object2));
    }

    protected void fireStatePropertyChange(AccessibleState accessibleState, boolean bl) {
        PropertyChangeBroadcaster propertyChangeBroadcaster = bl ? new PropertyChangeBroadcaster("AccessibleState", null, accessibleState) : new PropertyChangeBroadcaster("AccessibleState", accessibleState, null);
        this.getEventQueue();
        EventQueue.invokeLater(propertyChangeBroadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleContainerListener();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleContainer();
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext accessibleContext = this.createAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    accessibleContext.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = accessibleContext;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleContainer
    extends Container.AccessibleAWTContainer {
        protected ComponentListener accessibleComponentHandler = null;
        protected FocusListener accessibleFocusHandler = null;
        protected ContainerListener accessibleContainerHandler = null;
        protected int propertyChangeListenerCount = 0;

        protected AccessibleContainer() {
            super(Container.this);
            Container.this.accessibleText = AccessibleTextImpl.get((XInterface)Container.this.unoAccessibleContext);
        }

        protected AccessibleContainer(boolean bl) {
            super(Container.this);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                Container.this.addFocusListener(this.accessibleFocusHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Container.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Container.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Container.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Container.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Container.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleRole getAccessibleRole() {
            return Container.this.accessibleRole;
        }

        public AccessibleText getAccessibleText() {
            return Container.this.accessibleText;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (Container.this.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(Container.this, Container.this.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException runtimeException) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            try {
                XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = Container.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection), (Object)Container.this.unoAccessibleContext);
                if (xAccessibleSelection != null) {
                    return new AccessibleSelectionImpl(xAccessibleSelection);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale locale = Container.this.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(locale.Language, locale.Country);
            }
            catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                return super.getLocale();
            }
        }

        public Color getBackground() {
            try {
                return new Color(Container.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(Container.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return Container.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return Container.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return Container.this.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return Container.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Container.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = Container.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Container.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = Container.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Container.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Container.this.isFocusable();
        }

        public void requestFocus() {
            Container.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleContainerListener
    implements XAccessibleEventListener {
        protected AccessibleContainerListener() {
        }

        protected EventQueue getEventQueue() {
            return Toolkit.getDefaultToolkit().getSystemEventQueue();
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    break;
                }
                case 7: {
                    Container.this.setEnabled(bl);
                    Container.this.fireStatePropertyChange(AccessibleState.ENABLED, bl);
                    break;
                }
                case 11: {
                    this.getEventQueue().postEvent(new FocusEvent(Container.this, bl ? 1004 : 1005));
                    break;
                }
                case 23: {
                    Container.this.fireStatePropertyChange(AccessibleState.SELECTED, bl);
                    break;
                }
                case 25: 
                case 30: {
                    Container.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                if (Container.this.accessibleContext != null) {
                    Container.this.accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (Container.this.accessibleContext != null) {
                    Container.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleAllChildrenChangedEvent() {
            AccessibleContext accessibleContext;
            Accessible accessible = (Accessible)((Object)Container.this.getParent());
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                accessibleContext.firePropertyChange("AccessibleChild", Container.this, null);
                AccessibleObjectFactory.clearContainer(Container.this);
                AccessibleObjectFactory.populateContainer(Container.this, Container.this.unoAccessibleContext);
                accessibleContext.firePropertyChange("AccessibleChild", null, Container.this);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 1: {
                    this.handleNameChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                    break;
                }
                case 22: {
                    Container.this.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(accessibleEventObject.OldValue), AccessibleTextImpl.convertTextSegment(accessibleEventObject.NewValue));
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        AccessibleObjectFactory.removeChild(Container.this, accessibleEventObject.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    AccessibleObjectFactory.addChild((java.awt.Container)Container.this, accessibleEventObject.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    Container.this.firePropertyChange("AccessibleVisibleData", null, null);
                    break;
                }
                case 9: {
                    Container.this.firePropertyChange("AccessibleSelection", null, null);
                    break;
                }
                case 8: {
                    this.handleAllChildrenChangedEvent();
                    break;
                }
            }
        }

        public void disposing(EventObject eventObject) {
            Container.this.disposed = true;
            AccessibleObjectFactory.disposing(Container.this);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(String string, Object object, Object object2) {
            this.propertyName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void run() {
            try {
                AccessibleContext accessibleContext = Container.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

