/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptIRFactory;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptRuntime;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private final int JAVASCRIPTEXCEPTION = 0;
    private final int WRAPPEDEXCEPTION = 1;
    private static final String functionSuperClassName = "org.mozilla.javascript.NativeFunction";
    private static final String scriptSuperClassName = "org.mozilla.javascript.NativeScript";
    private String superClassName;
    private String superClassSlashName;
    private String name;
    private int ordinal;
    boolean inFunction;
    boolean inDirectCallFunction;
    private ClassFileWriter classFile;
    private short scriptRuntimeIndex;
    private int version;
    private String itsSourceFile;
    private int itsLineNumber;
    private int stackDepth;
    private int stackDepthMax;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private double[] itsConstantList;
    private int itsConstantListSize;
    private short variableObjectLocal;
    private short scriptResultLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short debug_pcLocal;
    private short debugStopSubRetLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private boolean itsUseDynamicScope;
    private boolean hasVarsInRegs;
    private boolean itsForcedObjectParameters;
    private boolean trivialInit;
    private short itsLocalAllocationBase;
    private VariableTable vars;
    private VariableTable debugVars;
    private int epilogueLabel;
    private int optLevel;
    static /* synthetic */ Class class$java$lang$Object;

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new OptIRFactory(tokenStream, classNameHelper, scriptable);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        OptTransformer optTransformer = new OptTransformer(new Hashtable(11));
        return optTransformer.transform(node, null, tokenStream, scriptable);
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecurityController securityController, ClassNameHelper classNameHelper) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ObjArray objArray = new ObjArray();
        ObjArray objArray2 = new ObjArray();
        String string = null;
        OptClassNameHelper optClassNameHelper = (OptClassNameHelper)classNameHelper;
        RuntimeException runtimeException = null;
        Object object6 = null;
        ClassLoader classLoader = context.getApplicationClassLoader();
        GeneratedClassLoader generatedClassLoader = securityController == null ? context.createClassLoader(classLoader) : securityController.createClassLoader(classLoader, object);
        optClassNameHelper.reset();
        try {
            if (context.getOptimizationLevel() > 0) {
                new Optimizer().optimize(node, context.getOptimizationLevel());
            }
            string = this.generateCode(node, objArray2, objArray, optClassNameHelper);
            object5 = optClassNameHelper.getClassRepository();
            for (int i = 0; i < objArray2.size(); ++i) {
                object4 = (String)objArray2.get(i);
                object3 = (byte[])objArray.get(i);
                boolean bl = ((String)object4).equals(string);
                try {
                    if (!object5.storeClass((String)object4, (byte[])object3, bl)) continue;
                    object2 = generatedClassLoader.defineClass((String)object4, (byte[])object3);
                    if (!bl) continue;
                    object6 = object2;
                    continue;
                }
                catch (ClassFormatError classFormatError) {
                    throw new RuntimeException(classFormatError.toString());
                }
                catch (IOException iOException) {
                    throw WrappedException.wrapException(iOException);
                }
            }
            if (object6 != null) {
                generatedClassLoader.linkClass((Class)object6);
            }
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        if (runtimeException != null) {
            throw new RuntimeException("Malformed optimizer package " + runtimeException);
        }
        object5 = optClassNameHelper.getTargetImplements();
        Class clazz = optClassNameHelper.getTargetExtends();
        if (object5 != null || clazz != null) {
            object4 = optClassNameHelper.getJavaScriptClassName(null, true);
            object3 = new NativeObject();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getType() != 110) continue;
                object2 = (OptFunctionNode)node2.getProp(5);
                ((ScriptableObject)object3).put(((FunctionNode)object2).getFunctionName(), (Scriptable)object3, object2);
            }
            if (clazz == null) {
                clazz = class$java$lang$Object == null ? (class$java$lang$Object = Codegen.class$("java.lang.Object")) : class$java$lang$Object;
            }
            try {
                JavaAdapter.createAdapterClass(context, (Scriptable)object3, (String)object4, clazz, (Class[])object5, string, optClassNameHelper);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException.toString());
            }
        }
        if (object6 == null) {
            return null;
        }
        if (node instanceof OptFunctionNode) {
            try {
                object3 = ((Class)object6).getConstructors()[0];
                Object[] objectArray = new Object[]{scriptable, context};
                object4 = (NativeFunction)((Constructor)object3).newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
            }
            object3 = (OptFunctionNode)node;
            OptRuntime.initFunction((NativeFunction)object4, ((FunctionNode)object3).getFunctionType(), scriptable, context);
            return object4;
        }
        try {
            object4 = (NativeScript)((Class)object6).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        if (scriptable != null) {
            ((ScriptableObject)object4).setPrototype(NativeScript.getClassPrototype(scriptable, "Script"));
            ((ScriptableObject)object4).setParentScope(scriptable);
        }
        return object4;
    }

    void addByteCode(byte by) {
        this.classFile.add(by);
    }

    void addByteCode(byte by, int n) {
        this.classFile.add(by, n);
    }

    void addByteCode(byte by, String string) {
        this.classFile.add(by, string);
    }

    void addVirtualInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-74, string, string2, string3, string4);
    }

    void addStaticInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-72, string, string2, string3, string4);
    }

    void addScriptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", string, string2, string3);
    }

    void addOptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", string, string2, string3);
    }

    void addSpecialInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-73, string, string2, string3, string4);
    }

    void addDoubleConstructor() {
        this.classFile.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
    }

    private void markLabel(int n) {
        this.classFile.markLabel(n);
    }

    private void markLabel(int n, short s) {
        this.classFile.markLabel(n, s);
    }

    private int acquireLabel() {
        return this.classFile.acquireLabel();
    }

    public void emitDirectConstructor(OptFunctionNode optFunctionNode) {
        int n;
        short s = 17;
        this.classFile.startMethod("constructDirect", optFunctionNode.getDirectCallParameterSignature() + "Ljava/lang/Object;", s);
        int n2 = optFunctionNode.getVariableTable().getParameterCount();
        short s2 = (short)(4 + n2 * 3 + 1);
        this.addByteCode((byte)-69, "org/mozilla/javascript/NativeObject");
        this.addByteCode((byte)89);
        this.classFile.add((byte)-73, "org/mozilla/javascript/NativeObject", "<init>", "()", "V");
        this.astore(s2);
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getClassPrototype", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload((short)0);
        this.aload((short)1);
        this.aload((short)2);
        this.aload(s2);
        for (n = 0; n < n2; ++n) {
            this.aload((short)(4 + n * 3));
            this.dload((short)(5 + n * 3));
        }
        this.aload((short)(4 + n2 * 3));
        this.addVirtualInvoke(this.name, "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
        this.astore((short)(s2 + 1));
        n = this.acquireLabel();
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-58, n);
        this.aload((short)(s2 + 1));
        this.pushUndefined();
        this.addByteCode((byte)-91, n);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-63, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-103, n);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-64, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-80);
        this.markLabel(n);
        this.aload(s2);
        this.addByteCode((byte)-80);
        this.classFile.stopMethod((short)(s2 + 2), null);
    }

    public String generateCode(Node node, ObjArray objArray, ObjArray objArray2, OptClassNameHelper optClassNameHelper) {
        Object object;
        Node node2;
        ObjArray objArray3 = (ObjArray)node.getProp(5);
        if (objArray3 != null) {
            for (int i = 0; i != objArray3.size(); ++i) {
                node2 = (OptFunctionNode)objArray3.get(i);
                object = new Codegen();
                ((Codegen)object).generateCode(node2, objArray, objArray2, optClassNameHelper);
            }
        }
        Context context = Context.getCurrentContext();
        this.itsUseDynamicScope = context.hasCompileFunctionsWithDynamicScope();
        this.itsSourceFile = null;
        if (!context.isGeneratingDebugChanged() || context.isGeneratingDebug()) {
            this.itsSourceFile = (String)node.getProp(16);
        }
        this.version = context.getLanguageVersion();
        this.optLevel = context.getOptimizationLevel();
        this.inFunction = node.getType() == 110;
        this.superClassName = this.inFunction ? functionSuperClassName : scriptSuperClassName;
        this.superClassSlashName = this.superClassName.replace('.', '/');
        if (this.inFunction) {
            object = (OptFunctionNode)node;
            this.inDirectCallFunction = ((OptFunctionNode)object).isTargetOfDirectCall();
            this.vars = ((FunctionNode)object).getVariableTable();
            this.name = ((OptFunctionNode)object).getClassName();
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            Node node3 = node.getFirstChild();
            String string = ((FunctionNode)object).getFunctionName();
            this.generateInit(context, "<init>", node, string, node3);
            if (((OptFunctionNode)object).isTargetOfDirectCall()) {
                int n;
                int n2;
                this.classFile.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
                this.addByteCode((byte)42);
                this.addByteCode((byte)43);
                this.addByteCode((byte)44);
                this.addByteCode((byte)45);
                for (n2 = 0; n2 < this.vars.getParameterCount(); ++n2) {
                    this.push(n2);
                    this.addByteCode((byte)25, 4);
                    this.addByteCode((byte)-66);
                    int n3 = this.acquireLabel();
                    n = this.acquireLabel();
                    this.addByteCode((byte)-94, n3);
                    this.addByteCode((byte)25, 4);
                    this.push(n2);
                    this.addByteCode((byte)50);
                    this.push(0.0);
                    this.addByteCode((byte)-89, n);
                    this.markLabel(n3);
                    this.pushUndefined();
                    this.push(0.0);
                    this.markLabel(n);
                }
                this.addByteCode((byte)25, 4);
                this.addVirtualInvoke(this.name, "callDirect", ((OptFunctionNode)object).getDirectCallParameterSignature(), "Ljava/lang/Object;");
                this.addByteCode((byte)-80);
                this.classFile.stopMethod((short)5, null);
                this.emitDirectConstructor((OptFunctionNode)object);
                this.startNewMethod("callDirect", ((OptFunctionNode)object).getDirectCallParameterSignature() + "Ljava/lang/Object;", 1, false, true);
                Codegen.assignParameterJRegs(this.vars);
                if (!((OptFunctionNode)object).getParameterNumberContext()) {
                    this.itsForcedObjectParameters = true;
                    for (n2 = 0; n2 < this.vars.getParameterCount(); ++n2) {
                        OptLocalVariable optLocalVariable = OptLocalVariable.get(this.vars, n2);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n = this.acquireLabel();
                        this.addByteCode((byte)-90, n);
                        this.addByteCode((byte)-69, "java/lang/Double");
                        this.addByteCode((byte)89);
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.addDoubleConstructor();
                        this.astore(optLocalVariable.getJRegister());
                        this.markLabel(n);
                    }
                }
                this.generatePrologue(context, node, true, this.vars.getParameterCount());
            } else {
                this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
                this.generatePrologue(context, node, true, -1);
            }
            node2 = node.getLastChild();
        } else {
            if (node.getType() != 146) {
                this.badTree();
            }
            this.vars = (VariableTable)node.getProp(10);
            boolean bl = optClassNameHelper.getTargetExtends() == null && optClassNameHelper.getTargetImplements() == null;
            this.name = optClassNameHelper.getJavaScriptClassName(null, bl);
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            this.classFile.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(context, node);
            this.generateMain(context);
            this.generateInit(context, "initScript", node, "", null);
            this.generateExecute(context);
            this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
            this.generatePrologue(context, node, false, -1);
            int n = node.getIntProp(29, -1);
            if (n != -1) {
                this.classFile.addLineNumberEntry((short)n);
            }
            node.addChildToBack(new Node(5));
            node2 = node;
        }
        this.generateCodeFromNode(node2, null, -1, -1);
        this.generateEpilogue();
        this.finishMethod(context, this.debugVars);
        this.emitConstantDudeInitializers();
        byte[] byArray = this.classFile.toByteArray();
        objArray.add(this.name);
        objArray2.add(byArray);
        this.classFile = null;
        return this.name;
    }

    private static void assignParameterJRegs(VariableTable variableTable) {
        short s = 4;
        int n = variableTable.getParameterCount();
        for (int i = 0; i < n; ++i) {
            OptLocalVariable optLocalVariable = OptLocalVariable.get(variableTable, i);
            optLocalVariable.assignJRegister(s);
            s = (short)(s + 3);
        }
    }

    private void generateCodeFromNode(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        block0 : switch (n3) {
            case 124: 
            case 136: 
            case 138: {
                Node node3;
                this.visitStatement(node);
                for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    this.generateCodeFromNode(node3, node, n, n2);
                }
                break;
            }
            case 116: 
            case 117: 
            case 128: 
            case 132: 
            case 133: 
            case 146: {
                Node node3;
                this.visitStatement(node);
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                break;
            }
            case 110: {
                OptFunctionNode optFunctionNode;
                int n4;
                if (!this.inFunction && node2.getType() == 146 || (n4 = (optFunctionNode = (OptFunctionNode)node.getProp(5)).getFunctionType()) == 1) break;
                this.visitFunction(optFunctionNode, n4);
                break;
            }
            case 44: {
                this.visitName(node);
                break;
            }
            case 30: 
            case 43: {
                Node node3;
                this.visitCall(node, n3, node3);
                break;
            }
            case 45: 
            case 46: {
                this.visitLiteral(node);
                break;
            }
            case 109: {
                this.visitPrimary(node);
                break;
            }
            case 56: {
                this.visitObject(node);
                break;
            }
            case 75: {
                Node node3;
                this.visitTryCatchFinally(node, node3);
                break;
            }
            case 62: {
                Node node3;
                this.visitThrow(node, node3);
                break;
            }
            case 5: {
                Node node3;
                this.visitReturn(node, node3);
                break;
            }
            case 115: {
                Node node3;
                this.visitSwitch(node, node3);
                break;
            }
            case 96: {
                Node node3;
                for (Node node4 = node3.getNext(); node4 != null; node4 = node4.getNext()) {
                    this.generateCodeFromNode(node3, node, -1, -1);
                    this.addByteCode((byte)87);
                    node3 = node4;
                }
                this.generateCodeFromNode(node3, node, n, n2);
                break;
            }
            case 77: {
                this.addScriptRuntimeInvoke("newScope", "()", "Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 3: {
                Node node3;
                this.visitEnterWith(node, node3);
                break;
            }
            case 4: {
                Node node3;
                this.visitLeaveWith(node, node3);
                break;
            }
            case 79: {
                Node node3;
                this.visitEnumInit(node, node3);
                break;
            }
            case 80: {
                Node node3;
                this.visitEnumNext(node, node3);
                break;
            }
            case 139: {
                Node node3;
                this.visitEnumDone(node, node3);
                break;
            }
            case 57: {
                Node node3;
                this.visitStatement(node);
                if (node3.getType() == 73) {
                    this.visitSetVar(node3, node3.getFirstChild(), false);
                    break;
                }
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                if (node.getIntProp(26, -1) != -1) {
                    this.addByteCode((byte)88);
                    break;
                }
                this.addByteCode((byte)87);
                break;
            }
            case 2: {
                Node node3;
                this.visitStatement(node);
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                this.astore(this.scriptResultLocal);
                break;
            }
            case 137: {
                this.visitTarget(node);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 143: {
                Node node3;
                this.visitGOTO(node, n3, node3);
                break;
            }
            case 105: {
                Node node3;
                this.visitUnary(node, node3, n, n2);
                break;
            }
            case 32: {
                Node node3;
                this.visitTypeof(node, node3);
                break;
            }
            case 106: {
                this.visitIncDec(node, true);
                break;
            }
            case 107: {
                this.visitIncDec(node, false);
                break;
            }
            case 100: 
            case 101: {
                Node node3;
                if (n == -1) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addByteCode((byte)89);
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    int n5 = this.acquireLabel();
                    if (n3 == 101) {
                        this.addByteCode((byte)-103, n5);
                    } else {
                        this.addByteCode((byte)-102, n5);
                    }
                    this.addByteCode((byte)87);
                    this.generateCodeFromNode(node3.getNext(), node, n, n2);
                    this.markLabel(n5);
                    break;
                }
                int n6 = this.acquireLabel();
                if (n3 == 101) {
                    this.generateCodeFromNode(node3, node, n6, n2);
                    if (!Codegen.childIsBoolean(node3)) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, n6);
                        this.addByteCode((byte)-89, n2);
                    }
                } else {
                    this.generateCodeFromNode(node3, node, n, n6);
                    if (!Codegen.childIsBoolean(node3)) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, n);
                        this.addByteCode((byte)-89, n6);
                    }
                }
                this.markLabel(n6);
                node3 = node3.getNext();
                this.generateCodeFromNode(node3, node, n, n2);
                if (Codegen.childIsBoolean(node3)) break;
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n);
                this.addByteCode((byte)-89, n2);
                break;
            }
            case 23: {
                Node node3;
                this.generateCodeFromNode(node3, node, n, n2);
                this.generateCodeFromNode(node3.getNext(), node, n, n2);
                switch (node.getIntProp(26, -1)) {
                    case 0: {
                        this.addByteCode((byte)99);
                        break block0;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)", "Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)", "Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                break;
            }
            case 25: {
                Node node3;
                this.visitArithmetic(node, (byte)107, node3, node2);
                break;
            }
            case 24: {
                Node node3;
                this.visitArithmetic(node, (byte)103, node3, node2);
                break;
            }
            case 26: 
            case 27: {
                Node node3;
                this.visitArithmetic(node, n3 == 26 ? (byte)111 : 115, node3, node2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                Node node3;
                this.visitBitOp(node, n3, node3);
                break;
            }
            case 142: {
                Node node3;
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addDoubleConstructor();
                    break;
                }
                if (object == ScriptRuntime.DoubleClass) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    break;
                }
                if (object == ScriptRuntime.ObjectClass) {
                    int n7 = -1;
                    if (node3.getType() == 45) {
                        n7 = node3.getIntProp(26, -1);
                    }
                    if (n7 != -1) {
                        node3.removeProp(26);
                        this.generateCodeFromNode(node3, node, n, n2);
                        node3.putIntProp(26, n7);
                        break;
                    }
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addDoubleConstructor();
                    break;
                }
                this.badTree();
                break;
            }
            case 103: {
                Node node3;
                if (n == -1) {
                    this.visitRelOp(node, node3, node2);
                    break;
                }
                this.visitGOTOingRelOp(node, node3, node2, n, n2);
                break;
            }
            case 102: {
                Node node3;
                this.visitEqOp(node, node3, node2, n, n2);
                break;
            }
            case 39: {
                Node node3;
                this.visitGetProp(node, node3);
                break;
            }
            case 41: {
                Node node3;
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                this.aload(this.variableObjectLocal);
                if (node.getIntProp(26, -1) != -1) {
                    this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                break;
            }
            case 72: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                this.visitGetVar(optLocalVariable, node.getIntProp(26, -1) != -1, node.getString());
                break;
            }
            case 73: {
                Node node3;
                this.visitSetVar(node, node3, true);
                break;
            }
            case 10: {
                Node node3;
                this.visitSetName(node, node3);
                break;
            }
            case 40: {
                Node node3;
                this.visitSetProp(node, node3);
                break;
            }
            case 42: {
                Node node3;
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                this.aload(this.variableObjectLocal);
                if (node.getIntProp(26, -1) != -1) {
                    this.addOptRuntimeInvoke("setElem", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("setElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                break;
            }
            case 31: {
                Node node3;
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNext();
                }
                this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                break;
            }
            case 61: 
            case 71: {
                Node node3;
                this.visitBind(node, n3, node3);
                break;
            }
            case 68: {
                Node node3;
                this.generateCodeFromNode(node3, node, n, n2);
                this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 141: {
                Node node3;
                this.generateCodeFromNode(node3, node, n, n2);
                this.addScriptRuntimeInvoke("getParent", "(Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 69: {
                Node node3;
                this.visitNewTemp(node, node3);
                break;
            }
            case 70: {
                Node node3;
                this.visitUseTemp(node, node3);
                break;
            }
            case 144: {
                Node node3;
                this.visitNewLocal(node, node3);
                break;
            }
            case 145: {
                Node node3;
                this.visitUseLocal(node, node3);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + TokenStream.tokenToName(n3));
            }
        }
    }

    private void startNewMethod(String string, String string2, int n, boolean bl, boolean bl2) {
        this.locals = new boolean[256];
        this.localsMax = (short)(n + 1);
        this.firstFreeLocal = 0;
        this.contextLocal = (short)-1;
        this.variableObjectLocal = (short)-1;
        this.scriptResultLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.thisObjLocal = (short)-1;
        this.funObjLocal = (short)-1;
        this.debug_pcLocal = (short)-1;
        this.debugStopSubRetLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        short s = 1;
        if (bl) {
            s = (short)(s | 8);
        }
        if (bl2) {
            s = (short)(s | 0x10);
        }
        this.epilogueLabel = -1;
        this.classFile.startMethod(string, string2, s);
    }

    private void finishMethod(Context context, VariableTable variableTable) {
        JavaVariable[] javaVariableArray = OptLocalVariable.toArray(variableTable);
        this.classFile.stopMethod((short)(this.localsMax + 1), javaVariableArray);
        this.contextLocal = (short)-1;
    }

    private void generateMain(Context context) {
        this.startNewMethod("main", "([Ljava/lang/String;)V", 1, true, true);
        this.push(this.name);
        this.classFile.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
        this.addByteCode((byte)42);
        this.addScriptRuntimeInvoke("main", "(Ljava/lang/Class;[Ljava/lang/String;)", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private void generateExecute(Context context) {
        String string = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        this.startNewMethod("exec", string, 2, false, true);
        String string2 = this.name.replace('.', '/');
        if (!this.trivialInit) {
            this.addByteCode((byte)42);
            this.addByteCode((byte)44);
            this.addByteCode((byte)43);
            this.addVirtualInvoke(string2, "initScript", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)43);
        this.addByteCode((byte)44);
        this.addByteCode((byte)89);
        this.addByteCode((byte)1);
        this.addVirtualInvoke(string2, "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        this.addByteCode((byte)-80);
        this.finishMethod(context, null);
    }

    private void generateScriptCtor(Context context, Node node) {
        this.startNewMethod("<init>", "()V", 1, false, false);
        this.addByteCode((byte)42);
        this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private void setNonTrivialInit(String string) {
        if (!this.trivialInit) {
            return;
        }
        this.trivialInit = false;
        this.startNewMethod(string, "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V", 1, false, false);
        this.reserveWordLocal(0);
        this.variableObjectLocal = this.reserveWordLocal(1);
        this.contextLocal = this.reserveWordLocal(2);
    }

    private void generateInit(Context context, String string, Node node, String string2, Node node2) {
        Object object;
        String string3;
        Object object2;
        ObjArray objArray;
        int n;
        this.trivialInit = true;
        boolean bl = false;
        VariableTable variableTable = node instanceof OptFunctionNode ? ((OptFunctionNode)node).getVariableTable() : (VariableTable)node.getProp(10);
        if (string.equals("<init>")) {
            bl = true;
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
            this.addByteCode((byte)42);
            this.addByteCode((byte)43);
            this.classFile.add((byte)-75, "org/mozilla/javascript/ScriptableObject", "parent", "Lorg/mozilla/javascript/Scriptable;");
        }
        if (string2.length() != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.classFile.addLoadConstant(string2);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "functionName", "Ljava/lang/String;");
        }
        if (variableTable != null && (n = variableTable.size()) != 0) {
            this.setNonTrivialInit(string);
            this.push(n);
            this.addByteCode((byte)-67, "java/lang/String");
            for (int i = 0; i != n; ++i) {
                this.addByteCode((byte)89);
                this.push(i);
                this.push(OptLocalVariable.get(variableTable, i).getName());
                this.addByteCode((byte)83);
            }
            this.addByteCode((byte)42);
            this.addByteCode((byte)95);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argNames", "[Ljava/lang/String;");
        }
        int n2 = n = variableTable == null ? 0 : variableTable.getParameterCount();
        if (n != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(n);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argCount", "S");
        }
        if (context.getLanguageVersion() != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(context.getLanguageVersion());
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "version", "S");
        }
        if ((objArray = (ObjArray)node.getProp(12)) != null) {
            this.setNonTrivialInit(string);
            this.generateRegExpLiterals(objArray, bl);
        }
        if (node instanceof OptFunctionNode && ((OptFunctionNode)(object2 = (OptFunctionNode)node)).isTargetOfDirectCall()) {
            this.setNonTrivialInit(string);
            String string4 = ((OptFunctionNode)object2).getClassName();
            string3 = string4.replace('.', '_');
            object = 'L' + ClassFileWriter.fullyQualifiedForm(string4) + ';';
            this.classFile.addField(string3, (String)object, (short)9);
            this.addByteCode((byte)42);
            this.classFile.add((byte)-77, string4, string3, (String)object);
        }
        if (!this.trivialInit) {
            this.addByteCode((byte)-79);
            this.finishMethod(context, null);
        }
        if (context.isGeneratingSource() && (object2 = (String)node.getProp(17)) != null && ((String)object2).length() < 65536) {
            short s = 9;
            string3 = "getSourcesTreeImpl";
            this.classFile.startMethod(string3, "()Ljava/lang/Object;", s);
            object = (ObjArray)node.getProp(5);
            if (object == null) {
                this.push((String)object2);
            } else {
                this.push(1 + ((ObjArray)object).size());
                this.addByteCode((byte)-67, "java/lang/Object");
                this.addByteCode((byte)89);
                this.push(0);
                this.push((String)object2);
                this.addByteCode((byte)83);
                for (int i = 0; i != ((ObjArray)object).size(); ++i) {
                    this.addByteCode((byte)89);
                    this.push(1 + i);
                    OptFunctionNode optFunctionNode = (OptFunctionNode)((ObjArray)object).get(i);
                    this.classFile.add((byte)-72, optFunctionNode.getClassName(), string3, "()", "Ljava/lang/Object;");
                    this.addByteCode((byte)83);
                }
            }
            this.addByteCode((byte)-80);
            this.classFile.stopMethod((short)0, null);
        }
    }

    private void generateRegExpLiterals(ObjArray objArray, boolean bl) {
        for (int i = 0; i < objArray.size(); ++i) {
            Node node = (Node)objArray.get(i);
            StringBuffer stringBuffer = new StringBuffer("_re");
            stringBuffer.append(i);
            String string = stringBuffer.toString();
            short s = 2;
            if (bl) {
                s = (short)(s | 0x10);
            }
            this.classFile.addField(string, "Lorg/mozilla/javascript/regexp/NativeRegExp;", s);
            this.addByteCode((byte)42);
            this.addByteCode((byte)-69, "org/mozilla/javascript/regexp/NativeRegExp");
            this.addByteCode((byte)89);
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            Node node2 = node.getFirstChild();
            this.push(node2.getString());
            Node node3 = node.getLastChild();
            if (node2 == node3) {
                this.addByteCode((byte)1);
            } else {
                this.push(node3.getString());
            }
            this.push(0);
            this.addSpecialInvoke("org/mozilla/javascript/regexp/NativeRegExp", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Ljava/lang/String;Z)", "V");
            node.putProp(12, string);
            this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
        }
    }

    private void generatePrologue(Context context, Node node, boolean bl, int n) {
        String string;
        int n2;
        int n3;
        this.funObjLocal = this.reserveWordLocal(0);
        this.contextLocal = this.reserveWordLocal(1);
        this.variableObjectLocal = this.reserveWordLocal(2);
        this.thisObjLocal = this.reserveWordLocal(3);
        if (bl && !this.itsUseDynamicScope && n == -1) {
            this.aload(this.funObjLocal);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.variableObjectLocal);
        }
        if (n > 0) {
            for (n3 = 0; n3 < 3 * n; ++n3) {
                this.reserveWordLocal(n3 + 4);
            }
        }
        this.argsLocal = this.reserveWordLocal(n <= 0 ? 4 : 3 * n + 4);
        n3 = node.getIntProp(22, 0);
        if (n3 != 0) {
            this.itsLocalAllocationBase = (short)(this.argsLocal + 1);
            for (n2 = 0; n2 < n3; ++n2) {
                this.reserveWordLocal(this.itsLocalAllocationBase + n2);
            }
        }
        if (bl && ((OptFunctionNode)node).getCheckThis()) {
            this.aload(this.thisObjLocal);
            this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.thisObjLocal);
        }
        boolean bl2 = this.hasVarsInRegs = bl && !((OptFunctionNode)node).requiresActivation();
        if (this.hasVarsInRegs) {
            short s;
            n2 = this.vars.getParameterCount();
            if (bl && n2 > 0 && n < 0) {
                this.aload(this.argsLocal);
                this.addByteCode((byte)-66);
                this.push(n2);
                s = this.acquireLabel();
                this.addByteCode((byte)-94, s);
                this.aload(this.argsLocal);
                this.push(n2);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
                this.astore(this.argsLocal);
                this.markLabel(s);
            }
            s = -1;
            for (int i = 0; i < this.vars.size(); ++i) {
                OptLocalVariable optLocalVariable = OptLocalVariable.get(this.vars, i);
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                    this.push(0.0);
                    this.dstore(optLocalVariable.getJRegister());
                } else if (optLocalVariable.isParameter()) {
                    if (n < 0) {
                        optLocalVariable.assignJRegister(this.getNewWordLocal());
                        this.aload(this.argsLocal);
                        this.push(i);
                        this.addByteCode((byte)50);
                        this.astore(optLocalVariable.getJRegister());
                    }
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                    if (s == -1) {
                        this.pushUndefined();
                        s = optLocalVariable.getJRegister();
                    } else {
                        this.aload(s);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
                optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
            }
            this.debugVars = this.vars;
            return;
        }
        if (n > 0) {
            this.aload(this.argsLocal);
            this.push(n);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
            this.astore(this.argsLocal);
            for (n2 = 0; n2 < n; ++n2) {
                this.aload(this.argsLocal);
                this.push(n2);
                this.aload((short)(3 * n2 + 4));
                this.addByteCode((byte)83);
            }
        }
        if (bl) {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.aload(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
            string = "activation";
        } else {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.push(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)", "Lorg/mozilla/javascript/Scriptable;");
            string = "global";
        }
        this.astore(this.variableObjectLocal);
        ObjArray objArray = (ObjArray)node.getProp(5);
        if (objArray != null) {
            for (int i = 0; i < objArray.size(); ++i) {
                OptFunctionNode optFunctionNode = (OptFunctionNode)objArray.get(i);
                if (optFunctionNode.getFunctionType() != 1) continue;
                this.visitFunction(optFunctionNode, 1);
                this.addByteCode((byte)87);
            }
        }
        if (!context.isGeneratingDebugChanged() || context.isGeneratingDebug()) {
            OptLocalVariable optLocalVariable = new OptLocalVariable(string, false);
            optLocalVariable.assignJRegister(this.variableObjectLocal);
            optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
            this.debugVars = new VariableTable();
            this.debugVars.addLocal(string, optLocalVariable);
        }
        if (!bl) {
            this.scriptResultLocal = this.getNewWordLocal();
            this.pushUndefined();
            this.astore(this.scriptResultLocal);
        }
        if (bl && ((OptFunctionNode)node).containsCalls(-1)) {
            if (((OptFunctionNode)node).containsCalls(0)) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.astore(this.itsZeroArgArray);
            }
            if (((OptFunctionNode)node).containsCalls(1)) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.astore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.classFile.markLabel(this.epilogueLabel);
        }
        if (!this.hasVarsInRegs || !this.inFunction) {
            this.aload(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)-80);
    }

    private void visitFunction(OptFunctionNode optFunctionNode, int n) {
        String string = optFunctionNode.getClassName();
        this.addByteCode((byte)-69, string);
        this.addByteCode((byte)89);
        this.aload(this.variableObjectLocal);
        this.aload(this.contextLocal);
        this.addSpecialInvoke(string, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        this.addByteCode((byte)89);
        this.push(n);
        this.aload(this.variableObjectLocal);
        this.aload(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
    }

    private void visitTarget(Node node) {
        int n = node.getIntProp(20, -1);
        if (n == -1) {
            n = this.acquireLabel();
            node.putIntProp(20, n);
        }
        this.markLabel(n);
    }

    private void visitGOTO(Node node, int n, Node node2) {
        Node node3 = (Node)node.getProp(1);
        int n2 = node3.getIntProp(20, -1);
        if (n2 == -1) {
            n2 = this.acquireLabel();
            node3.putIntProp(20, n2);
        }
        int n3 = this.acquireLabel();
        if (n == 7 || n == 8) {
            if (node2 == null) {
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                if (n == 7) {
                    this.addByteCode((byte)-102, n2);
                } else {
                    this.addByteCode((byte)-103, n2);
                }
            } else {
                if (n == 7) {
                    this.generateCodeFromNode(node2, node, n2, n3);
                } else {
                    this.generateCodeFromNode(node2, node, n3, n2);
                }
                if (!Codegen.childIsBoolean(node2)) {
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    if (n == 7) {
                        this.addByteCode((byte)-102, n2);
                    } else {
                        this.addByteCode((byte)-103, n2);
                    }
                }
            }
        } else {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node, -1, -1);
                node2 = node2.getNext();
            }
            if (n == 143) {
                this.addByteCode((byte)-88, n2);
            } else {
                this.addByteCode((byte)-89, n2);
            }
        }
        this.markLabel(n3);
    }

    private void visitEnumInit(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("initEnum", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        short s = this.getNewWordLocal();
        this.astore(s);
        node.putIntProp(7, s);
    }

    private void visitEnumNext(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        Node node3 = (Node)node.getProp(4);
        int n = node3.getExistingIntProp(7);
        this.aload((short)n);
        this.addScriptRuntimeInvoke("nextEnum", "(Ljava/lang/Object;)", "Ljava/lang/Object;");
    }

    private void visitEnumDone(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        Node node3 = (Node)node.getProp(4);
        int n = node3.getExistingIntProp(7);
        this.releaseWordLocal((short)n);
    }

    private void visitEnterWith(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void visitLeaveWith(Node node, Node node2) {
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void resetTargets(Node node) {
        if (node.getType() == 137) {
            node.removeProp(20);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.resetTargets(node2);
        }
    }

    private void visitCall(Node node, int n, Node node2) {
        Node node3 = node2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        if (optFunctionNode != null) {
            int n2;
            this.generateCodeFromNode(node2, node, -1, -1);
            int n3 = this.acquireLabel();
            String string = ClassFileWriter.fullyQualifiedForm(optFunctionNode.getClassName());
            String string2 = string.replace('/', '_');
            this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(string), string2, "L" + string + ";");
            short s = this.classFile.getStackTop();
            this.addByteCode((byte)92);
            this.addByteCode((byte)-90, n3);
            this.addByteCode((byte)95);
            this.addByteCode((byte)87);
            if (!this.itsUseDynamicScope) {
                this.addByteCode((byte)89);
                this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            } else {
                this.aload(this.variableObjectLocal);
            }
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
            if (n == 30) {
                this.addByteCode((byte)1);
            } else {
                node2 = node2.getNext();
                this.generateCodeFromNode(node2, node, -1, -1);
            }
            for (node2 = node2.getNext(); node2 != null; node2 = node2.getNext()) {
                OptLocalVariable optLocalVariable;
                n2 = 0;
                if (node2.getType() == 72 && this.inDirectCallFunction && (optLocalVariable = (OptLocalVariable)node2.getProp(24)) != null && optLocalVariable.isParameter()) {
                    n2 = 1;
                    this.aload(optLocalVariable.getJRegister());
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                }
                if (n2 == 0) {
                    int n4 = node2.getIntProp(26, -1);
                    if (n4 == 0) {
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(node2, node, -1, -1);
                    } else {
                        this.generateCodeFromNode(node2, node, -1, -1);
                        this.push(0.0);
                    }
                }
                this.resetTargets(node2);
            }
            this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            if (n == 30) {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "constructDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            } else {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            }
            n2 = this.acquireLabel();
            this.addByteCode((byte)-89, n2);
            this.markLabel(n3, s);
            this.addByteCode((byte)87);
            this.visitRegularCall(node, n, node3, true);
            this.markLabel(n2);
        } else {
            this.visitRegularCall(node, n, node3, false);
        }
    }

    private String getSimpleCallName(Node node) {
        Node node2;
        Node node3 = node.getFirstChild();
        if (node3.getType() == 39 && (node2 = node3.getFirstChild()).getType() == 69) {
            Node node4 = node2.getNext();
            Node node5 = node2.getFirstChild();
            if (node5.getType() == 71) {
                Node node6;
                Node node7;
                Node node8;
                String string = node5.getString();
                if (node4 != null && node4.getType() == 46 && string.equals(node4.getString()) && (node8 = node3.getNext()).getType() == 68 && (node7 = node8.getFirstChild()).getType() == 70 && (node6 = (Node)node7.getProp(6)) == node2) {
                    return string;
                }
            }
        }
        return null;
    }

    private void constructArgArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.aload(this.itsZeroArgArray);
            } else {
                this.push(0);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else if (n == 1) {
            if (this.itsOneArgArray >= 0) {
                this.aload(this.itsOneArgArray);
            } else {
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else {
            this.push(n);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
    }

    private void visitRegularCall(Node node, int n, Node node2, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        int n2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        Node node3 = node2;
        int n3 = 0;
        int n4 = n2 = n == 30 ? 1 : 2;
        while (node2 != null) {
            ++n3;
            node2 = node2.getNext();
        }
        node2 = node3;
        int n5 = -n2;
        if (bl && node2 != null) {
            node2 = node2.getNext();
            ++n5;
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
        } else {
            this.aload(this.contextLocal);
        }
        if (bl && n == 30) {
            this.constructArgArray(n3 - n2);
        }
        boolean bl2 = node.getProp(30) != null;
        boolean bl3 = false;
        String string4 = null;
        if (n != 30 && (string4 = this.getSimpleCallName(node)) != null && !bl2) {
            bl3 = true;
            this.push(string4);
            this.aload(this.variableObjectLocal);
            node2 = node2.getNext().getNext();
            n5 = 0;
            this.push(n3 - n2);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
        while (node2 != null) {
            if (n5 < 0) {
                this.generateCodeFromNode(node2, node, -1, -1);
            } else {
                this.addByteCode((byte)89);
                this.push(n5);
                if (optFunctionNode != null) {
                    boolean bl4 = false;
                    if (node2.getType() == 72 && this.inDirectCallFunction && (object = (OptLocalVariable)node2.getProp(24)) != null && ((OptLocalVariable)object).isParameter()) {
                        node2.removeProp(26);
                        this.generateCodeFromNode(node2, node, -1, -1);
                        bl4 = true;
                    }
                    if (!bl4) {
                        int n6 = node2.getIntProp(26, -1);
                        if (n6 == 0) {
                            this.addByteCode((byte)-69, "java/lang/Double");
                            this.addByteCode((byte)89);
                            this.generateCodeFromNode(node2, node, -1, -1);
                            this.addDoubleConstructor();
                        } else {
                            this.generateCodeFromNode(node2, node, -1, -1);
                        }
                    }
                } else {
                    this.generateCodeFromNode(node2, node, -1, -1);
                }
                this.addByteCode((byte)83);
            }
            if (++n5 == 0) {
                this.constructArgArray(n3 - n2);
            }
            node2 = node2.getNext();
        }
        if (bl2) {
            string3 = "org/mozilla/javascript/ScriptRuntime";
            object = "newObjectSpecial";
            string2 = "callSpecial";
            if (n != 30) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;I)";
                this.aload(this.thisObjLocal);
                this.aload(this.variableObjectLocal);
                this.push(this.itsSourceFile == null ? "" : this.itsSourceFile);
                this.push(this.itsLineNumber);
            } else {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                this.aload(this.variableObjectLocal);
            }
        } else {
            object = "newObject";
            if (bl3) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)";
                string2 = "callSimple";
                string3 = "org/mozilla/javascript/optimizer/OptRuntime";
            } else {
                this.aload(this.variableObjectLocal);
                string = n == 30 ? "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)" : "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                string2 = "call";
                string3 = "org/mozilla/javascript/ScriptRuntime";
            }
        }
        if (n == 30) {
            this.addStaticInvoke(string3, (String)object, string, "Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.addStaticInvoke(string3, string2, string, "Ljava/lang/Object;");
        }
    }

    private void visitStatement(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.classFile.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node node, Node node2) {
        int n;
        short s3 = this.getNewWordLocal();
        this.aload(this.variableObjectLocal);
        this.astore(s3);
        int n2 = this.acquireLabel();
        this.markLabel(n2, (short)1);
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        Node node3 = (Node)node.getProp(1);
        Node node4 = (Node)node.getProp(21);
        int n3 = this.acquireLabel();
        this.addByteCode((byte)-89, n3);
        if (node3 != null) {
            n = node3.getExistingIntProp(20);
            this.generateCatchBlock(0, s3, n, n2);
            this.generateCatchBlock(1, s3, n, n2);
            int s2 = this.acquireLabel();
            this.classFile.markHandler(s2);
            short s = this.getNewWordLocal();
            this.astore(s);
            this.aload(s3);
            this.astore(this.variableObjectLocal);
            this.aload(s);
            this.addVirtualInvoke("org/mozilla/javascript/EcmaError", "getErrorObject", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.releaseWordLocal(s);
            this.addByteCode((byte)-89, n);
            this.classFile.addExceptionHandler(n2, n, s2, "org/mozilla/javascript/EcmaError");
        }
        if (node4 != null) {
            n = this.acquireLabel();
            this.classFile.markHandler(n);
            this.aload(s3);
            this.astore(this.variableObjectLocal);
            short s = this.itsLocalAllocationBase;
            this.itsLocalAllocationBase = (short)(s + 1);
            short s2 = s;
            this.astore(s2);
            int n4 = node4.getExistingIntProp(20);
            this.addByteCode((byte)-88, n4);
            this.aload(s2);
            this.addByteCode((byte)-65);
            this.classFile.addExceptionHandler(n2, n4, n, null);
        }
        this.releaseWordLocal(s3);
        this.markLabel(n3);
    }

    private void generateCatchBlock(int n, short s, int n2, int n3) {
        int n4 = this.acquireLabel();
        this.classFile.markHandler(n4);
        short s2 = this.getNewWordLocal();
        this.astore(s2);
        this.aload(s);
        this.astore(this.variableObjectLocal);
        this.aload(s2);
        this.releaseWordLocal(s2);
        if (n == 0) {
            this.addScriptRuntimeInvoke("unwrapJavaScriptException", "(Lorg/mozilla/javascript/JavaScriptException;)", "Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("unwrapWrappedException", "(Lorg/mozilla/javascript/WrappedException;)", "Ljava/lang/Object;");
        }
        String string = n == 0 ? "org/mozilla/javascript/JavaScriptException" : "org/mozilla/javascript/WrappedException";
        this.classFile.addExceptionHandler(n3, n2, n4, string);
        this.addByteCode((byte)-89, n2);
    }

    private void visitThrow(Node node, Node node2) {
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.addByteCode((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.addByteCode((byte)90);
        this.addByteCode((byte)95);
        this.addSpecialInvoke("org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;)", "V");
        this.addByteCode((byte)-65);
    }

    private void visitReturn(Node node, Node node2) {
        this.visitStatement(node);
        if (node2 != null) {
            do {
                this.generateCodeFromNode(node2, node, -1, -1);
            } while ((node2 = node2.getNext()) != null);
        } else if (this.inFunction) {
            this.pushUndefined();
        } else {
            this.aload(this.scriptResultLocal);
        }
        if (this.epilogueLabel == -1) {
            this.epilogueLabel = this.classFile.acquireLabel();
        }
        this.addByteCode((byte)-89, this.epilogueLabel);
    }

    private void visitSwitch(Node node, Node node2) {
        Node node3;
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        short s = this.getNewWordLocal();
        this.astore(s);
        ObjArray objArray = (ObjArray)node.getProp(13);
        for (int i = 0; i < objArray.size(); ++i) {
            node3 = (Node)objArray.get(i);
            Node node4 = node3.getFirstChild();
            this.generateCodeFromNode(node4, node3, -1, -1);
            this.aload(s);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            Node node5 = new Node(137);
            node3.replaceChild(node4, node5);
            this.generateGOTO(7, node5);
        }
        Node node6 = (Node)node.getProp(14);
        if (node6 != null) {
            node3 = new Node(137);
            node6.getFirstChild().addChildToFront(node3);
            this.generateGOTO(6, node3);
        }
        node3 = (Node)node.getProp(2);
        this.generateGOTO(6, node3);
    }

    private void generateGOTO(int n, Node node) {
        Node node2 = new Node(n);
        node2.putProp(1, node);
        this.visitGOTO(node2, n, null);
    }

    private void visitUnary(Node node, Node node2, int n, int n2) {
        int n3 = node.getOperation();
        switch (n3) {
            case 129: {
                if (n != -1) {
                    this.generateCodeFromNode(node2, node, n2, n);
                    if (Codegen.childIsBoolean(node2)) break;
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-102, n2);
                    this.addByteCode((byte)-89, n);
                    break;
                }
                int n4 = this.acquireLabel();
                int n5 = this.acquireLabel();
                int n6 = this.acquireLabel();
                this.generateCodeFromNode(node2, node, n4, n5);
                if (!Codegen.childIsBoolean(node2)) {
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-103, n5);
                    this.addByteCode((byte)-89, n4);
                }
                this.markLabel(n4);
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.addByteCode((byte)-89, n6);
                this.markLabel(n5);
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.markLabel(n6);
                this.classFile.adjustStackTop(-1);
                break;
            }
            case 32: {
                this.visitTypeof(node, node2);
                break;
            }
            case 132: {
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addByteCode((byte)87);
                this.pushUndefined();
                break;
            }
            case 28: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
                this.push(-1);
                this.addByteCode((byte)-126);
                this.addByteCode((byte)-121);
                this.addDoubleConstructor();
                break;
            }
            case 23: 
            case 24: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                if (n3 == 24) {
                    this.addByteCode((byte)119);
                }
                this.addDoubleConstructor();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private static boolean childIsBoolean(Node node) {
        switch (node.getType()) {
            case 105: {
                return node.getOperation() == 129;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return true;
            }
        }
        return false;
    }

    private void visitTypeof(Node node, Node node2) {
        OptLocalVariable optLocalVariable;
        if (node.getType() == 105) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        String string = node.getString();
        if (this.hasVarsInRegs && (optLocalVariable = OptLocalVariable.get(this.vars, string)) != null) {
            if (optLocalVariable.isNumber()) {
                this.push("number");
                return;
            }
            this.visitGetVar(optLocalVariable, false, string);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/String;");
    }

    private void visitIncDec(Node node, boolean bl) {
        Node node2 = node.getFirstChild();
        if (node.getIntProp(26, -1) != -1) {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            if (optLocalVariable.getJRegister() == -1) {
                optLocalVariable.assignJRegister(this.getNewWordPairLocal());
            }
            this.dload(optLocalVariable.getJRegister());
            this.addByteCode((byte)92);
            this.push(1.0);
            this.addByteCode(bl ? (byte)99 : 103);
            this.dstore(optLocalVariable.getJRegister());
        } else {
            String string;
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            String string2 = string = bl ? "postIncrement" : "postDecrement";
            if (this.hasVarsInRegs && node2.getType() == 72) {
                if (optLocalVariable == null) {
                    optLocalVariable = OptLocalVariable.get(this.vars, node2.getString());
                }
                if (optLocalVariable.getJRegister() == -1) {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
                this.aload(optLocalVariable.getJRegister());
                this.addByteCode((byte)89);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;)", "Ljava/lang/Object;");
                this.astore(optLocalVariable.getJRegister());
            } else if (node2.getType() == 39) {
                Node node3 = node2.getFirstChild();
                this.generateCodeFromNode(node3, node, -1, -1);
                this.generateCodeFromNode(node3.getNext(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else if (node2.getType() == 41) {
                string = string + "Elem";
                Node node4 = node2.getFirstChild();
                this.generateCodeFromNode(node4, node, -1, -1);
                this.generateCodeFromNode(node4.getNext(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.push(node2.getString());
                this.addScriptRuntimeInvoke(string, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
            }
        }
    }

    private boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 24 || n == 27 || n == 26 || n == 25;
    }

    private void visitArithmetic(Node node, byte by, Node node2, Node node3) {
        int n = node.getIntProp(26, -1);
        if (n != -1) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.addByteCode(by);
        } else {
            boolean bl = this.isArithmeticNode(node3);
            if (!bl) {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            if (!this.isArithmeticNode(node2)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            if (!this.isArithmeticNode(node2.getNext())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.addByteCode(by);
            if (!bl) {
                this.addDoubleConstructor();
            }
        }
    }

    private void visitBitOp(Node node, int n, Node node2) {
        int n2 = node.getIntProp(26, -1);
        if (n2 == -1) {
            this.addByteCode((byte)-69, "java/lang/Double");
            this.addByteCode((byte)89);
        }
        this.generateCodeFromNode(node2, node, -1, -1);
        if (n == 22) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)", "J");
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.push(31);
            this.addByteCode((byte)126);
            this.addByteCode((byte)125);
            this.addByteCode((byte)-118);
            this.addDoubleConstructor();
            return;
        }
        if (n2 == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
        }
        switch (n) {
            case 11: {
                this.addByteCode((byte)-128);
                break;
            }
            case 12: {
                this.addByteCode((byte)-126);
                break;
            }
            case 13: {
                this.addByteCode((byte)126);
                break;
            }
            case 21: {
                this.addByteCode((byte)122);
                break;
            }
            case 20: {
                this.addByteCode((byte)120);
                break;
            }
            default: {
                this.badTree();
            }
        }
        this.addByteCode((byte)-121);
        if (n2 == -1) {
            this.addDoubleConstructor();
        }
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable optLocalVariable;
        return node.getType() == 72 && (optLocalVariable = (OptLocalVariable)node.getProp(24)) != null && optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        switch (n) {
            case 17: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-98, n2);
                break;
            }
            case 19: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-100, n2);
                break;
            }
            case 16: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-101, n2);
                break;
            }
            case 18: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-99, n2);
            }
        }
        if (n3 != -1) {
            this.addByteCode((byte)-89, n3);
        }
    }

    private void visitGOTOingRelOp(Node node, Node node2, Node node3, int n, int n2) {
        int n3 = node.getOperation();
        int n4 = node.getIntProp(26, -1);
        if (n4 == 0) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.genSimpleCompare(n3, n, n2);
        } else if (n3 == 64) {
            this.aload(this.variableObjectLocal);
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else if (n3 == 63) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else {
            Object object;
            Node node4 = node2.getNext();
            boolean bl = this.nodeIsDirectCallParameter(node2);
            boolean bl2 = this.nodeIsDirectCallParameter(node4);
            if (bl || bl2) {
                int n5;
                if (bl) {
                    if (bl2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        OptLocalVariable optLocalVariable = (OptLocalVariable)node4.getProp(24);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    } else if (n4 == 2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.generateCodeFromNode(node4, node, -1, -1);
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    }
                } else if (n4 == 1) {
                    object = (OptLocalVariable)node4.getProp(24);
                    this.aload(((OptLocalVariable)object).getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    n5 = this.acquireLabel();
                    this.addByteCode((byte)-90, n5);
                    this.generateCodeFromNode(node2, node, -1, -1);
                    this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                    this.genSimpleCompare(n3, n, n2);
                    this.markLabel(n5);
                }
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node4, node, -1, -1);
            if (n4 == -1) {
                if (n3 == 19 || n3 == 18) {
                    this.addByteCode((byte)95);
                }
                object = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "I");
            } else {
                String string;
                boolean bl3;
                boolean bl4 = bl3 = n4 == 1;
                if (n3 == 19 || n3 == 18) {
                    if (bl3) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl3 = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl3 = true;
                    }
                }
                String string2 = string = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                if (bl3) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "I");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "I");
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitRelOp(Node node, Node node2, Node node3) {
        int n = node.getOperation();
        int n2 = node.getIntProp(26, -1);
        if (n2 == 0 || n == 64 || n == 63) {
            if (n == 64) {
                this.aload(this.variableObjectLocal);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            int n3 = this.acquireLabel();
            int n4 = this.acquireLabel();
            if (n == 64) {
                this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else if (n == 63) {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else {
                this.genSimpleCompare(n, n3, -1);
            }
            this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.addByteCode((byte)-89, n4);
            this.markLabel(n3);
            this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.markLabel(n4);
            this.classFile.adjustStackTop(-1);
        } else {
            String string = n == 16 || n == 18 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            if (n2 == -1) {
                if (n == 19 || n == 18) {
                    this.addByteCode((byte)95);
                }
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            } else {
                boolean bl;
                boolean bl2 = bl = n2 == 1;
                if (n == 19 || n == 18) {
                    if (bl) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl = true;
                    }
                }
                if (bl) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "Ljava/lang/Boolean;");
                }
            }
        }
    }

    private Node getConvertToObjectOfNumberNode(Node node) {
        Node node2;
        Object object;
        if (node.getType() == 142 && (object = node.getProp(18)) == ScriptRuntime.ObjectClass && (node2 = node.getFirstChild()).getType() == 45) {
            return node2;
        }
        return null;
    }

    private void visitEqOp(Node node, Node node2, Node node3, int n, int n2) {
        boolean bl;
        int n3 = node.getOperation();
        Node node4 = node2.getNext();
        boolean bl2 = bl = n3 == 53 || n3 == 54;
        if (n == -1) {
            String string;
            if (node4.getType() == 109 && node4.getOperation() == 49) {
                this.generateCodeFromNode(node2, node, -1, -1);
                if (bl) {
                    this.addByteCode((byte)-58, 9);
                } else {
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)-58, 15);
                    this.pushUndefined();
                    this.addByteCode((byte)-91, 10);
                }
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                }
                if (bl) {
                    this.addByteCode((byte)-89, 6);
                } else {
                    this.addByteCode((byte)-89, 7);
                    this.addByteCode((byte)87);
                }
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                }
                return;
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            switch (n3) {
                case 14: {
                    string = this.version == 120 ? "seqB" : "eqB";
                    break;
                }
                case 15: {
                    string = this.version == 120 ? "sneB" : "neB";
                    break;
                }
                case 53: {
                    string = "seqB";
                    break;
                }
                case 54: {
                    string = "sneB";
                    break;
                }
                default: {
                    string = null;
                    this.badTree();
                }
            }
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
        } else {
            Object object;
            if (node4.getType() == 109 && node4.getOperation() == 49) {
                int n4;
                if (n3 != 14 && n3 != 53) {
                    n4 = n;
                    n = n2;
                    n2 = n4;
                }
                this.generateCodeFromNode(node2, node, -1, -1);
                if (bl) {
                    this.addByteCode((byte)-58, n);
                    this.addByteCode((byte)-89, n2);
                    return;
                }
                int n5 = n4 = node2.getType() == 72 ? 1 : 0;
                if (n4 == 0) {
                    this.addByteCode((byte)89);
                }
                int n6 = this.acquireLabel();
                this.addByteCode((byte)-58, n4 != 0 ? n : n6);
                short s = this.classFile.getStackTop();
                if (n4 != 0) {
                    this.generateCodeFromNode(node2, node, -1, -1);
                }
                this.pushUndefined();
                this.addByteCode((byte)-91, n);
                this.addByteCode((byte)-89, n2);
                if (n4 == 0) {
                    this.markLabel(n6, s);
                    this.addByteCode((byte)87);
                    this.addByteCode((byte)-89, n);
                }
                return;
            }
            Node node5 = node2.getNext();
            if (this.nodeIsDirectCallParameter(node2) && (object = this.getConvertToObjectOfNumberNode(node5)) != null) {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
                this.aload(optLocalVariable.getJRegister());
                this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n7 = this.acquireLabel();
                this.addByteCode((byte)-90, n7);
                this.dload((short)(optLocalVariable.getJRegister() + 1));
                this.push(((Node)object).getDouble());
                this.addByteCode((byte)-105);
                if (n3 == 14) {
                    this.addByteCode((byte)-103, n);
                } else {
                    this.addByteCode((byte)-102, n);
                }
                this.addByteCode((byte)-89, n2);
                this.markLabel(n7);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node5, node, -1, -1);
            switch (n3) {
                case 14: {
                    object = this.version == 120 ? "shallowEq" : "eq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 15: {
                    object = this.version == 120 ? "shallowNeq" : "neq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 53: {
                    object = "shallowEq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 54: {
                    object = "shallowNeq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                default: {
                    object = null;
                    this.badTree();
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 46) {
            this.push(node.getString());
        } else {
            double d = node.getDouble();
            if (node.getIntProp(26, -1) != -1) {
                this.push(d);
            } else if (this.itsConstantListSize >= 2000) {
                this.pushAsWrapperObject(d);
            } else {
                String string = "jsK_" + this.addNumberConstant(d);
                String string2 = this.getStaticConstantWrapperType(d);
                this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(this.name), string, string2);
            }
        }
    }

    private String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        String string = (double)n == d ? ((byte)n == n ? "Ljava/lang/Byte;" : ((short)n == n ? "Ljava/lang/Short;" : "Ljava/lang/Integer;")) : "Ljava/lang/Double;";
        return string;
    }

    private int addNumberConstant(double d) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            this.itsConstantList = new double[128];
        } else {
            double[] dArray = this.itsConstantList;
            for (int i = 0; i != n; ++i) {
                if (dArray[i] != d) continue;
                return i;
            }
            if (n == dArray.length) {
                dArray = new double[n * 2];
                System.arraycopy(this.itsConstantList, 0, dArray, 0, n);
                this.itsConstantList = dArray;
            }
        }
        this.itsConstantList[n] = d;
        this.itsConstantListSize = n + 1;
        return n;
    }

    private void emitConstantDudeInitializers() {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        this.classFile.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        for (int i = 0; i != n; ++i) {
            double d = dArray[i];
            String string = "jsK_" + this.addNumberConstant(d);
            String string2 = this.getStaticConstantWrapperType(d);
            this.classFile.addField(string, string2, (short)8);
            this.pushAsWrapperObject(d);
            this.classFile.add((byte)-77, ClassFileWriter.fullyQualifiedForm(this.name), string, string2);
        }
        this.addByteCode((byte)-79);
        this.classFile.stopMethod((short)0, null);
    }

    private void visitPrimary(Node node) {
        int n = node.getOperation();
        switch (n) {
            case 50: {
                this.aload(this.thisObjLocal);
                break;
            }
            case 87: {
                this.classFile.add((byte)42);
                break;
            }
            case 49: {
                this.addByteCode((byte)1);
                break;
            }
            case 52: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 51: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 74: {
                this.pushUndefined();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitObject(Node node) {
        Node node2 = (Node)node.getProp(12);
        String string = (String)node2.getProp(12);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
    }

    private void visitName(Node node) {
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitGetVar(OptLocalVariable optLocalVariable, boolean bl, String string) {
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = OptLocalVariable.get(this.vars, string);
        }
        if (optLocalVariable != null) {
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n3 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n3);
                    this.markLabel(n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.addDoubleConstructor();
                    this.markLabel(n3);
                }
            } else if (optLocalVariable.isNumber()) {
                this.dload(optLocalVariable.getJRegister());
            } else {
                this.aload(optLocalVariable.getJRegister());
            }
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = OptLocalVariable.get(this.vars, node2.getString());
        }
        if (optLocalVariable != null) {
            this.generateCodeFromNode(node2.getNext(), node, -1, -1);
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getIntProp(26, -1) != -1) {
                    if (bl) {
                        this.addByteCode((byte)92);
                    }
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)94);
                    this.addByteCode((byte)88);
                    this.addDoubleConstructor();
                    this.astore(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dstore((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    if (bl) {
                        this.addByteCode((byte)89);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
            } else if (node.getIntProp(26, -1) != -1) {
                this.dstore(optLocalVariable.getJRegister());
                if (bl) {
                    this.dload(optLocalVariable.getJRegister());
                }
            } else {
                this.astore(optLocalVariable.getJRegister());
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                }
            }
            return;
        }
        node2.setType(61);
        node.setType(10);
        this.visitSetName(node, node2);
        if (!bl) {
            this.addByteCode((byte)87);
        }
    }

    private void visitGetProp(Node node, Node node2) {
        String string = (String)node.getProp(19);
        if (string != null) {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node, -1, -1);
                node2 = node2.getNext();
            }
            this.aload(this.variableObjectLocal);
            String string2 = null;
            if (string.equals("__proto__")) {
                string2 = "getProto";
            } else if (string.equals("__parent__")) {
                string2 = "getParent";
            } else {
                this.badTree();
            }
            this.addScriptRuntimeInvoke(string2, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node node3 = node2.getNext();
        this.generateCodeFromNode(node2, node, -1, -1);
        this.generateCodeFromNode(node3, node, -1, -1);
        if (node3.getType() == 46) {
            if (node2.getType() == 109 && node2.getOperation() == 50 || node2.getType() == 69 && node2.getFirstChild().getType() == 109 && node2.getFirstChild().getOperation() == 50) {
                this.aload(this.variableObjectLocal);
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            }
        } else {
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        }
    }

    private void visitSetProp(Node node, Node node2) {
        String string = (String)node.getProp(19);
        if (string != null) {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node, -1, -1);
                node2 = node2.getNext();
            }
            this.aload(this.variableObjectLocal);
            String string2 = null;
            if (string.equals("__proto__")) {
                string2 = "setProto";
            } else if (string.equals("__parent__")) {
                string2 = "setParent";
            } else {
                this.badTree();
            }
            this.addScriptRuntimeInvoke(string2, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            return;
        }
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitBind(Node node, int n, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke(n == 61 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Lorg/mozilla/javascript/Scriptable;");
    }

    private short getLocalFromNode(Node node) {
        int n = node.getIntProp(7, -1);
        if (n == -1) {
            short s;
            if (node.getType() == 144 || node.getType() == 145) {
                short s2 = this.itsLocalAllocationBase;
                s = s2;
                this.itsLocalAllocationBase = (short)(s2 + 1);
            } else {
                s = this.getNewWordLocal();
            }
            n = s;
            node.putIntProp(7, n);
        }
        return (short)n;
    }

    private void visitNewTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
        if (node.getIntProp(11, 0) == 0) {
            this.releaseWordLocal(s);
        }
    }

    private void visitUseTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        Node node3 = (Node)node.getProp(6);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
        int n = node3.getIntProp(11, 0);
        if (n <= 1) {
            this.releaseWordLocal(s);
        }
        if (n != 0 && n != Integer.MAX_VALUE) {
            node3.putIntProp(11, n - 1);
        }
    }

    private void visitNewLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
    }

    private void visitUseLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNext();
        }
        Node node3 = (Node)node.getProp(7);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
    }

    private void dstore(short s) {
        this.xop((byte)71, (byte)57, s);
    }

    private void istore(short s) {
        this.xop((byte)59, (byte)54, s);
    }

    private void astore(short s) {
        this.xop((byte)75, (byte)58, s);
    }

    private void xop(byte by, byte by2, short s) {
        switch (s) {
            case 0: {
                this.addByteCode(by);
                break;
            }
            case 1: {
                this.addByteCode((byte)(by + 1));
                break;
            }
            case 2: {
                this.addByteCode((byte)(by + 2));
                break;
            }
            case 3: {
                this.addByteCode((byte)(by + 3));
                break;
            }
            default: {
                if (s < 0 || s >= Short.MAX_VALUE) {
                    throw new RuntimeException("bad local");
                }
                if (s < 127) {
                    this.addByteCode(by2, (byte)s);
                    break;
                }
                this.addByteCode((byte)-60);
                this.addByteCode(by2);
                this.addByteCode((byte)(s >> 8));
                this.addByteCode((byte)(s & 0xFF));
            }
        }
    }

    private void dload(short s) {
        this.xop((byte)38, (byte)24, s);
    }

    private void iload(short s) {
        this.xop((byte)26, (byte)21, s);
    }

    private void aload(short s) {
        this.xop((byte)42, (byte)25, s);
    }

    private short getNewWordPairLocal() {
        short s;
        for (s = this.firstFreeLocal; s < 255 && (this.locals[s] || this.locals[s + 1]); s = (short)(s + 1)) {
        }
        if (s < 255) {
            this.locals[s] = true;
            this.locals[s + 1] = true;
            if (s == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 2; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return s;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short reserveWordLocal(int n) {
        if (this.getNewWordLocal() != n) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)n;
    }

    private short getNewWordLocal() {
        short s = this.firstFreeLocal;
        this.locals[s] = true;
        for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
            if (this.locals[i]) continue;
            this.firstFreeLocal = (short)i;
            if (this.localsMax < this.firstFreeLocal) {
                this.localsMax = this.firstFreeLocal;
            }
            return s;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void releaseWordpairLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
        this.locals[s + 1] = false;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
    }

    private void push(int n) {
        if ((byte)n == n) {
            if (n == -1) {
                this.addByteCode((byte)2);
            } else if (0 <= n && n <= 5) {
                this.addByteCode((byte)(3 + n));
            } else {
                this.addByteCode((byte)16, (byte)n);
            }
        } else if ((short)n == n) {
            this.addByteCode((byte)17, (short)n);
        } else {
            this.classFile.addLoadConstant(n);
        }
    }

    private void push(double d) {
        if (d == 0.0) {
            this.addByteCode((byte)14);
        } else if (d == 1.0) {
            this.addByteCode((byte)15);
        } else {
            this.classFile.addLoadConstant(d);
        }
    }

    private void pushAsWrapperObject(double d) {
        String string;
        String string2;
        boolean bl;
        int n = (int)d;
        if ((double)n == d) {
            bl = true;
            if ((byte)n == n) {
                string2 = "java/lang/Byte";
                string = "(B)";
            } else if ((short)n == n) {
                string2 = "java/lang/Short";
                string = "(S)";
            } else {
                string2 = "java/lang/Integer";
                string = "(I)";
            }
        } else {
            bl = false;
            string2 = "java/lang/Double";
            string = "(D)";
        }
        this.addByteCode((byte)-69, string2);
        this.addByteCode((byte)89);
        if (bl) {
            this.push(n);
        } else {
            this.push(d);
        }
        this.addSpecialInvoke(string2, "<init>", string, "V");
    }

    private void push(String string) {
        this.classFile.addLoadConstant(string);
    }

    private void pushUndefined() {
        this.classFile.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    private void badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

