/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaPackage
extends ScriptableObject {
    static final String[] commonPackages = new String[]{"java.lang", "java.lang.reflect", "java.io", "java.math", "java.util", "java.util.zip", "java.text", "java.text.resources", "java.applet"};
    private String packageName;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeJavaPackage;

    public static Scriptable init(Scriptable scriptable) throws PropertyException {
        TopLevelPackage topLevelPackage = new TopLevelPackage();
        topLevelPackage.setPrototype(NativeJavaPackage.getObjectPrototype(scriptable));
        topLevelPackage.setParentScope(scriptable);
        NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)topLevelPackage.get("java", (Scriptable)topLevelPackage);
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty("Packages", topLevelPackage, 2);
        scriptableObject.defineProperty("java", nativeJavaPackage, 2);
        for (int i = 0; i < commonPackages.length; ++i) {
            topLevelPackage.forcePackage(commonPackages[i]);
        }
        Method[] methodArray = FunctionObject.findMethods(class$org$mozilla$javascript$NativeJavaPackage == null ? (class$org$mozilla$javascript$NativeJavaPackage = NativeJavaPackage.class$("org.mozilla.javascript.NativeJavaPackage")) : class$org$mozilla$javascript$NativeJavaPackage, "jsFunction_getClass");
        FunctionObject functionObject = new FunctionObject("getClass", methodArray[0], scriptableObject);
        scriptableObject.defineProperty("getClass", functionObject, 2);
        return topLevelPackage;
    }

    void forcePackage(String string) {
        NativeJavaPackage nativeJavaPackage;
        String string2;
        Object object;
        int n = string.indexOf(46);
        if (n == -1) {
            n = string.length();
        }
        if ((object = super.get(string2 = string.substring(0, n), (Scriptable)this)) != null && object instanceof NativeJavaPackage) {
            nativeJavaPackage = (NativeJavaPackage)object;
        } else {
            String string3 = this.packageName.length() == 0 ? string2 : this.packageName + "." + string2;
            nativeJavaPackage = new NativeJavaPackage(string3, this.classLoader);
            nativeJavaPackage.setParentScope(this);
            nativeJavaPackage.setPrototype(this.prototype);
            super.put(string2, (Scriptable)this, (Object)nativeJavaPackage);
        }
        if (n < string.length()) {
            nativeJavaPackage.forcePackage(string.substring(n + 1));
        }
    }

    public NativeJavaPackage(String string) {
        this(string, null);
    }

    public NativeJavaPackage(String string, ClassLoader classLoader) {
        this.packageName = string;
        this.classLoader = classLoader != null ? classLoader : Context.getContext().getApplicationClassLoader();
    }

    public String getClassName() {
        return "JavaPackage";
    }

    public boolean has(String string, Scriptable scriptable) {
        return true;
    }

    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    public void put(String string, Scriptable scriptable, Object object) {
    }

    public void put(int n, Scriptable scriptable, Object object) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    public Object get(String string, Scriptable scriptable) {
        return this.getPkgProperty(string, scriptable, true);
    }

    public Object get(int n, Scriptable scriptable) {
        return Scriptable.NOT_FOUND;
    }

    synchronized Object getPkgProperty(String string, Scriptable scriptable, boolean bl) {
        Serializable serializable;
        Object object = super.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        String string2 = this.packageName.length() == 0 ? string : this.packageName + '.' + string;
        Context context = Context.getContext();
        ClassShutter classShutter = context.getClassShutter();
        Serializable serializable2 = null;
        if ((classShutter == null || classShutter.visibleToScripts(string2)) && (serializable = NativeJavaPackage.findClass(this.classLoader, string2)) != null) {
            serializable2 = new NativeJavaClass(NativeJavaPackage.getTopLevelScope(this), (Class)serializable);
            serializable2.setParentScope(this);
            serializable2.setPrototype(this.prototype);
        }
        if (serializable2 == null && bl) {
            serializable = new NativeJavaPackage(string2, this.classLoader);
            ((ScriptableObject)serializable).setParentScope(this);
            ((ScriptableObject)serializable).setPrototype(this.prototype);
            serializable2 = serializable;
        }
        if (serializable2 != null) {
            super.put(string, scriptable, serializable2);
        }
        return serializable2;
    }

    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }

    public static Scriptable jsFunction_getClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length > 0 && objectArray[0] instanceof Wrapper) {
            int n;
            String string;
            Object object;
            Scriptable scriptable2 = NativeJavaPackage.getTopLevelScope(scriptable);
            Class<?> clazz = ((Wrapper)objectArray[0]).unwrap().getClass();
            String string2 = "Packages." + clazz.getName();
            int n2 = 0;
            while ((object = scriptable2.get(string = (n = string2.indexOf(46, n2)) == -1 ? string2.substring(n2) : string2.substring(n2, n), scriptable2)) instanceof Scriptable) {
                scriptable2 = (Scriptable)object;
                if (n == -1) {
                    return scriptable2;
                }
                n2 = n + 1;
            }
        }
        throw Context.reportRuntimeError(Context.getMessage0("msg.not.java.obj"));
    }

    private static Class findClass(ClassLoader classLoader, String string) {
        Class<?> clazz = null;
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {}
        } else {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TopLevelPackage
    extends NativeJavaPackage
    implements Function {
        public TopLevelPackage() {
            super("");
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            return this.construct(context, scriptable, objectArray);
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
            ClassLoader classLoader = this.getClassLoaderFromArgs(objectArray);
            if (classLoader == null) {
                Context.reportRuntimeError0("msg.not.classloader");
                return null;
            }
            return new NativeJavaPackage("", classLoader);
        }

        private ClassLoader getClassLoaderFromArgs(Object[] objectArray) {
            if (objectArray.length < 1) {
                return null;
            }
            Object object = objectArray[0];
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            if (!(object instanceof ClassLoader)) {
                return null;
            }
            return (ClassLoader)object;
        }
    }
}

