/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.util.XStringSubstitution;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.ui.event.ListModelBinder;
import com.sun.star.wizards.web.AbstractErrorHandler;
import com.sun.star.wizards.web.FTPDialog;
import com.sun.star.wizards.web.StatusDialog;
import com.sun.star.wizards.web.WebWizardDialog;
import com.sun.star.wizards.web.data.CGDocument;
import com.sun.star.wizards.web.data.CGFilter;
import com.sun.star.wizards.web.data.CGPublish;
import com.sun.star.wizards.web.data.CGSettings;

public abstract class WWD_General
extends WebWizardDialog {
    private FileAccess fileAccess;
    private SystemDialog docAddDialog;
    private SystemDialog folderDialog;
    private SystemDialog favIconDialog;
    private SystemDialog zipDialog;
    protected FTPDialog ftpDialog;
    protected CGSettings settings;
    protected boolean proxies;
    private XStringSubstitution xStringSubstitution;

    protected StatusDialog getStatusDialog() {
        StatusDialog statusDialog = new StatusDialog(this.xMSF, 202, this.resources.resLoadingSession, false, new String[]{this.resources.prodName, "", "", "", "", ""}, "HID:34206");
        try {
            statusDialog.createWindowPeer(this.xControl.getPeer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return statusDialog;
    }

    public WWD_General(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.xStringSubstitution = SystemDialog.createStringSubstitution((XMultiServiceFactory)xMultiServiceFactory);
    }

    protected SystemDialog getDocAddDialog() {
        this.docAddDialog = SystemDialog.createOpenDialog((XMultiServiceFactory)this.xMSF);
        for (int i = 0; i < this.settings.cp_Filters.getSize(); ++i) {
            CGFilter cGFilter = (CGFilter)((Object)this.settings.cp_Filters.getElementAt(i));
            this.docAddDialog.addFilter(JavaTools.replaceSubString((String)cGFilter.cp_Name, (String)this.resources.prodName, (String)"%PRODNAME"), cGFilter.cp_Filter, i == 0);
        }
        return this.docAddDialog;
    }

    protected SystemDialog getZipDialog() {
        if (this.zipDialog == null) {
            this.zipDialog = SystemDialog.createStoreDialog((XMultiServiceFactory)this.xMSF);
            this.zipDialog.addFilter(this.resources.resZipFiles, "*.zip", true);
        }
        return this.zipDialog;
    }

    protected FTPDialog getFTPDialog(CGPublish cGPublish) {
        if (this.ftpDialog == null) {
            try {
                this.ftpDialog = new FTPDialog(this.xMSF, cGPublish);
                this.ftpDialog.createWindowPeer(this.xControl.getPeer());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.ftpDialog;
    }

    protected String showFolderDialog(String string, String string2, String string3) {
        if (this.folderDialog == null) {
            this.folderDialog = SystemDialog.createFolderDialog((XMultiServiceFactory)this.xMSF);
        }
        return this.folderDialog.callFolderDialog(string, string2, string3);
    }

    protected FileAccess getFileAccess() {
        if (this.fileAccess == null) {
            try {
                this.fileAccess = new FileAccess(this.xMSF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fileAccess;
    }

    protected CGDocument getDoc(short[] sArray) {
        if (sArray.length == 0) {
            return null;
        }
        if (this.settings.cp_DefaultSession.cp_Content.cp_Documents.getSize() <= sArray[0]) {
            return null;
        }
        return (CGDocument)((Object)this.settings.cp_DefaultSession.cp_Content.cp_Documents.getElementAt((int)sArray[0]));
    }

    protected int getDocsCount() {
        return this.settings.cp_DefaultSession.cp_Content.cp_Documents.getSize();
    }

    protected void fillExportList(Object[] objectArray) {
        ListModelBinder.fillList((Object)this.lstDocTargetType, (Object[])objectArray, null);
    }

    protected CGPublish getPublisher(String string) {
        return (CGPublish)((Object)this.settings.cp_DefaultSession.cp_Publishing.getElement((Object)string));
    }

    protected boolean isSaveSession() {
        return ((Number)Helper.getUnoPropertyValue((Object)WWD_General.getModel((Object)this.chkSaveSettings), (String)"State")).intValue() == 1;
    }

    protected String getSessionSaveName() {
        return (String)Helper.getUnoPropertyValue((Object)WWD_General.getModel((Object)this.cbSaveSettings), (String)"Text");
    }

    protected void checkSteps() {
        if (this.checkDocList()) {
            this.checkPublish();
        }
    }

    private void enableSteps(boolean bl) {
        if (!bl && !this.isStepEnabled(3)) {
            return;
        }
        for (int i = 3; i < 8; ++i) {
            this.setStepEnabled(i, bl, true);
        }
        if (!bl) {
            this.enableFinishButton(false);
        }
    }

    protected boolean checkDocList() {
        if (this.settings.cp_DefaultSession.cp_Content.cp_Documents.getSize() == 0) {
            this.enableSteps(false);
            return false;
        }
        this.enableSteps(true);
        return true;
    }

    public boolean checkSaveSession() {
        return !this.isSaveSession() || !this.getSessionSaveName().equals("");
    }

    private boolean checkPublish(String string, Object object, String string2) {
        CGPublish cGPublish = this.getPublisher(string);
        if (cGPublish.cp_Publish) {
            String string3 = (String)Helper.getUnoPropertyValue((Object)WWD_General.getModel((Object)object), (String)string2);
            if (string3 == null || string3.equals("")) {
                throw new IllegalArgumentException();
            }
            return true;
        }
        return false;
    }

    private boolean checkPublish_() {
        try {
            return this.checkPublish("local", this.txtLocalDir, "Text") | (!this.proxies && this.checkPublish("ftp", this.lblFTP, "Label")) | this.checkPublish("zip", this.txtZip, "Text") && this.checkSaveSession();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void checkPublish() {
        this.enableFinishButton(this.checkPublish_());
    }

    protected void unexpectedError(Exception exception) {
        exception.printStackTrace();
        XWindowPeer xWindowPeer = this.xControl.getPeer();
        AbstractErrorHandler.showMessage(this.xMSF, xWindowPeer, this.resources.resErrUnexpected, 1);
    }

    protected String substitute(String string) {
        try {
            return this.xStringSubstitution.substituteVariables(string, false);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

