/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XTextComponent;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.report.DBColumn;
import com.sun.star.wizards.report.RecordTable;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.TextTableHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.Vector;

class ReportDocument
extends TextDocument {
    private Object ReportPageStyle;
    private Object FirstPageStyle;
    private int PageWidth;
    private Rectangle PosSize;
    private String ReportFolderName;
    public Vector DBColumnsVector;
    private RecordTable CurRecordTable;
    public RecordParser CurDBMetaData;
    private String sMsgTableNotExisting;
    private String sMsgCommonReportError;
    private String ContentTemplatePath;
    private String LayoutTemplatePath;
    private String sMsgInvalidTextField;
    private String sMsgEndAutopilot;
    public boolean bIsCurLandscape;
    public TextTableHandler oTextTableHandler;
    public TextSectionHandler oTextSectionHandler;
    public FormHandler oFormHandler;
    public TextStyleHandler oTextStyleHandler;
    public TextFieldHandler oTextFieldHandler;
    public ViewHandler oViewHandler;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;

    public ReportDocument(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument, boolean bl, Resource resource) {
        super(xMultiServiceFactory, xTextDocument, bl);
        this.lateInit(resource);
    }

    public ReportDocument(XMultiServiceFactory xMultiServiceFactory, boolean bl, Resource resource) {
        super(xMultiServiceFactory, bl, false, null);
        this.lateInit(resource);
    }

    void lateInit(Resource resource) {
        this.oTextTableHandler = new TextTableHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextSectionHandler = new TextSectionHandler(this.xMSFDoc, this.xTextDocument);
        this.oFormHandler = new FormHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextStyleHandler = new TextStyleHandler(this.xMSFDoc, this.xTextDocument);
        this.oViewHandler = new ViewHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextFieldHandler = new TextFieldHandler(this.xMSFDoc, this.xTextDocument);
        this.DBColumnsVector = new Vector();
        this.CurDBMetaData = new RecordParser(this.xMSF, this.CharLocale, this.oTextTableHandler.NumberFormats);
        long l = Desktop.getNullDateCorrection((XNumberFormatsSupplier)this.xNumberFormatsSupplier);
        this.CurDBMetaData.setNullDateCorrection(l);
        this.sMsgInvalidTextField = resource.getResText(2473);
        this.sMsgTableNotExisting = resource.getResText(2461);
        this.sMsgCommonReportError = resource.getResText(2472);
        this.sMsgCommonReportError = JavaTools.replaceSubString((String)this.sMsgCommonReportError, (String)String.valueOf('\r'), (String)"<BR>");
        this.sMsgEndAutopilot = resource.getResText(1033);
        this.sMsgTableNotExisting = this.sMsgTableNotExisting + '\r' + this.sMsgEndAutopilot;
        this.bIsCurLandscape = true;
        this.getReportPageStyles();
    }

    public boolean checkReportLayoutMode(String[] stringArray) {
        try {
            XNameAccess xNameAccess = this.oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            Object object = stringArray.length > 0 ? xNameAccess.getByName("GroupField1") : xNameAccess.getByName("RecordSection");
            boolean bl = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue((Object)object, (String)"IsVisible"));
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return true;
        }
    }

    public void swapContentTemplate(String string) {
        this.xProgressBar.start("", 10);
        this.ContentTemplatePath = string;
        this.loadSectionsfromTemplate(string);
        this.xProgressBar.setValue(40);
        this.oTextStyleHandler.loadStyleTemplates(string, "LoadTextStyles");
        this.xProgressBar.setValue(70);
        if (this.CurRecordTable != null) {
            this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
        }
        this.xProgressBar.setValue(100);
        this.oViewHandler.selectFirstPage(this.oTextTableHandler);
        this.xProgressBar.end();
    }

    public void swapLayoutTemplate(String string, String string2) {
        try {
            this.xProgressBar.start("", 10);
            this.LayoutTemplatePath = string;
            boolean bl = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue((Object)this.ReportPageStyle, (String)"IsLandscape"));
            this.oTextStyleHandler.loadStyleTemplates(string, "LoadPageStyles");
            this.xProgressBar.setValue(60);
            this.changePageOrientation(string2, bl);
            this.xProgressBar.setValue(100);
            this.oViewHandler.selectFirstPage(this.oTextTableHandler);
            this.xProgressBar.end();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void createReportForm(String string) {
        XNameContainer xNameContainer = this.oFormHandler.insertFormbyName(string);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = ReportDocument.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xNameContainer);
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "DataSourceName", this.CurDBMetaData.DataSourceName);
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "Command", this.CurDBMetaData.Command);
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "CommandType", new String(Integer.toString(this.CurDBMetaData.getCommandType())));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "GroupFieldNames", JavaTools.ArraytoString((String[])this.CurDBMetaData.GroupFieldNames));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "FieldNames", JavaTools.ArraytoString((String[])this.CurDBMetaData.FieldNames));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "RecordFieldNames", JavaTools.ArraytoString((String[])this.CurDBMetaData.RecordFieldNames));
    }

    public void updateReportTitle(XTextComponent xTextComponent) {
        String string = xTextComponent.getText();
        Helper.setUnoPropertyValue((Object)this.xDocInfo, (String)"Title", (Object)string);
    }

    public void getReportPageStyles() {
        try {
            Object object = this.oTextStyleHandler.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            this.ReportPageStyle = Helper.getUnoObjectbyName((Object)object, (String)"Standard");
            this.FirstPageStyle = Helper.getUnoObjectbyName((Object)object, (String)"First Page");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void changePageOrientation(String string, boolean bl) {
        try {
            this.getReportPageStyles();
            Size size = (Size)Helper.getUnoStructValue((Object)this.ReportPageStyle, (String)"Size");
            this.bIsCurLandscape = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue((Object)this.ReportPageStyle, (String)"IsLandscape"));
            if (this.bIsCurLandscape != bl) {
                Size size2 = new Size(size.Height, size.Width);
                Helper.setUnoPropertyValue((Object)this.ReportPageStyle, (String)"IsLandscape", (Object)new Boolean(bl));
                Helper.setUnoPropertyValue((Object)this.ReportPageStyle, (String)"Size", (Object)size2);
                Helper.setUnoPropertyValue((Object)this.FirstPageStyle, (String)"IsLandscape", (Object)new Boolean(bl));
                Helper.setUnoPropertyValue((Object)this.FirstPageStyle, (String)"Size", (Object)size2);
                int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue((Object)this.ReportPageStyle, (String)"LeftMargin"));
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue((Object)this.ReportPageStyle, (String)"RightMargin"));
                this.PageWidth = size2.Width - n - n2;
                if (this.CurRecordTable != null) {
                    this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public boolean loadSectionsfromTemplate(String string) {
        try {
            int n;
            int n2 = this.CurDBMetaData.GroupFieldNames.length;
            this.CurRecordTable = null;
            for (n = 0; n < n2; ++n) {
                String string2 = "GroupField" + Integer.toString(n + 1);
                this.oTextTableHandler.renameTextTable("Tbl_" + string2, "MyTextTable");
                this.oTextSectionHandler.linkSectiontoTemplate(string, string2);
                this.oTextTableHandler.renameTextTable("MyTextTable", "Tbl_" + string2);
            }
            if (this.oTextSectionHandler.xTextSectionsSupplier.getTextSections().getElementNames().length > this.CurDBMetaData.GroupFieldNames.length) {
                this.oTextSectionHandler.linkSectiontoTemplate(string, "RecordSection");
                this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                this.insertColumnstoRecordTable();
            }
            for (n = 0; n < n2; ++n) {
                DBColumn dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[n], n, "Tbl_GroupField" + (n + 1));
                if (dBColumn == null) {
                    return false;
                }
                dBColumn.formatValueCell();
                this.DBColumnsVector.set(n, dBColumn);
                this.replaceFieldValueInGroupTable(dBColumn, n);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public void setupRecordSection(String string) {
        this.ContentTemplatePath = string;
        if (this.CurDBMetaData.RecordFieldNames.length > 0) {
            this.oTextSectionHandler.insertTextSection("RecordSection", string);
            this.CurRecordTable = new RecordTable(this.oTextTableHandler);
            this.insertColumnstoRecordTable();
            if (this.CurRecordTable != null) {
                this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
            }
        } else {
            this.CurRecordTable = null;
        }
    }

    public void refreshGroupFields(String[] stringArray) {
        for (int i = 0; i < this.DBColumnsVector.size(); ++i) {
            DBColumn dBColumn = (DBColumn)this.DBColumnsVector.elementAt(i);
            if (dBColumn.CurDBField.FieldName.equals(stringArray[i])) continue;
            dBColumn.setDBField(stringArray[i]);
            dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public boolean isGroupField(String string) {
        return JavaTools.FieldInList((String[])this.CurDBMetaData.GroupFieldNames, (String)string) != -1;
    }

    public void replaceFieldValueInRecordSection(int n) {
        int n2 = this.CurDBMetaData.GroupFieldNames.length;
        int n3 = this.CurDBMetaData.FieldNames.length;
        for (int i = n2; i < n3; ++i) {
            ((DBColumn)this.DBColumnsVector.elementAt(i)).insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void updateTextSections(String[] stringArray) throws Exception {
        XNameAccess xNameAccess = this.oTextTableHandler.xTextTablesSupplier.getTextTables();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = "Tbl_GroupField" + Integer.toString(i + 1);
            DBColumn dBColumn = (DBColumn)this.DBColumnsVector.get(i);
            DBColumn dBColumn2 = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, stringArray[i], i, string, dBColumn);
            dBColumn2.formatValueCell();
            this.DBColumnsVector.setElementAt(dBColumn2, i);
            dBColumn2.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void replaceFieldValueInGroupTable(DBColumn dBColumn, int n) {
        String string = "Tbl_GroupField" + (n + 1);
        String string2 = dBColumn.xTableName.getName();
        if (string2.compareTo(string) != 0) {
            dBColumn.xTableName.setName(string);
        }
        dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        dBColumn.setCellFont();
    }

    public void replaceFieldValueInRecordTable() {
        String string = "Tbl_RecordSection";
        String string2 = this.CurRecordTable.xTableName.getName();
        if (string2.compareTo(string) != 0) {
            this.CurRecordTable.xTableName.setName(string);
        }
        int n = this.CurDBMetaData.GroupFieldNames.length;
        int n2 = this.CurDBMetaData.RecordFieldNames.length;
        for (int i = n; i < n2; ++i) {
            ((DBColumn)this.DBColumnsVector.elementAt(i)).insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void insertColumnstoRecordTable() {
        try {
            int n;
            int n2;
            XTableColumns xTableColumns;
            int n3;
            int n4 = this.CurDBMetaData.GroupFieldNames.length;
            String string = this.CurRecordTable.xTableName.getName();
            if (string.compareTo("Tbl_RecordSection") != 0) {
                this.CurRecordTable = new RecordTable(this.oTextTableHandler);
            }
            if ((n3 = (xTableColumns = this.CurRecordTable.xTextTable.getColumns()).getCount()) > (n2 = this.CurDBMetaData.RecordFieldNames.length)) {
                n = n3 - n2;
                xTableColumns.removeByIndex(0, n);
            } else if (n3 < n2) {
                n = n2 - n3;
                this.CurRecordTable.xTextTable.getColumns().insertByIndex(n3, n);
            }
            for (n = 0; n < n2; ++n) {
                DBColumn dBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, n);
                dBColumn.initializeNumberFormat();
                dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
                if (this.DBColumnsVector.size() <= n + n4) {
                    this.DBColumnsVector.add(dBColumn);
                    continue;
                }
                this.DBColumnsVector.set(n + n4, dBColumn);
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public boolean addGroupNametoDocument(String[] stringArray, String string, Vector vector, String string2, int n) {
        DBColumn dBColumn = null;
        try {
            int n2 = vector.size();
            if (n2 < 4) {
                this.removeGroupNamesofRecordTable(n);
                String string3 = this.CurDBMetaData.getFieldName(string);
                vector.addElement(string3);
                this.oTextSectionHandler.insertTextSection("GroupField" + ++n2, string2 + "/cnt-default.stw");
                dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, string3, n2 - 1, "Tbl_GroupField" + n2);
                dBColumn.formatValueCell();
                if (dBColumn != null) {
                    this.DBColumnsVector.addElement(dBColumn);
                    this.replaceFieldValueInGroupTable(dBColumn, n2 - 1);
                } else {
                    String string4 = JavaTools.replaceSubString((String)this.sMsgTableNotExisting, (String)("Tbl_GroupField" + n2), (String)"<TABLENAME>");
                    this.CurDBMetaData.showMessageBox("ErrorBox", 0x400000, string4);
                }
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
        return dBColumn != null;
    }

    public void removeGroupName(String[] stringArray, String string, Vector vector) {
        try {
            this.removeGroupNamesofRecordTable(stringArray.length + 1);
            String string2 = this.CurDBMetaData.getFieldName(string);
            vector.removeElement(string2);
            this.oTextSectionHandler.removeLastTextSection();
            this.oTextTableHandler.removeLastTextTable();
            if (JavaTools.FieldInList((String[])stringArray, (String)string) == -1) {
                this.updateTextSections(stringArray);
            }
            int n = stringArray.length;
            this.DBColumnsVector.remove(n);
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public void removeGroupNamesofRecordTable(int n) {
        int n2 = this.DBColumnsVector.size();
        if (n2 > n) {
            for (int i = n2 - 1; i >= n; --i) {
                this.DBColumnsVector.removeElementAt(i);
            }
        }
    }

    public void showCommonReportErrorBox(Exception exception) {
        String string = JavaTools.convertfromURLNotation((String)this.ContentTemplatePath);
        String string2 = JavaTools.replaceSubString((String)this.sMsgCommonReportError, (String)string, (String)"%PATH");
        this.CurDBMetaData.showMessageBox("ErrorBox", 0x400000, string2);
        exception.printStackTrace(System.out);
    }

    public void getallDBColumns() {
        try {
            int n = this.CurDBMetaData.GroupFieldNames.length;
            int n2 = this.CurDBMetaData.FieldNames.length;
            for (int i = 0; i < n2; ++i) {
                DBColumn dBColumn;
                if (i < n) {
                    dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[i], i, "Tbl_GroupField" + (i + 1));
                } else {
                    if (this.CurRecordTable == null) {
                        this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                    }
                    dBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, i - n);
                    dBColumn.initializeNumberFormat();
                }
                if (dBColumn != null) {
                    this.DBColumnsVector.addElement(dBColumn);
                    continue;
                }
                String string = JavaTools.replaceSubString((String)this.sMsgTableNotExisting, (String)("Tbl_GroupField" + n), (String)"<TABLENAME>");
                this.CurDBMetaData.showMessageBox("ErrorBox", 0x400000, string);
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

