/*
 * 作成日: 2005/01/19
 */
package jp.co.kayo.io;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import java.nio.ByteBuffer;

import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.Date;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

import jp.co.kayo.action.Action;
import jp.co.kayo.action.Chat;


/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: W3GReader.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class W3GReader {
    /** TODO 説明を定義してください。 */
    private ReplayRecord m_replay;

    /** TODO 説明を定義してください。 */
    private ReplayBuffer m_replayfile;

    /** TODO 説明を定義してください。 */
    private ReplayHeader m_header;
    
    public W3GReader(String filename, boolean needaction) throws Exception {
        
        m_replayfile = new ReplayBuffer(filename);

        m_header = new ReplayHeader(m_replayfile);

        byte[] packdata = zunpack_data(m_replayfile, m_header.m_blocks);

        ReplayBuffer decompressed = new ReplayBuffer(ByteBuffer.wrap(packdata,
                    4, packdata.length - 4));

        m_replay = new ReplayRecord(decompressed, needaction);
    }
    
    public int getHashCode() throws Exception {
        StringBuffer buf = new StringBuffer();
        for (Iterator ite = m_replay.getPlayermap().values().iterator(); ite.hasNext();) {
            PlayerRecord player = (PlayerRecord) ite.next();
            buf.append(player.getName());
        }
        buf.append(m_header.getGameTime());
        buf.append(m_header.getBuild());
        buf.append(m_replay.getCreator());
        
        return buf.hashCode();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public ReplayHeader getHeader() {
        return this.m_header;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public ReplayRecord getReplay() {
        return this.m_replay;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     *
     * @throws Exception TODO 説明を定義してください。
     */
    public Document getXML() throws Exception {
        StringBuffer xml = new StringBuffer()
        .append("<Replay>");
        //基本情報
        xml
            .append("<Basic>")
                .append("<FileSize>").append( m_replayfile.getFilesize() ).append("</FileSize>")
                .append("<TimeStamp msec='").append(m_replayfile.getTimestamp()).append("' >").append(getFormatTime(m_replayfile.getTimestamp())).append("</TimeStamp>")
                .append("<Version>").append( m_header.getMajorVer() ).append("</Version>")
                .append("<Build>").append( m_header.getBuild() ).append("</Build>")
                .append("<ReplayLength msec='").append(m_header.getGameTime()).append("' >").append(getFormatTime(m_header.getGameTime())).append("</ReplayLength>")
                .append("<Map img='").append( m_replay.getMapImage()).append("' >").append( m_replay.getMapname() ).append("</Map>")
                .append("<Type>").append( m_replay.getType() ).append("</Type>")
                .append("<Creator>").append( m_replay.getCreator() ).append("</Creator>")
                .append("<StartSpot>").append( m_replay.getGamestartrecord().getStartspotcount() ).append("</StartSpot>")
            .append("</Basic>");

        //プレイヤー情報
        xml
            .append("<PlayerList>");
        for (Iterator ite = m_replay.getPlayermap().values().iterator(); ite.hasNext();) {
                PlayerRecord player = (PlayerRecord) ite.next();
                xml
                .append("<Player>")
                    .append("<ID>").append(player.getId()).append("</ID>")
                    .append("<Color>").append(player.getColor()).append("</Color>")
                    .append("<Name>").append(player.getName()).append("</Name>")
                    .append("<Controller>").append(player.getController()).append("</Controller>")
                    .append("<Race>").append(player.getRace()).append("</Race>")
                    .append("<Team>").append(player.getTeam()).append("</Team>")
                    .append("<Handicap>").append(player.getHandicap()).append("</Handicap>")
                    .append("<Actions>").append(player.getActioncount()).append("</Actions>")
                    .append("<APM>").append(player.getAPM()).append("</APM>")
                    .append("<TimePlayed msec='").append(player.getGametime()).append("' >").append(getFormatTime(player.getGametime())).append("</TimePlayed>")
                    .append("<TimeLogin msec='").append(player.getPlaytime()).append("' >").append(getFormatTime(player.getPlaytime())).append("</TimeLogin>");
                    //Hero
                    xml.append("<HeroOrder>");
                    for(Iterator heros=player.getHeros(); heros.hasNext(); ){
                        String hero = (String)heros.next();
                        xml.append("<Hero>").append(hero).append("</Hero>");
                    }
                    xml.append("</HeroOrder>");
                    //end
                    //Hero
                    xml.append("<HeroSkillOrder>");
                    for(Iterator heros=player.getHeroskills(); heros.hasNext(); ){
                        String skill = (String)heros.next();
                        xml.append("<Skill>").append(skill).append("</Skill>");
                    }
                    xml.append("</HeroSkillOrder>");
                    //end
                xml
                .append("</Player>");
        }
        xml
            .append("</PlayerList>");
        
        //チャット情報
        xml
        .append("<Chat>");
        for (Iterator ite = m_replay.getChats().iterator(); ite.hasNext();) {
            Chat chat = (Chat) ite.next();
            xml.append(chat.toXML());
        }
        xml
        .append("</Chat>");
        
        /*
        //APMに関連するアクション情報
        xml
        .append("<APMAction>");
        for (Iterator ite = m_replay.getActoins().iterator(); ite.hasNext();) {
            Action action = (Action)ite.next();
            if(action.availableAPM()){
                Player player = (Player) m_replay.getPlayer(action.getId());
                if(player!=null){
                    xml
                    .append("<Action>")
                        .append("<Player>").append(player.getName()).append("</Player>")
                        .append("<Time msec='").append(action.getTime()).append("' >").append(getFormatTime(action.getTime())).append("</Time>")
                        .append(action.toXML())
                    .append("</Action>");
                }
                else{
                    xml
                    .append("<NonPlayerData>")
                        .append("<AID>").append(action.getActionid()).append("</AID>")
                        .append("<PID>").append(action.getId()).append("</PID>")
                    .append("</NonPlayerData>");
                }
            }
        }
        xml
        .append("</APMAction>");
        */
        xml
        .append("</Replay>");

        return XMLUtil.parse(xml.toString()/*, false, false*/);
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param msec TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    private String getFormatTime(long msec) {
        DateFormat df = null;
        if(msec>86400000){
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        else if(msec>3600000){
            df = new SimpleDateFormat("HH:mm:ss");
        }
        else{
            df = new SimpleDateFormat("mm:ss");
        }
        return df.format(new Date(msec));
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param replay TODO 説明を定義してください。
     * @param blocknum TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    private byte[] zunpack_data(ReplayBuffer replay, long blocknum) {
        byte[] data = null;

        for (int i = 0; i < blocknum; i++) {
            ReplayBlockHeader h = new ReplayBlockHeader(replay);

            byte[] tempdata = new byte[h.size];
            replay.get(tempdata, 0, h.size);

            int pos = 0;

            if (data == null) {
                data = new byte[h.uncomp_size];
            } else {
                pos = data.length;

                byte[] tmp = null;
                tmp = new byte[data.length + h.uncomp_size];
                System.arraycopy(data, 0, tmp, 0, data.length);
                data = tmp;
            }

            Inflater inflater = new Inflater();

            inflater.setInput(tempdata);

            try {
                inflater.inflate(data, pos, h.uncomp_size);
            } catch (DataFormatException e) {
                e.printStackTrace();
            }

            inflater.end();
        }

        return (data == null) ? new byte[0] : data;
    }
    public ReplayBuffer getReplayfile() {
        return this.m_replayfile;
    }
}