/*
 * 作成日: 2005/01/24
 */
package jp.co.kayo.io;

import jp.co.kayo.action.Action;
import jp.co.kayo.action.ActionFactory;

import java.nio.ByteBuffer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;


/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: ReplayRecord.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class ReplayRecord {
    /** TODO 説明を定義してください。 */
    public static final int MAX_MAP = 200;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_hideterrain = 0x0001;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fullshare = 0x0002;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_speedfast = 0x0004;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_mapexplored = 0x0008;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_alwaysvisible = 0x0010;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_defaultvisible = 0x0020;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fullobserver = 0x0040;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_observerondefeat = 0x0080;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_teamtogether = 0x0100;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fixedteams = 0x0200;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_randomhero = 0x0400;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_randomraces = 0x0800;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_referee = 0x1000;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fixedally = 0x2000;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fixedplayerprop = 0x4000;

    /** TODO 説明を定義してください。 */
    public static final int gameflag_fixracetorandom = 0x8000;

    /** TODO 説明を定義してください。 */
    public long totaltime = 0;

    /** TODO 説明を定義してください。 */
    private GameStartRecord m_gamestartrecord;

    /** TODO 説明を定義してください。 */
    private Map m_playermap = new TreeMap();

    /** TODO 説明を定義してください。 */
    private String m_creator;

    /** TODO 説明を定義してください。 */
    private String m_gamename;

    /** TODO 説明を定義してください。 */
    private String m_mapname;

    /** TODO 説明を定義してください。 */
    private Vector m_actoins = new Vector();

    /** TODO 説明を定義してください。 */
    private Vector m_chats = new Vector();

    /** TODO 説明を定義してください。 */
    private int m_gameflag;

    /** TODO 説明を定義してください。 */
    private int m_gametype;

    /** TODO 説明を定義してください。 */
    private int m_player_slots;

    /** TODO 説明を定義してください。 */
    private int m_privateFlag;

    /**
     * Creates a new Replay object.
     *
     * @param buf TODO 説明を定義してください。
     */
    public ReplayRecord(ReplayBuffer buf, boolean needaction) {
        //[PlayerRecord]
        readPlayerRecord(buf);

        //[GameName]
        readGameName(buf);

        //[MapSettings]
        readMapSettings(buf);

        //[MapRecord]
        buf.skip(11);

        //[Map&CreatorName]
        readMapAndCreatorName(buf);

        //?
        buf.skip(2);

        //[PlayerCount]
        readPlayerCount(buf);

        //[GameType]
        readGameType(buf);

        //[PlayerList]
        readPlayerList(buf);

        //[GameStartRecord]
        m_gamestartrecord = new GameStartRecord(this, buf);

        //[ReplayData]
        boolean loop = needaction;

        while (loop) {
            byte cmd = buf.get();

            switch (cmd) {
            case 0x17: {
                Action action = ActionFactory.get(0x17 | 0x80);
                action.parse(buf);
                action.setTime(totaltime);

                m_actoins.add(action);

                PlayerRecord rec = (PlayerRecord) m_playermap.get(new Integer(
                            action.getId()));

                if (rec != null) {
                    rec.addAction(action);
                }
            }

            break;

            case 0x1A: {
                int n = buf.getInt();
            }

            break;

            case 0x1B: {
                int n = buf.getInt();
            }

            break;

            case 0x1C: {
                int n = buf.getInt();
            }

            break;

            case 0x1E:
            case 0x1F: {
                int n = buf.getShort();
                byte[] actiondata = buf.get(new byte[n]);
                ReplayBuffer actionfile = new ReplayBuffer(ByteBuffer.wrap(
                            actiondata, 0, actiondata.length));

                readActionData(n, actionfile);
            }

            break;

            case 0x20: {
                Action action = ActionFactory.get(0x20 | 0x80);
                action.parse(buf);
                action.setTime(totaltime);

                m_actoins.add(action);
                m_chats.add(action);

                PlayerRecord rec = (PlayerRecord) m_playermap.get(new Integer(
                            action.getId()));

                if (rec != null) {
                    rec.addAction(action);
                }
            }

            break;

            case 0x22: {
                byte b = buf.get();
                int r = buf.getInt();
            }

            break;

            case 0x23: {
                int a = buf.getInt();
                byte b = buf.get();
                int c = buf.getInt();
                byte d = buf.get();
            }

            break;

            case 0x2F: {
                int mode = buf.getInt();
                int ctime = buf.getInt();
            }

            break;

            case 0x0:
                loop = false;

                break;
            }
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public Vector getActoins() {
        return this.m_actoins;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public Vector getChats() {
        return this.m_chats;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getCreator() {
        return this.m_creator;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getGameflag() {
        return this.m_gameflag;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getGamename() {
        return this.m_gamename;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public GameStartRecord getGamestartrecord() {
        return this.m_gamestartrecord;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getGametype() {
        return this.m_gametype;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getMapname() {
        return this.m_mapname;
    }

    public String getMapImage() {
        //sample
        //Maps\FrozenThrone\(6)HavenOfTheDamned.w3x
        String filename = m_mapname;
        if (filename != null) {
            int i = filename.lastIndexOf('\\');
            if (i > 0 && i < filename.length() - 1) {
                filename = filename.substring(i + 1);
                //(6)HavenOfTheDamned.w3x
                i = filename.lastIndexOf(')');
                if (i > 0 && i < filename.length() - 1) {
                    filename = filename.substring(i + 1);
                }
                //HavenOfTheDamned.w3x
                i = filename.lastIndexOf('.');
                if (i > 0 && i < filename.length() - 1) {
                    String imgname = filename.substring(0, i) + ".jpg";
                    
                    return imgname;
                }
            }
        }
        
        return "notfound";
    }
    
    /**
     * TODO 説明を定義してください。
     *
     * @param id TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public PlayerRecord getPlayer(int id) {
        return (PlayerRecord) m_playermap.get(new Integer(id));
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getPlayer_slots() {
        return this.m_player_slots;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public Map getPlayermap() {
        return m_playermap;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getTotaltime() {
        return this.totaltime;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getType() {
        StringBuffer ret = new StringBuffer();
        Map map = new HashMap();

        for (Iterator ite = m_playermap.values().iterator(); ite.hasNext();) {
            PlayerRecord player = (PlayerRecord) ite.next();
            int team = player.getTeam();

            if (player.getController().equals("Player") ||
                    player.getController().equals("Computer")) {
                Integer count = (Integer) map.get(new Integer(team));

                if (count == null) {
                    count = new Integer(1);
                } else {
                    count = new Integer(count.intValue() + 1);
                }

                map.put(new Integer(team), count);
            }
        }

        for (Iterator ite = map.values().iterator(); ite.hasNext();) {
            Integer count = (Integer) ite.next();
            ret.append(count.toString());

            if (ite.hasNext()) {
                ret.append("v");
            }
        }

        return ret.toString();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param n TODO 説明を定義してください。
     * @param buf TODO 説明を定義してください。
     */
    void readActionData(int n, ReplayBuffer buf) {
        int time = buf.getShort();
        totaltime += time;

        //ゲーム時間の更新
        for (Iterator ite = m_playermap.values().iterator(); ite.hasNext();) {
            PlayerRecord player = (PlayerRecord) ite.next();
            player.setGametime(totaltime);
        }

        if (n > 2) {
            int bsize = n;

            do {
                int playerid = buf.get();
                int actionblocklength = buf.getShort();

                PlayerRecord rec = (PlayerRecord) m_playermap.get(new Integer(
                            playerid));

                if (actionblocklength > 0) {
                    int actionid = buf.get();
                    byte[] actionbuf = new byte[actionblocklength - 1];
                    buf.get(actionbuf);

                    ReplayBuffer acbuf = new ReplayBuffer(ByteBuffer.wrap(
                                actionbuf, 0, actionbuf.length));
                    Action action = ActionFactory.get(actionid);

                    if (action != null) {
                        action.setTime(totaltime);
                        action.setId(playerid);
                        m_actoins.add(action);
                        action.parse(acbuf);

                        if (rec != null) {
                            rec.addAction(action);
                        }
                    } else {
                        System.out.println(Integer.toHexString(actionid)
                                                  .toUpperCase() + " uknown");
                    }
                }

                bsize -= (actionblocklength + 4);
            } while (bsize > 3);
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    void readGameType(ReplayBuffer buf) {
        //      0x0000 |  1 byte   | Game Type:
        //             |           | (0x00 = unknown, just in a few  pre 1.03 custom games)
        //             |           |  0x01 =   Ladder -> 1on1 or FFA
        //                                     Custom -> Scenario  (not 100% sure about this)
        //             |           |  0x09 = Custom game
        //             |           |  0x1D = Single player game
        //             |           |  0x20 = Ladder Team game (AT or RT, 2on2/3on3/4on4)
        m_gametype = buf.get();

        //      0x0001 |  1 byte   | PrivateFlag for custom games:
        //             |           |  0x00 - if it is a public LAN/Battle.net game
        //             |           |  0x08 - if it is a private Battle.net game
        m_privateFlag = buf.get();

        //      0x0002 |  1 word   | unknown (always 0x0000 so far)        
        buf.skip(2);

        //        LanguageID
        buf.skip(4);
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    void readMapAndCreatorName(ReplayBuffer buf) {
        int i;
        int j;
        int trans_bit;
        byte[] tmp_buf = new byte[MAX_MAP];
        int first = 0;

        if (buf == null) {
            return;
        }

        tmp_buf[MAX_MAP - 1] = 0;

        trans_bit = 0xff;

        for (i = 0, j = 0; j < (MAX_MAP - 1); i++) {
            byte b = buf.get();
            int bit;

            if ((i % 8) == 1) {
                trans_bit = b;

                continue;
            }

            tmp_buf[j] = b;
            bit = (((i + 8) - 1) % 8);

            if (((0x1 << bit) & trans_bit) == 0) {
                tmp_buf[j]--;
            }

            if (tmp_buf[j] == '\0') {
                if (first != 0) {
                    break;
                }

                first = j;
            }

            j++;
        }

        m_mapname = new String(tmp_buf, 0, first);
        m_creator = new PString(tmp_buf, first + 1, j).toString();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    void readPlayerCount(ReplayBuffer buf) {
        m_player_slots = buf.getInt();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    void readPlayerList(ReplayBuffer buf) {
        for (int i = 1; i < m_player_slots; i++) {
            PlayerRecord player;

            try {
                player = new PlayerRecord(i + 1, buf);
                m_playermap.put(new Integer(player.getId()), player);
            } catch (Exception e) {
            }
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    private void readGameName(ReplayBuffer buf) {
        m_gamename = new String(buf.readToken());
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    private void readMapSettings(ReplayBuffer buf) {
        m_gameflag = 0;

        byte flg = buf.get();

        if ((flg & 0x4) != 0) {
            m_gameflag &= gameflag_hideterrain;
        }

        if ((flg & 0x10) != 0) {
            m_gameflag &= gameflag_fullshare;
        }

        //読み飛ばし
        buf.skip();

        if ((flg & 0x2) != 0) {
            m_gameflag &= gameflag_speedfast;
        }

        //読み飛ばし
        buf.skip();

        if ((flg & 0x2) != 0) {
            m_gameflag &= gameflag_mapexplored;
        }

        if ((flg & 0x4) != 0) {
            m_gameflag &= gameflag_alwaysvisible;
        }

        if ((flg & 0x8) != 0) {
            m_gameflag &= gameflag_defaultvisible;
        }

        if ((flg & 0x10) != 0) {
            m_gameflag &= gameflag_fullobserver;
        }

        if ((flg & 0x20) != 0) {
            m_gameflag &= gameflag_observerondefeat;
        }

        if ((flg & 0x40) != 0) {
            m_gameflag &= gameflag_teamtogether;
        }

        //読み飛ばし
        buf.skip();

        if ((flg & 0x2) != 0) {
            m_gameflag &= gameflag_fixedteams;
        }

        //読み飛ばし
        buf.skip();

        if ((flg & 0x2) != 0) {
            m_gameflag &= gameflag_randomhero;
        }

        if ((flg & 0x4) != 0) {
            m_gameflag &= gameflag_randomraces;
        }

        if ((flg & 0x40) != 0) {
            m_gameflag &= gameflag_referee;
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param buf TODO 説明を定義してください。
     */
    private void readPlayerRecord(ReplayBuffer buf) {
        PlayerRecord player;

        try {
            player = new PlayerRecord(buf);
            m_playermap.put(new Integer(player.getId()), player);
        } catch (Exception e) {
        }
    }
}