package jp.co.kayo.io;

/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: ReplayHeader.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class ReplayHeader {
    /** TODO 説明を定義してください。 */
    ReplaySubHeader sub;

    /** TODO 説明を定義してください。 */
    byte[] header = new byte[28];

    /** TODO 説明を定義してください。 */
    long m_blocks;

    /** TODO 説明を定義してください。 */
    long m_header_ver;

    /** TODO 説明を定義してください。 */
    long m_offset;

    /** TODO 説明を定義してください。 */
    long m_size;

    /** TODO 説明を定義してください。 */
    long m_uncomp_size;

    /**
     * Creates a new ReplayHeader object.
     *
     * @param replay TODO 説明を定義してください。
     */
    ReplayHeader(ReplayBuffer replay) {
        replay.get(header, 0, 28);
        m_offset = replay.getInt();
        m_size = replay.getInt();
        m_header_ver = replay.getInt();
        m_uncomp_size = replay.getInt();
        m_blocks = replay.getInt();

        if (m_header_ver == 0) {
            sub = new ReplaySubHeaderVer0(replay);
        } else {
            sub = new ReplaySubHeaderVer1(replay);
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getBuild() {
        return sub.getBuild();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getGameTime() {
        return sub.getGameTime();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getHeader() {
        return new String(header, 0, 26);
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getMajorVer() {
        return "1." + sub.getMajorVer();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @author MasafumiTerazono
     * @version $Id: ReplayHeader.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
     */
    private static interface ReplaySubHeader {
        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getBuild();

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public long getGameTime();

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getMajorVer();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @author MasafumiTerazono
     * @version $Id: ReplayHeader.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
     */
    private static class ReplaySubHeaderVer0 implements ReplaySubHeader {
        /** TODO 説明を定義してください。 */
        int build;

        /** TODO 説明を定義してください。 */
        int flags; // 0x8000 in LAN/multi, 0x0000 in single

        /** TODO 説明を定義してください。 */
        int major_ver; // For patch 1.xx

        /** TODO 説明を定義してください。 */
        int minor_ver; // 0 so far

        /** TODO 説明を定義してください。 */
        long checksum; // CRC32 checksum of header

        /** TODO 説明を定義してください。 */
        long length_ms;

        /**
         * Creates a new ReplaySubHeaderVer0 object.
         *
         * @param replay TODO 説明を定義してください。
         */
        ReplaySubHeaderVer0(ReplayBuffer replay) {
            minor_ver = replay.getShort();
            major_ver = replay.getShort();
            build = replay.getShort();
            flags = replay.getShort();
            length_ms = replay.getInt();
            checksum = replay.getInt();
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getBuild() {
            return build;
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public long getGameTime() {
            return length_ms;
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getMajorVer() {
            return major_ver;
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @author MasafumiTerazono
     * @version $Id: ReplayHeader.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
     */
    private static class ReplaySubHeaderVer1 implements ReplaySubHeader {
        /** TODO 説明を定義してください。 */
        int build;

        /** TODO 説明を定義してください。 */
        int flags; // 0x8000 in LAN/multi, 0x0000 in single

        /** TODO 説明を定義してください。 */
        int major_ver; // For patch 1.xx

        /** TODO 説明を定義してください。 */
        int ver_str; // WAR3 or W3XP for normal vs. expansion

        /** TODO 説明を定義してください。 */
        long checksum; // CRC32 checksum of header

        /** TODO 説明を定義してください。 */
        long length_ms;

        /**
         * Creates a new ReplaySubHeaderVer1 object.
         *
         * @param replay TODO 説明を定義してください。
         */
        ReplaySubHeaderVer1(ReplayBuffer replay) {
            ver_str = replay.getInt();
            major_ver = replay.getInt();
            build = replay.getShort();
            flags = replay.getShort();
            length_ms = replay.getInt();
            checksum = replay.getInt();
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getBuild() {
            return build;
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public long getGameTime() {
            return length_ms;
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        public int getMajorVer() {
            return major_ver;
        }

        /**
         * TODO 説明を定義してください。
         *
         * @return TODO 説明を定義してください。
         */
        String getVerstr() {
            String hex = Long.toHexString(ver_str);
            byte[] b = new byte[4];
            b[0] = Byte.parseByte(hex.substring(0, 2), 16);
            b[1] = Byte.parseByte(hex.substring(2, 4), 16);
            b[2] = Byte.parseByte(hex.substring(4, 6), 16);
            b[3] = Byte.parseByte(hex.substring(6, 8), 16);

            return new String(b);
        }
    }
}