package jp.co.kayo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;


/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: ReplayBuffer.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class ReplayBuffer {
    /** TODO 説明を定義してください。 */
    private ByteBuffer m_buf;

    /** TODO 説明を定義してください。 */
    private final int MAX_TMP_SIZE = 256;

    /** TODO 説明を定義してください。 */
    private long m_filesize;

    /** TODO 説明を定義してください。 */
    private long m_timestamp;

    /**
     * Creates a new ReplayBuffer object.
     *
     * @param buf TODO 説明を定義してください。
     */
    public ReplayBuffer(ByteBuffer buf) {
        m_buf = buf;
        m_filesize = m_buf.capacity();
    }

    /**
     * Creates a new ReplayBuffer object.
     *
     * @param filename TODO 説明を定義してください。
     *
     * @throws IOException TODO 説明を定義してください。
     */
    public ReplayBuffer(String filename) throws IOException {
        File file = new File(filename);
        m_timestamp = file.lastModified();

        FileInputStream fis = new FileInputStream(filename);
        FileChannel channel = fis.getChannel();
        m_filesize = (int) channel.size();
        m_buf = channel.map(FileChannel.MapMode.READ_ONLY, 0, m_filesize);
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getFilesize() {
        return this.m_filesize;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getInt() {
        return m_buf.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public short getShort() {
        return m_buf.order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getTimestamp() {
        return this.m_timestamp;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public byte get() {
        return m_buf.order(ByteOrder.LITTLE_ENDIAN).get();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param b TODO 説明を定義してください。
     * @param i TODO 説明を定義してください。
     * @param j TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public byte[] get(byte[] b, int i, int j) {
        m_buf.order(ByteOrder.LITTLE_ENDIAN).get(b, i, j);

        return b;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param bs TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public byte[] get(byte[] bs) {
        m_buf.order(ByteOrder.LITTLE_ENDIAN).get(bs);

        return bs;
    }

    /**
     * TODO 説明を定義してください。
     */
    public void mark() {
        m_buf.mark();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int position() {
        return m_buf.position();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public byte[] readToken() {
        byte[] tmp = new byte[MAX_TMP_SIZE];
        int size = 0;

        for (int i = 0; i < MAX_TMP_SIZE; i++) {
            tmp[i] = m_buf.get();

            if (tmp[i] == '\0') {
                break;
            }

            size++;
        }

        byte[] ret = new byte[size];
        System.arraycopy(tmp, 0, ret, 0, size);

        return ret;
    }

    /**
     * TODO 説明を定義してください。
     */
    public void reset() {
        m_buf.reset();
    }

    /**
     * TODO 説明を定義してください。
     */
    public void skip() {
        m_buf.order(ByteOrder.LITTLE_ENDIAN).get();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param n TODO 説明を定義してください。
     */
    public void skip(int n) {
        m_buf.order(ByteOrder.LITTLE_ENDIAN).get(new byte[n]);
    }
    public ByteBuffer getBuf() {
        return this.m_buf;
    }
}