package jp.co.kayo.io;

import jp.co.kayo.action.Action;
import jp.co.kayo.action.ItemCode;
import jp.co.kayo.action.UnitBuildingAbility;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;


/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: PlayerRecord.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class PlayerRecord {
    /** TODO 説明を定義してください。 */
    public static final String HUMAN = "human";

    /** TODO 説明を定義してください。 */
    public static final String ORC = "orc";

    /** TODO 説明を定義してください。 */
    public static final String NIGHTELF = "nightelf";

    /** TODO 説明を定義してください。 */
    public static final String UNDEAD = "undead";

    /** TODO 説明を定義してください。 */
    public static final String DAEMON = "daemon";

    /** TODO 説明を定義してください。 */
    public static final String RANDOM = "random";

    /** TODO 説明を定義してください。 */
    public static final String UNKNOWN = "-";

    /** TODO 説明を定義してください。 */
    private String m_name;

    /** TODO 説明を定義してください。 */
    private Vector m_actions = new Vector();

    /** TODO 説明を定義してください。 */
    private Vector m_heros = new Vector();

    /** TODO 説明を定義してください。 */
    private Vector m_heroskills = new Vector();

    /** TODO 説明を定義してください。 */
    private int m_actioncount;

    /** TODO 説明を定義してください。 */
    private int m_color;

    /** TODO 説明を定義してください。 */
    private int m_computerplayerflag;

    /** TODO 説明を定義してください。 */
    private int m_handicap;

    /** TODO 説明を定義してください。 */
    private int m_id;

    /** TODO 説明を定義してください。 */
    private int m_race;

    /** TODO 説明を定義してください。 */
    private int m_slotstatus;

    /** TODO 説明を定義してください。 */
    private int m_team;

    /** TODO 説明を定義してください。 */
    private long m_gametime;

    /** TODO 説明を定義してください。 */
    private long m_playtime;

    /**
     * Creates a new PlayerRecord object.
     *
     * @param id TODO 説明を定義してください。
     * @param replay TODO 説明を定義してください。
     *
     * @throws Exception TODO 説明を定義してください。
     */
    public PlayerRecord(int id, ReplayBuffer replay) throws Exception {
        m_id = id;
        parse(replay);
    }

    /**
     * Creates a new Player object.
     *
     * @param replay TODO 説明を定義してください。
     *
     * @throws Exception
     */
    public PlayerRecord(ReplayBuffer replay) throws Exception {
        parse(replay);
    }

    /**
     * DOCUMENT ME!
     *
     * @return
     */
    public float getAPM() {
        float min = m_gametime / (60.0f * 1000.0f);

        return m_actioncount / min;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getActioncount() {
        return this.m_actioncount;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param color TODO 説明を定義してください。
     */
    public void setColor(int color) {
        this.m_color = color;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getColor() {
        return this.m_color;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public boolean isComputer() {
        return this.m_computerplayerflag == 0x01;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param flg TODO 説明を定義してください。
     */
    public void setComputerPlayerFlag(int flg) {
        this.m_computerplayerflag = flg;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getController() {
        return (m_team == 12) ? "Referees"
                              : (isComputer() ? "Computer"
                                              : ((m_slotstatus == 0x02)
        ? "Player" : "-"));
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param gametime TODO 説明を定義してください。
     */
    public void setGametime(long gametime) {
        this.m_gametime = gametime;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getGametime() {
        return this.m_gametime;
    }

    /**
     * DOCUMENT ME!
     *
     * @param playerhandicapinpercent
     */
    public void setHandicap(int playerhandicapinpercent) {
        m_handicap = playerhandicapinpercent;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getHandicap() {
        return m_handicap;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public Iterator getHeros() {
        return m_heros.iterator();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public Iterator getHeroskills() {
        return m_heroskills.iterator();
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getId() {
        return this.m_id;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getName() {
        return (this.m_name != null) ? this.m_name : "-";
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public long getPlaytime() {
        return this.m_playtime;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param race TODO 説明を定義してください。
     */
    public void setRace(int race) {
        this.m_race = race;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public String getRace() {
        switch (m_race) {
        case 0x01:
            return HUMAN;

        case 0x02:
            return ORC;

        case 0x04:
            return NIGHTELF;

        case 0x08:
            return UNDEAD;

        case 0x10:
            return DAEMON;

        case 0x20:
            return RANDOM;

        default:
            return UNKNOWN;
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param slotstatus TODO 説明を定義してください。
     */
    public void setSlotstatus(int slotstatus) {
        this.m_slotstatus = slotstatus;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getSlotstatus() {
        return this.m_slotstatus;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param team TODO 説明を定義してください。
     */
    public void setTeam(int team) {
        this.m_team = team;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @return TODO 説明を定義してください。
     */
    public int getTeam() {
        return this.m_team;
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param action TODO 説明を定義してください。
     */
    public void addAction(Action action) {
        if (action != null) {
            if (action.availableAPM()) {
                this.m_actioncount++;
            }

            if (action.getActionid() == 0x10) {
                UnitBuildingAbility abi = (UnitBuildingAbility) action;

                if ((abi.getAbilityflags() == 0x46) ||
                        (abi.getAbilityflags() == 0x44)) {
                    UnitBuildingAbility.Param10 param = (UnitBuildingAbility.Param10) abi.getParam();

                    switch (param.getChar()[0]) {
                    case 'H':
                    case 'O':
                    case 'U':
                    case 'N':
                    case 'E': {
                        String name = ItemCode.ID2Str(param.getItemid());

                        if (!m_heros.contains(name)) {
                            m_heros.add(name);
                        }
                    }

                    break;
                    }
                } else if (abi.getAbilityflags() == 0x42) {
                    UnitBuildingAbility.Param10 param = (UnitBuildingAbility.Param10) abi.getParam();

                    switch (param.getChar()[0]) {
                    case 'A': {
                        String idstr = ItemCode.ID2Str(param.getItemid());

                        if (m_heroskills.size() > 0) {
                            if (!m_heroskills.lastElement().equals(idstr)) {
                                m_heroskills.add(idstr);
                            }
                        } else {
                            m_heroskills.add(idstr);
                        }
                    }

                    break;
                    }
                }
            }

            m_actions.add(action);
        }
    }

    /**
     * TODO 説明を定義してください。
     *
     * @param replay TODO 説明を定義してください。
     *
     * @throws Exception TODO 説明を定義してください。
     */
    private void parse(ReplayBuffer replay) throws Exception {
        if (replay != null) {
            replay.mark();

            byte recordID = replay.get();

            if (recordID == 0x19) {
                replay.reset();
                throw new Exception("cant parse");
            }

            int id = replay.get();
            m_name = new String(replay.readToken());

            byte ladder = replay.get();

            if (ladder == 8) {
                m_playtime = replay.getInt();
                m_race = replay.get();
                replay.skip(3);

                //                replay.skip(4);
            } else {
                replay.skip(ladder);
            }

            if ((recordID == 0) || (recordID == 22)) {
                m_id = id;

                if (recordID == 0x16) {
                    replay.skip(4);
                }
            } else {
                replay.get();
            }

            m_team = (byte) ((m_id - 1) % 2);

            return;
        } else {
            throw new Exception("cant parse");
        }
    }
}