/*
 * 作成日: 2005/02/08
 */
package jp.co.kayo.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;

import javax.swing.JFrame;


import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class W3GPuni extends JFrame {

	private javax.swing.JPanel m_cntPane = null;
    private javax.swing.JPanel m_tpPane = null;
	private JSplitPane m_lrspPane = null;
    private JSplitPane m_tbspPane = null;
	private JList m_lstFile = null;
	private JTable m_tblReplays = null;
    private JTable m_tblPlayers  = null;
    
    private ReplayDB m_XMLDB;
    
    private String m_wc3installdir;
    
    private String getWC3Folder(){
        return m_wc3installdir;
    }
    
    private String[] getFolders(){
        File wc3 = new File(getWC3Folder());
        File[] files = File.listRoots();
        Vector v = new Vector();
        for(int i=0; i<files.length; i++){
            v.add(files[i].getAbsolutePath());
        }
        
        return (String[])v.toArray(new String[v.size()]);
    }

    private ReplayDB getXMLDB() throws Exception {
        if(m_XMLDB == null){
            m_XMLDB = new ReplayDB(getWC3Folder()+"/replay/replays.xml");
            if(m_XMLDB.isNeedSave()){
                File[] files = new File(getWC3Folder()+"/replay").listFiles(new FileFilter(){
                    public String getExtension(File f) {
                        if (f != null) {
                            String filename = f.getName();
                            int i = filename.lastIndexOf('.');
                            if (i > 0 && i < filename.length() - 1) {
                                return filename.substring(i + 1).toLowerCase();
                            }
                            ;
                        }
                        return null;
                    }

                    public boolean accept(File f) {
                        if (f != null) {
                            if (f.isDirectory()) {
                                return false;
                            }
                            String extension = getExtension(f);
                            if (extension != null && extension.equals("w3g")) {
                                return true;
                            }
                            ;
                        }
                        return false;
                    }});
                
                for(int i=0; i<files.length; i++){
                    String filename = files[i].getAbsolutePath();
                    m_XMLDB.addReplay(filename);
                }
            }
        }
        
        return m_XMLDB;
    }
    
    /**
	 * This is the default constructor
     * @throws Exception
	 */
	public W3GPuni(String wc3installdir) throws Exception {
		super();
        
        m_wc3installdir = wc3installdir;
        
		initialize();
        
        this.addWindowListener(new WindowAdapter(){
            public void windowClosed(WindowEvent e){
                try {
                    getXMLDB().save();
                    System.exit(-1);
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            });
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		this.setSize(520, 274);
		this.setContentPane(getCntPane());
		this.setTitle("W3GPuni");
        
        //画面の表示位置を中央へ
        Dimension me = getSize();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        double w = dim.getWidth();
        double h = dim.getHeight();
        setLocation((int) (w - me.width) / 2, (int) (h - me.height) / 2);
	}

    private javax.swing.JPanel getCntPane() {
		if(m_cntPane == null) {
			m_cntPane = new javax.swing.JPanel();
			m_cntPane.setLayout(new java.awt.BorderLayout());
            m_cntPane.add(getTopPane(), java.awt.BorderLayout.NORTH);
			m_cntPane.add(getLRSpPane(), java.awt.BorderLayout.CENTER);
		}
		return m_cntPane;
	}
    
    private JPanel getTopPane(){
        if(m_tpPane == null){
            m_tpPane = new JPanel();
            m_tpPane.setPreferredSize(new java.awt.Dimension(10,40));
        }
        
        return m_tpPane;
    }

    private JSplitPane getLRSpPane() {
		if (m_lrspPane == null) {
			m_lrspPane = new JSplitPane();
			m_lrspPane.setLeftComponent(getLstFile());
			m_lrspPane.setRightComponent(getTBSpPane());
		}
		return m_lrspPane;
	}
    
    private JSplitPane getTBSpPane(){
        if (m_tbspPane == null) {
            m_tbspPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
            m_tbspPane.setResizeWeight(1);

            JScrollPane jScrollPane;
            
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(getTblReplays());
            m_tbspPane.setTopComponent(jScrollPane);
            
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(getTblPlayers());
            m_tbspPane.setBottomComponent(jScrollPane);
        }
        return m_tbspPane;
    }
    
	/**
	 * This method initializes jList	
	 * 	
	 * @return javax.swing.JList	
	 */    
	private JList getLstFile() {
		if (m_lstFile == null) {
			m_lstFile = new JList();
            m_lstFile.setCellRenderer(new IconListCellRenderer());
            
            m_lstFile.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int index = m_lstFile.getSelectedIndex();
                    
                    NodeListModel model = (NodeListModel)m_lstFile.getModel();
                    Element el = model.getElement(index);
                    refreshReplays(el.getAttribute("xpath"));
                    
                }});
            
            refreshList();
		}
		return m_lstFile;
	}
    
    private void refreshList(){
        
        getLstFile().removeAll();
        
        try {
            NodeList nodelist = getXMLDB().getConditions();
            getLstFile().setModel(new NodeListModel(nodelist));
        } catch (Exception e) {
            
            e.printStackTrace();
        }
    }
    
    
	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */    
	private JTable getTblReplays() {
		if (m_tblReplays == null) {
			m_tblReplays = new ResultTable();
            
            m_tblReplays.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    refreshPlayers();
                    
                }});
            
            refreshReplays(null);
		}
		return m_tblReplays;
	}

    private JTable getTblPlayers() {
        if (m_tblPlayers == null) {
            m_tblPlayers = new PlayerTable();
            refreshPlayers();
        }
        return m_tblPlayers;
    }
    
    
    private void refreshReplays(String el){
        
        getTblReplays().removeAll();
        
        try {
            NodeList nodelist = getXMLDB().getFiles( el!=null ? el: "");
            ((ResultTable) getTblReplays()).setModel(nodelist);
            
        } catch (Exception e) {
            
            e.printStackTrace();
        }
    }

    private void refreshPlayers(){
        
        getTblReplays().removeAll();
        
        int row = getTblReplays().getSelectedRow();
        if( row >= 0){
            DOMTableModel model = (DOMTableModel)getTblReplays().getModel();
            Element replay = model.getRow(row);
    
            try {
                NodeList nodelist = XPathAPI.selectNodeList(replay, ".//player");
                ((PlayerTable) getTblPlayers()).setModel(nodelist);
                
            } catch (Exception e) {
                
                e.printStackTrace();
            }
        }
    }
    
    public static void main(String[] args){
        try {
            UIManager.setLookAndFeel(
            "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");

            String war3path = null;
            File inifile = new File(System.getProperty("user.home")+"/w3gmgr.ini");
            
            Properties prop = new Properties();
            if(inifile.exists()){
                prop.load(new FileInputStream(inifile));
                
                war3path = prop.getProperty("war3path");
            }
            else{
                inifile.createNewFile();
            }
            
            if(war3path == null){
                WC3Selector selector = new WC3Selector(true);
                selector.show();
                if( selector.getWc3installdir() != null){
                    war3path = selector.getWc3installdir();
                    prop.put("war3path", war3path);
                    prop.store(new FileOutputStream(inifile), null);
                }
                else{
                    return;
                }
            }

            W3GPuni frame;
            frame = new W3GPuni(war3path);
            frame.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }    
}
