/*
 * 作成日: 2005/02/01
 */
package jp.co.kayo.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFrame;


import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

import jp.co.kayo.io.W3GReader;
import jp.co.kayo.io.XMLUtil;

import javax.swing.JCheckBox;
public class W3G2XML extends JFrame {

	private javax.swing.JPanel jContentPane = null;
    private JTextField m_txtFrom = null;
    private JButton m_btnFrom = null;
    private String m_folder = null;

	private JButton m_btnDone = null;
    
	private JCheckBox m_withXSL = null;
    private String m_xsl = "http://homepage2.nifty.com/richdego/sakusaku/jws/w3g.xsl";
	/**
	 * This is the default constructor
	 */
	public W3G2XML() {
		super();
		initialize();
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setResizable(false);
		this.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		this.setSize(319, 122);
		this.setContentPane(getJContentPane());
		this.setTitle("W3G2XML");
        
        //画面を中心へ
        Dimension me = getSize();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        double w = dim.getWidth();
        double h = dim.getHeight();
        setLocation((int) (w - me.width) / 2, (int) (h - me.height) / 2);
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(jContentPane == null) {
			jContentPane = new javax.swing.JPanel();
            jContentPane.setLayout(null);

            JLabel label1 = new JLabel();
            label1.setBounds(17, 5, 94, 15);
            label1.setText("w3g file:");
            jContentPane.add(label1, null);
            jContentPane.add(getTxtFrom(), null);
            jContentPane.add(getBtnFrom(), null);

            
            JLabel label3 = new JLabel();
            label3.setBounds(41, 49, 94, 15);
            label3.setText("with xsl");
            jContentPane.add(label3, null);
            jContentPane.add(getBtnDone(), null);
            jContentPane.add(getChkwithXSL(), null);
        }
		return jContentPane;
	}
 
    
    private String makeXMLFile(String filename){
        if (filename != null) {
            int i = filename.lastIndexOf('.');
            if (i > 0 && i < filename.length() - 1) {
                String xmlname = filename.substring(0, i) + ".xml";
                return xmlname;
            }
            ;
        }
        return null;
    }
    
    private void convert(String fname){
        //コンバート処理
        String msg = "fail.";
        int status = JOptionPane.INFORMATION_MESSAGE;

        W3GReader reader;
        try {
            reader = new W3GReader(fname, true);
            if(this.getChkwithXSL().isSelected()){
                XMLUtil.saveXml(reader.getXML(), makeXMLFile(fname), m_xsl);
            }
            else{
                XMLUtil.saveXml(reader.getXML(), makeXMLFile(fname), null);
            }


            msg = "complete.";
        } catch (Exception e) {
            e.printStackTrace();
            status = JOptionPane.ERROR_MESSAGE;
        }

        JOptionPane.showMessageDialog(W3G2XML.this,
                msg,
                "message",
                status);
    }
    
    /**
     * This method initializes jTextField   
     *  
     * @return javax.swing.JTextField   
     */    
    private JTextField getTxtFrom() {
        if (m_txtFrom == null) {
            m_txtFrom = new JTextField();
            m_txtFrom.setBounds(16, 20, 238, 21);
        }
        return m_txtFrom;
    }
    /**
     * This method initializes jButton  
     *  
     * @return javax.swing.JButton  
     */    
    private JButton getBtnFrom() {
        if (m_btnFrom == null) {
            m_btnFrom = new JButton();
            m_btnFrom.setBounds(258, 21, 27, 18);
            m_btnFrom.setText("...");
            m_btnFrom.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    if(m_folder!=null){
                        chooser.setCurrentDirectory(new File(m_folder));
                    }
                    
                    FileFilter filter = new W3GFileFilter();
                    
                    chooser.setFileFilter(filter);
                    int returnVal = chooser.showOpenDialog(W3G2XML.this);
                    if(returnVal == JFileChooser.APPROVE_OPTION) {
                        getTxtFrom().setText(chooser.getSelectedFile().getAbsolutePath());
                        m_folder = chooser.getSelectedFile().getPath();
                    }
                }
            });
        }
        return m_btnFrom;
    }
    
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getBtnDone() {
		if (m_btnDone == null) {
			m_btnDone = new JButton();
			m_btnDone.setBounds(207, 63, 85, 24);
            m_btnDone.setText("Transform");
            this.getRootPane().setDefaultButton(m_btnDone);
            m_btnDone.addActionListener(new java.awt.event.ActionListener() { 
            	public void actionPerformed(java.awt.event.ActionEvent e) {
                    convert(getTxtFrom().getText());
            	}
            });
		}
		return m_btnDone;
	}
    
	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */    
	private JCheckBox getChkwithXSL() {
		if (m_withXSL == null) {
			m_withXSL = new JCheckBox();
			m_withXSL.setBounds(18, 47, 21, 21);
			m_withXSL.setText("with xsl");
		}
		return m_withXSL;
	}
     public static void main(String[] args){
        try {
            UIManager.setLookAndFeel(
            "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        } catch (Exception e) {
        }
        
        W3G2XML frame = new W3G2XML();
        frame.show();
    }
}  //  @jve:decl-index=0:visual-constraint="10,10"