package jp.co.kayo.gui;

import org.w3c.dom.NodeList;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;


/**
 * 結果テーブル
 *
 * @author MasafumiTerazono
 * @version $Id: ResultTable.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class ResultTable extends JTable {
    /** タグネームリスト */
    private final static String[] _tagNames = {
            "FileName",
            "Map",
            "Type",
            "Ver",
            "ReplayLength",
            "Creator",
            "FileSize",
            "TimeStamp"
        };
    /** テーブルサイズリスト */
    private final static int[] _tablesize = {
            15,
            15,
            5,
            5,
            5,
            7,
            7,
            7
        };

    /**
     * デフォルトコンストラクタ
     */
    public ResultTable() {
        this.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        this.getTableHeader().setReorderingAllowed(false);
        this.autoResizeMode = JTable.AUTO_RESIZE_OFF;
    }

    /**
     * モデルデータをセットします。
     *
     * @param nodelist 結果リスト
     */
    public void setModel(NodeList nodelist) {
        this.setModel(new ResultDOMTableModel(_tagNames, nodelist));
        for(int i=0; i<_tablesize.length; i++){
            this.getColumnModel().getColumn(i).setPreferredWidth(_tablesize[i]*12);
            this.getColumnModel().getColumn(i).setCellRenderer(new AlignmentTableCellRenderer(_tagNames));
        }
    }
}