/*
 * 作成日: 2005/02/08
 */
package jp.co.kayo.gui;

import java.io.File;
import java.util.Iterator;

import jp.co.kayo.io.PlayerRecord;
import jp.co.kayo.io.W3GReader;
import jp.co.kayo.io.XMLUtil;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;


public class ReplayDB {
    public static final String VERSION = "1.0";
    
    private String m_xmlpath;
    private Document m_xml;
    private Element m_root;
    private boolean m_needSave=false;
    
    /**
     * @param string
     * @throws Exception
     */
    public ReplayDB(String string) throws Exception {
        m_xmlpath = string;
        
        File file = new File(string);
        if(file.exists()){
            Document doc = XMLUtil.loadXml(string);
            if(validate(doc)){
                m_xml = doc;
            }
            else {
                throw new Exception("Can not read replays db.");
            }
        }
        else{
            m_xml = initialize(file);
        }
    }
    
    public NodeList getConditions() throws Exception {
        return XPathAPI.selectNodeList(m_root, "./conditions/condition");
    }
    
/*    public NodeList getFiles(Element condition) throws Exception {
        String xpath = condition.getAttribute("xpath");
        return XPathAPI.selectNodeList(m_root, ".//dict" + xpath);
    }*/
    
    public NodeList getFiles(String xpath) throws Exception {
//        System.out.println(".//dict" + xpath);
        return XPathAPI.selectNodeList(m_root, ".//dict" + xpath);
    }
    
    public void save() throws Exception{
        XMLUtil.saveXml(m_xml, m_xmlpath, null);
//        System.out.println("save:"+m_xmlpath);
        m_needSave = false;
    }
    
    public void addReplay(String file){
        
        try {
            W3GReader reader = new W3GReader(file, true);
            
            NodeList list = getFiles("[ @key='"+reader.getHashCode()+"']");
            if(list.getLength()==0){
                Element dict = m_xml.createElement("dict");
                dict.setAttribute("FileName", new File(file).getName());
                dict.setAttribute("TimeStamp", Long.toString(reader.getReplayfile().getTimestamp()));
                dict.setAttribute("FileSize", Long.toString(reader.getReplayfile().getFilesize()));
                dict.setAttribute("Ver", reader.getHeader().getMajorVer());
                dict.setAttribute("ReplayLength", Long.toString(reader.getHeader().getGameTime()));
                dict.setAttribute("Map", reader.getReplay().getMapname());
                dict.setAttribute("Type", reader.getReplay().getType());
                dict.setAttribute("Creator", reader.getReplay().getCreator());
                dict.setAttribute("StartSpot", Long.toString(reader.getReplay().getGamestartrecord().getStartspotcount()));
                
                //プレイヤー情報
                for (Iterator ite = reader.getReplay().getPlayermap().values().iterator(); ite.hasNext();) {
                        PlayerRecord player = (PlayerRecord) ite.next();

                        if(player.getController().equals("Player") || player.getController().equals("Computer")){
                            Element elm = m_xml.createElement("player");
    
                            elm.setAttribute("Id", Integer.toString(player.getId()));
                            elm.setAttribute("Color",  Integer.toString(player.getColor()));
                            elm.setAttribute("Name",  player.getName());
                            elm.setAttribute("Race",  player.getRace());
                            elm.setAttribute("Handicap",  Integer.toString(player.getHandicap()));
                            elm.setAttribute("APM",  Float.toString(player.getAPM()));
                            elm.setAttribute("Actions",  Integer.toString(player.getActioncount()));
                            elm.setAttribute("GameTime",  Long.toString(player.getGametime()));
                            elm.setAttribute("PlayTime",  Long.toString(player.getPlaytime()));
                            
                            for(Iterator heros=player.getHeros(); heros.hasNext(); ){
                                Element hero = m_xml.createElement("hero");
                                hero.setAttribute("name", (String)heros.next());
                                elm.appendChild(hero);
                            }
                            for(Iterator skills=player.getHeroskills(); skills.hasNext(); ){
                                Element skill = m_xml.createElement("skill");
                                skill.setAttribute("name", (String)skills.next());
                                elm.appendChild(skill);
                            }
                            
                            dict.appendChild(elm);
                        }
                }

                /*
                //チャット情報
                xml
                .append("<Chat>");
                for (Iterator ite = reader.getReplay().getChats().iterator(); ite.hasNext();) {
                    Chat chat = (Chat) ite.next();
                    xml.append(chat.toXML());
                }
                xml
                .append("</Chat>");                    
                Node node = XMLUtil.StringToNode(xml.toString(), false, false).getFirstChild();
                Node clone = m_xml.importNode(node, true);
                */
                               
                //追加
                XPathAPI.selectSingleNode(m_xml, "/rlist/dicts").appendChild(dict);
                
                m_needSave = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document initialize(File file) throws Exception{
        Document doc = XMLUtil.newDocument();
        
        m_root = doc.createElement("rlist");
        m_root.setAttribute("version", VERSION);
        doc.appendChild(m_root);
        
        //リプレイファイル集
        Element dicts = doc.createElement("dicts");
        m_root.appendChild(dicts);
        
        //リプレイ検索条件集
        Element conditions = doc.createElement("conditions");
        m_root.appendChild(conditions);

        //"全て"の条件を追加
        {
            Element condition = doc.createElement("condition");
            condition.setAttribute("name", "全てのリプレイ");
            condition.setAttribute("icon", "0");
            condition.setAttribute("xpath", "");
            conditions.appendChild(condition);
        }
        //"1v1"の条件を追加
        {
            Element condition = doc.createElement("condition");
            condition.setAttribute("name", "H2H");
            condition.setAttribute("icon", "1");
            condition.setAttribute("xpath", "[ ./@Type='1v1']");
            conditions.appendChild(condition);
        }
        //"2v2"の条件を追加
        {
            Element condition = doc.createElement("condition");
            condition.setAttribute("name", "2v2");
            condition.setAttribute("icon", "1");
            condition.setAttribute("xpath", "[ ./@Type='2v2']");
            conditions.appendChild(condition);
        }
        //"3v3"の条件を追加
        {
            Element condition = doc.createElement("condition");
            condition.setAttribute("name", "3v3");
            condition.setAttribute("icon", "1");
            condition.setAttribute("xpath", "[ ./@Type='3v3']");
            conditions.appendChild(condition);
        }

        
        m_needSave = true;
        return doc;
    }
    
    private boolean validate(Document doc) throws Exception {
        if( doc == null){
            return false;
        }
        
        m_root = (Element)XPathAPI.selectSingleNode(doc.getFirstChild(), "/rlist");
        
        return m_root != null;
    }

    public boolean isNeedSave() {
        return this.m_needSave;
    }
}
