package jp.co.kayo.gui;

import org.w3c.dom.NodeList;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;


/**
 * 結果テーブル
 *
 * @author MasafumiTerazono
 * @version $Id: PlayerTable.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class PlayerTable extends JTable {
    /** タグネームリスト */
    private final static String[] _tagNames = {
            "Name",
            "Race",
            "Color",
            "Handicap",
            "APM",
            "Actions",
        };
    /** テーブルサイズリスト */
    private final static int[] _tablesize = {
            15,
            7,
            5,
            5,
            7,
            7,
        };

    /**
     * デフォルトコンストラクタ
     */
    public PlayerTable() {
        this.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        this.getTableHeader().setReorderingAllowed(false);
        this.autoResizeMode = JTable.AUTO_RESIZE_OFF;
    }

    /**
     * モデルデータをセットします。
     *
     * @param nodelist 結果リスト
     */
    public void setModel(NodeList nodelist) {
        this.setModel(new ResultDOMTableModel(_tagNames, nodelist));
        for(int i=0; i<_tablesize.length; i++){
            this.getColumnModel().getColumn(i).setPreferredWidth(_tablesize[i]*12);
            this.getColumnModel().getColumn(i).setCellRenderer(new AlignmentTableCellRenderer(_tagNames));
        }
    }
}