/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import jp.co.kayo.io.ReplayBuffer;


public class UnitBuildingAbility extends Action {
    int m_abilityflags;
    Param m_param;
    

    
    public static interface Param{
        public void parse(ReplayBuffer buf);
        public String toXML();
    }
    
    public static class Param10 implements Param {
        int m_itemid;
        
        public void parse(ReplayBuffer buf) {
            m_itemid = buf.getInt();
            int tmp1 = buf.getInt();
            int tmp2 = buf.getInt();
            m_itemid = (m_itemid>>8)|((tmp1&0xff)<<24);
        }
        
        public String toXML(){
            StringBuffer buf = new StringBuffer();
            
            buf.append("<ItemID>");
            buf.append(ItemCode.ID2Str(m_itemid));
            buf.append("</ItemID>");
            
            return buf.toString();
        }
        public int getItemid() {
            return this.m_itemid;
        }
        
        public char[] getChar(){
            char[] b = new char[4];
            b[0] = (char)((m_itemid&0xff000000)>>24);
            b[1] = (char)((m_itemid&0xff0000)>>16);
            b[2] = (char)((m_itemid&0xff00)>>8);
            b[3] = (char)((m_itemid&0xff)>>0);
            return b;
        }
        
    }

    public static class Param11 extends Param10 {
        int X;
        int Y;
        public void parse(ReplayBuffer buf) {
            super.parse(buf);
            X = buf.getInt();
            Y = buf.getInt();
        }
        public String toXML(){
            
            StringBuffer buf = new StringBuffer(super.toXML());
            
            buf.append("<TargetLocation");
            buf.append(" X='").append((float)X).append("' ");
            buf.append(" Y='").append((float)Y).append("' ");
            buf.append("/>");
            
            return buf.toString();
        }
        
    }

    public static class Param12 extends Param11 {
        int ID1;
        int ID2;
        public void parse(ReplayBuffer buf) {
            super.parse(buf);
            ID1 = buf.getInt();
            ID2 = buf.getInt();
        }
        public String toXML(){
            
            StringBuffer buf = new StringBuffer(super.toXML());
            
            if( ID1 == ID2 && ID1 == 0XFFFFFFFF ){
                buf.append("<RallyOnGround />");
            }
            return buf.toString();
        }
    }

    public static class Param14 implements Param {
        int ItemIDA;
        int AX;
        int AY;
        int ItemIDB;
        int BX;
        int BY;
        public void parse(ReplayBuffer buf) {
            ItemIDA = buf.getInt();
            int tmp1 = buf.getInt();
            int tmp2 = buf.getInt();
            ItemIDA = (ItemIDA>>8)|((tmp1&0xff)<<24);

            AX = buf.getInt();
            AY = buf.getInt();

            ItemIDB = buf.getInt();
            tmp1 = buf.getInt();
            tmp2 = buf.getInt();
            ItemIDB = (ItemIDB>>8)|((tmp1&0xff)<<24);
            buf.skip();
            BX = buf.getInt();
            BY = buf.getInt();

        }
        public String toXML(){
            StringBuffer buf = new StringBuffer();
            
            buf.append("<ItemIDA>");
            buf.append(ItemCode.ID2Str(ItemIDA));
            buf.append("</ItemIDA>");
            buf.append("<TargetLocationA");
            buf.append(" X='").append((float)AX).append("' ");
            buf.append(" Y='").append((float)AY).append("' ");
            buf.append("/>");
            
            buf.append("<ItemIDB>");
            buf.append(ItemCode.ID2Str(ItemIDB));
            buf.append("</ItemIDB>");
            buf.append("<TargetLocationB");
            buf.append(" X='").append((float)BX).append("' ");
            buf.append(" Y='").append((float)BY).append("' ");
            buf.append("/>");
            
            return buf.toString();
        }
    }
    
    
    /**
     * @param actionid
     */
    public UnitBuildingAbility(int actionid) {
        super(actionid);
    }

    /**
     * @see jp.co.kayo.action.Action#parse(jp.co.earthrin.io.ReplayBuffer)
     */
    public void parse(ReplayBuffer buf) {
        /*
        0x0001 - queue command (shift held down)
        0x0002 - ? (apply to all units in subgroup ?)
        0x0004 - ? (area effect ?)
        0x0008 - group command (all units in current selection)
        0x0010 - move group without formation (formation disabled)
        0x0020 - ?
        0x0040 - ctrl held down (subgroup command)
               sometimes automatically added
               (e.g. subgroup worker -> rightclick mine without ctrl)

       new since patch 1.13
        0x0100 - autocast on/off command*/
        m_abilityflags = buf.get();//.getBuf().order(ByteOrder.BIG_ENDIAN).get();
        
        
        m_param = null;
        switch(getActionid()){
            case 0x10:
                m_param = new Param10();break;
            case 0x11:
                m_param = new Param11();break;
            case 0x12:
                m_param = new Param12();break;
            case 0x14:
                m_param = new Param14();break;
        }
        if(m_param != null){
            m_param.parse(buf);
        }
    }
    
    public String toXML() {
        StringBuffer buf = new StringBuffer();
        
        buf.append("<AbilityFlags");
        
        buf.append(" flags='"+Long.toHexString(m_abilityflags)+"' ");
        
        if(((m_abilityflags&0x0001) != 0)){
            buf.append(" shift='1' ");
        }
        if(((m_abilityflags&0x0004) != 0)){
            buf.append(" areatarget='1' ");
        }
        if(((m_abilityflags&0x0008) != 0)){
            buf.append(" group='1' ");
        }
        switch(m_abilityflags){
            case 0x40:{
                buf.append(" analysis='useitem/upgrade' ");
            }break;
            case 0x46:
            case 0x42:{
                buf.append(" analysis='train/summon/research' ");
            }break;
            case 0x44:{
                buf.append(" analysis='useability/summon' ");
            }break;
        }
        buf.append("/>");
        if(m_param!=null){
            buf.append(m_param.toXML());
        }
        return buf.toString();
    }

    /**
     * @see jp.co.kayo.action.Action#getType()
     */
    public int getType() {
        return ID_UNIT_BUILDING_ABILITY;
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return true;
    }
    public int getAbilityflags() {
        return this.m_abilityflags;
    }
    public Param getParam() {
        return this.m_param;
    }
}
