/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import jp.co.kayo.io.ReplayBuffer;


public class SetGameSpeed extends Action {
    /**
     * @param actionid
     */
    public SetGameSpeed(int actionid) {
        super(actionid);
    }

    public static final int SLOW = 0x00;
    public static final int NORMAL = 0x01;
    public static final int FAST = 0x02;
    
    private int gamespeed;

    /**
     * @see jp.co.kayo.action.Action#parse(ReplayBuffer)
     */
    public void parse(ReplayBuffer buf) {
        gamespeed = buf.get();
    }

    /**
     * @see jp.co.kayo.action.Action#getType()
     */
    public int getType() {
        return ID_SET_GAME_SPEED;
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return false;
    }

}
