/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import jp.co.kayo.io.ReplayBuffer;


public class GiveIitemToUnit extends Action {
    int AbilityFlags;
    int ItemID;
    int tX;
    int tY;
    int tobjectID1;
    int tobjectID2;
    int iobjectID1;
    int iobjectID2;

    /**
     * @param actionid
     */
    public GiveIitemToUnit(int actionid) {
        super(actionid);
    }

    public int getType() {
        return ID_GIVE_ITEM_TO_UNIT;
    }
    public void parse(ReplayBuffer buf) {
        AbilityFlags = buf.get();
        ItemID = buf.getInt();
        int tmp1 = buf.getInt();
        int tmp2 = buf.getInt();
        ItemID = (ItemID>>8)|((tmp1&0xff)<<24);
        tX = buf.getInt();
        tY = buf.getInt();
        tobjectID1 = buf.getInt();
        tobjectID2 = buf.getInt();
        iobjectID1 = buf.getInt();
        iobjectID2 = buf.getInt();
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return true;
    }
    
    public String toXML() {
        StringBuffer buf = new StringBuffer();
        
        buf.append("<ItemID>");
        buf.append(ItemCode.ID2Str(ItemID));
        buf.append("</ItemID>");
        buf.append("<TargetLocationA");
        buf.append(" X='").append((float)tX).append("' ");
        buf.append(" Y='").append((float)tX).append("' ");
        buf.append("/>");
        
        return buf.toString();
    }
}
