/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.co.kayo.io.ReplayBuffer;


public class Chat extends Action {
    int m_flags;
    int m_mode;
    String m_message;

    /**
     * @param actionid
     */
    public Chat(int actionid) {
        super(actionid);
    }

    /**
     * @see jp.co.kayo.action.Action#parse(jp.co.earthrin.io.ReplayBuffer)
     */
    public void parse(ReplayBuffer buf) {
        setId(buf.get());
        int n = buf.getShort();
        m_flags = buf.get();
        m_mode = buf.getInt();
        
        CharsetDecoder cd = Charset.forName("UTF-8").newDecoder();
        cd.onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
        
        byte[] ba = buf.readToken();
        
        char[] ca = new char[(int) (cd.maxCharsPerByte() * ba.length)];
        ByteBuffer bb = ByteBuffer.wrap(ba, 0, ba.length);
        CharBuffer cb = CharBuffer.wrap(ca);
        
        CoderResult cr = cd.decode(bb, cb, true);
        if (cr.isMalformed() || cr.isUnmappable()){
            m_message = "unsupport charset";
        }
        else{
            m_message = new String(bb.array());
        }
    }

    /**
     * @see jp.co.kayo.action.Action#getType()
     */
    public int getType() {
        return ID_CHAT;
    }
    
    public String getTo(){
        /*1 dword  - chat mode (not present if flag = 0x10):
            0x00   for messages to all players
            0x01   for messages to allies
            0x02   for messages to observers or referees
            0x03+N for messages to specific player N (with N = slotnumber)*/
        switch(m_mode){
            case 0x00: return "all";
            case 0x01: return "allies";
            case 0x02: return "observers/referees";
            case 0x03: return "player["+m_mode+"]";
            default:
                return "unknow";
        }
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return false;
    }

    public String getMessage() {
        return this.m_message;
    }
    public String toXML() {
        String msg = this.m_message;
        msg = msg.replaceAll(">", "&gt;");
        msg = msg.replaceAll("<", "&lt;");
        
        DateFormat df = new SimpleDateFormat("mm:ss");
        
        StringBuffer xml = new StringBuffer();
        xml
        .append("<Message>")
            .append("<PlayerID>").append(getId()).append("</PlayerID>")
            .append("<Time msec='").append(getTime()).append("' >").append(df.format(new Date(getTime()))).append("</Time>")
            .append("<To>").append(getTo()).append("</To>")
            .append("<Content>").append(msg).append("</Content>")
        .append("</Message>");
        
        return xml.toString();
    }
}
