/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import jp.co.kayo.io.ReplayBuffer;


public class ChangeSelection extends Action {
    /**
     * @param actionid
     */
    public ChangeSelection(int actionid) {
        super(actionid);
    }

    int mode;
    int number;
    int[][] ObjectID;

    /**
     * @see jp.co.kayo.action.Action#parse(jp.co.earthrin.io.ReplayBuffer)
     */
    public void parse(ReplayBuffer buf) {
        mode = buf.get();
        number = buf.getShort();
        
        ObjectID = new int[number][2];
        for(int i=0; i<number; i++){
            ObjectID[i][0] = buf.getInt();
            ObjectID[i][1] = buf.getInt();
        }
    }

    /**
     * @see jp.co.kayo.action.Action#getType()
     */
    public int getType() {
        return ID_CHANGE_SELECTION;
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return true;
    }
    
    public String toXML() {
        String str = mode == 0x01?"Add "+number+" units(s) to selection":"Remove "+number+" units(s) remove from selection";
        
        StringBuffer xml = new StringBuffer()
        .append("<Selection>").append( str ).append("</Selection>");
        
        return xml.toString();
    }
}
