/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;

import jp.co.kayo.io.ReplayBuffer;


public class AssignGroupHotkey extends Action {
    int mode;
    int number;
    int[][] ObjectID;

    /**
     * @param actionid
     */
    public AssignGroupHotkey(int actionid) {
        super(actionid);
    }

    public int getType() {
        return ID_ASSIGN_GROUP_HOTKEY;
    }

    /**
     * @see jp.co.kayo.action.Action#parse(jp.co.earthrin.io.ReplayBuffer)
     */
    public void parse(ReplayBuffer buf) {
        mode = buf.get();
        number = buf.getShort();
        
        ObjectID = new int[number][2];
        for(int i=0; i<number; i++){
            ObjectID[i][0] = buf.getInt();
            ObjectID[i][1] = buf.getInt();
        }
    }

    /**
     * @see jp.co.kayo.action.Action#availableAPM()
     */
    public boolean availableAPM() {
        return true;
    }
    public String toXML() {
        String str = number+" unit(s) to hotkey "+mode;
        StringBuffer xml = new StringBuffer()
        .append("<Assign>").append( str ).append("</Assign>");
        
        return xml.toString();
    }
}
