/*
 * 作成日: 2005/01/25
 */
package jp.co.kayo.action;



public class ActionFactory {
    
    private static ActionFactory _factory = null;
    
    private static ActionFactory instance(){
        if(_factory == null){
            _factory = new ActionFactory();
        }
        return _factory;
    }
    
    public static Action get(int actionid){
        switch(actionid){
            case 0x01:
                return new Pause(actionid);
            case 0x02:
                return new Resume(actionid);
            case 0x03:
                return new SetGameSpeed(actionid);
            case 0x04:
                return new IncreaseGameSpeed(actionid);
            case 0x05:
                return new DecreaseGameSpeed(actionid);
            case 0x06:
            case 0x07:
                return new SaveGame(actionid);
            case 0x10:
            case 0x11:
            case 0x12:
            case 0x14:
                return new UnitBuildingAbility(actionid);
            case 0x13:
                return new GiveIitemToUnit(actionid);
            case 0x16:
                return new ChangeSelection(actionid);
            case 0x17:
                return new AssignGroupHotkey(actionid);
            case 0x18:
                return new SelectGroupHotkey(actionid);
            case 0x19:
                return new SelectSubgroup(actionid);
            case 0x1A:
                return new UpdateSubgroup(actionid);
            case 0x1C:
                return new SelectGroundItem(actionid);
            case 0x1D:
                return new CancelHeroRevival(actionid);
            case 0x1E:
                return new RemoveUnit(actionid);
            case 0x20:
            case 0x22:
            case 0x23:
            case 0x24:
            case 0x25:
            case 0x26:
            case 0x27:
            case 0x28:
            case 0x29:
            case 0x2A:
            case 0x2B:
            case 0x2C:
            case 0x2D:
            case 0x2E:
            case 0x2F:
            case 0x30:
            case 0x31:
            case 0x32:
                return new SinglePlayerCheats(actionid);
            case 0x50:
                return new ChangeAllyOptions(actionid);
            case 0x51:
                return new TransferResources(actionid);
            case 0x60:
                return new MapChatCommand(actionid);
            case 0x61:
                return new ESC(actionid);
            case 0x62:
                return new ScenarioTrigger(actionid);
            case 0x66:
                return new EnterSelectHero(actionid);
            case 0x67:
                return new EnterSelectBuilding(actionid);
            case 0x68:
                return new MinimapSignal(actionid);
            case 0x69:
            case 0x6A:
                return new ContinueGame(actionid);
            case 0x1B:
            case 0x21:
            case 0x75:
                return new Unknown(actionid);
            case 0x17|0x80:
                return new LeaveGame(actionid&~0x80);
            case 0x20|0x80:
                return new Chat(actionid&~0x80);
        }
        
        return null;
    }

}
