/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class ReplayBuffer {
    private ByteBuffer m_buf;
    private final int MAX_TMP_SIZE = 256;
    private long m_filesize;
    private long m_timestamp;

    public ReplayBuffer(ByteBuffer buf) {
        this.m_buf = buf;
        this.m_filesize = this.m_buf.capacity();
    }

    public ReplayBuffer(String filename) throws IOException {
        File file = new File(filename);
        this.m_timestamp = file.lastModified();
        FileInputStream fis = new FileInputStream(filename);
        FileChannel channel = fis.getChannel();
        this.m_filesize = (int)channel.size();
        this.m_buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.m_filesize);
    }

    public long getFilesize() {
        return this.m_filesize;
    }

    public int getInt() {
        return this.m_buf.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public short getShort() {
        return this.m_buf.order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public byte get() {
        return this.m_buf.order(ByteOrder.LITTLE_ENDIAN).get();
    }

    public byte[] get(byte[] b, int i, int j) {
        this.m_buf.order(ByteOrder.LITTLE_ENDIAN).get(b, i, j);
        return b;
    }

    public byte[] get(byte[] bs) {
        this.m_buf.order(ByteOrder.LITTLE_ENDIAN).get(bs);
        return bs;
    }

    public void mark() {
        this.m_buf.mark();
    }

    public int position() {
        return this.m_buf.position();
    }

    public byte[] readToken() {
        byte[] tmp = new byte[256];
        int size = 0;
        int i = 0;
        while (i < 256) {
            tmp[i] = this.m_buf.get();
            if (tmp[i] == 0) break;
            ++size;
            ++i;
        }
        byte[] ret = new byte[size];
        System.arraycopy(tmp, 0, ret, 0, size);
        return ret;
    }

    public void reset() {
        this.m_buf.reset();
    }

    public void skip() {
        this.m_buf.order(ByteOrder.LITTLE_ENDIAN).get();
    }

    public void skip(int n) {
        this.m_buf.order(ByteOrder.LITTLE_ENDIAN).get(new byte[n]);
    }

    public ByteBuffer getBuf() {
        return this.m_buf;
    }
}

