/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import java.util.Iterator;
import java.util.Vector;
import jp.co.kayo.action.Action;
import jp.co.kayo.action.ItemCode;
import jp.co.kayo.action.UnitBuildingAbility;
import jp.co.kayo.io.ReplayBuffer;

public class PlayerRecord {
    public static final String HUMAN = "human";
    public static final String ORC = "orc";
    public static final String NIGHTELF = "nightelf";
    public static final String UNDEAD = "undead";
    public static final String DAEMON = "daemon";
    public static final String RANDOM = "random";
    public static final String UNKNOWN = "-";
    private String m_name;
    private Vector m_actions = new Vector();
    private Vector m_heros = new Vector();
    private Vector m_heroskills = new Vector();
    private int m_actioncount;
    private int m_color;
    private int m_computerplayerflag;
    private int m_handicap;
    private int m_id;
    private int m_race;
    private int m_slotstatus;
    private int m_team;
    private long m_gametime;
    private long m_playtime;

    public PlayerRecord(int id, ReplayBuffer replay) throws Exception {
        this.m_id = id;
        this.parse(replay);
    }

    public PlayerRecord(ReplayBuffer replay) throws Exception {
        this.parse(replay);
    }

    public float getAPM() {
        float min = (float)this.m_gametime / 60000.0f;
        return (float)this.m_actioncount / min;
    }

    public int getActioncount() {
        return this.m_actioncount;
    }

    public void setColor(int color) {
        this.m_color = color;
    }

    public int getColor() {
        return this.m_color;
    }

    public boolean isComputer() {
        return this.m_computerplayerflag == 1;
    }

    public void setComputerPlayerFlag(int flg) {
        this.m_computerplayerflag = flg;
    }

    public String getController() {
        return this.m_team == 12 ? "Referees" : (this.isComputer() ? "Computer" : (this.m_slotstatus == 2 ? "Player" : UNKNOWN));
    }

    public void setGametime(long gametime) {
        this.m_gametime = gametime;
    }

    public long getGametime() {
        return this.m_gametime;
    }

    public void setHandicap(int playerhandicapinpercent) {
        this.m_handicap = playerhandicapinpercent;
    }

    public int getHandicap() {
        return this.m_handicap;
    }

    public Iterator getHeros() {
        return this.m_heros.iterator();
    }

    public Iterator getHeroskills() {
        return this.m_heroskills.iterator();
    }

    public int getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name != null ? this.m_name : UNKNOWN;
    }

    public long getPlaytime() {
        return this.m_playtime;
    }

    public void setRace(int race) {
        this.m_race = race;
    }

    public String getRace() {
        switch (this.m_race) {
            case 1: {
                return HUMAN;
            }
            case 2: {
                return ORC;
            }
            case 4: {
                return NIGHTELF;
            }
            case 8: {
                return UNDEAD;
            }
            case 16: {
                return DAEMON;
            }
            case 32: {
                return RANDOM;
            }
        }
        return UNKNOWN;
    }

    public void setSlotstatus(int slotstatus) {
        this.m_slotstatus = slotstatus;
    }

    public int getSlotstatus() {
        return this.m_slotstatus;
    }

    public void setTeam(int team) {
        this.m_team = team;
    }

    public int getTeam() {
        return this.m_team;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAction(Action action) {
        if (action != null) {
            if (action.availableAPM()) {
                ++this.m_actioncount;
            }
            if (action.getActionid() == 16) {
                UnitBuildingAbility abi = (UnitBuildingAbility)action;
                if (abi.getAbilityflags() == 70 || abi.getAbilityflags() == 68) {
                    UnitBuildingAbility.Param10 param = (UnitBuildingAbility.Param10)abi.getParam();
                    switch (param.getChar()[0]) {
                        case 'E': 
                        case 'H': 
                        case 'N': 
                        case 'O': 
                        case 'U': {
                            String name = ItemCode.ID2Str(param.getItemid());
                            if (this.m_heros.contains(name)) break;
                            this.m_heros.add(name);
                        }
                    }
                } else if (abi.getAbilityflags() == 66) {
                    UnitBuildingAbility.Param10 param = (UnitBuildingAbility.Param10)abi.getParam();
                    switch (param.getChar()[0]) {
                        case 'A': {
                            String idstr = ItemCode.ID2Str(param.getItemid());
                            if (this.m_heroskills.size() > 0) {
                                if (this.m_heroskills.lastElement().equals(idstr)) break;
                                this.m_heroskills.add(idstr);
                                break;
                            }
                            this.m_heroskills.add(idstr);
                            break;
                        }
                    }
                }
            }
            this.m_actions.add(action);
        }
    }

    private void parse(ReplayBuffer replay) throws Exception {
        if (replay != null) {
            replay.mark();
            byte recordID = replay.get();
            if (recordID == 25) {
                replay.reset();
                throw new Exception("cant parse");
            }
            byte id = replay.get();
            this.m_name = new String(replay.readToken());
            byte ladder = replay.get();
            if (ladder == 8) {
                this.m_playtime = replay.getInt();
                this.m_race = replay.get();
                replay.skip(3);
            } else {
                replay.skip(ladder);
            }
            if (recordID == 0 || recordID == 22) {
                this.m_id = id;
                if (recordID == 22) {
                    replay.skip(4);
                }
            } else {
                replay.get();
            }
            this.m_team = (byte)((this.m_id - 1) % 2);
            return;
        }
        throw new Exception("cant parse");
    }
}

