/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    private Logger m_log = null;

    private Log(Logger log) {
        this.m_log = log;
    }

    public static Log logger() {
        return new Log(Logger.getLogger("W3G"));
    }

    public static Log logger(Class c) {
        return new Log(Logger.getLogger(c.getName()));
    }

    public static Log logger(Object o) {
        return new Log(Logger.getLogger(o.getClass().getName()));
    }

    public static Log logger(String s) {
        return new Log(Logger.getLogger(s));
    }

    public boolean isDebugEnabled() {
        return this.m_log.isLoggable(Level.FINER);
    }

    public boolean isErrorEnabled() {
        return this.m_log.isLoggable(Level.FINE);
    }

    public boolean isFatalEnabled() {
        return this.m_log.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.m_log.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.m_log.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.m_log.isLoggable(Level.WARNING);
    }

    public void debug(Object arg0) {
        if (this.isDebugEnabled()) {
            this.m_log.finer(arg0.toString());
        }
    }

    public void debug(Object arg0, Throwable arg1) {
        if (this.isDebugEnabled()) {
            this.m_log.log(Level.FINER, arg0.toString(), arg1);
        }
    }

    public void error(Object arg0) {
        if (this.isErrorEnabled()) {
            this.m_log.fine(arg0.toString());
        }
    }

    public void error(Object arg0, Throwable arg1) {
        if (this.isErrorEnabled()) {
            this.m_log.log(Level.FINE, arg0.toString(), arg1);
        }
    }

    public void fatal(Object arg0) {
        if (this.isFatalEnabled()) {
            this.m_log.severe(arg0.toString());
        }
    }

    public void fatal(Object arg0, Throwable arg1) {
        if (this.isFatalEnabled()) {
            this.m_log.log(Level.SEVERE, arg0.toString(), arg1);
        }
    }

    public void info(Object arg0) {
        if (this.isInfoEnabled()) {
            this.m_log.info(arg0.toString());
        }
    }

    public void info(Object arg0, Throwable arg1) {
        if (this.isInfoEnabled()) {
            this.m_log.log(Level.INFO, arg0.toString(), arg1);
        }
    }

    public void trace(Object arg0) {
        if (this.isTraceEnabled()) {
            this.m_log.finest(arg0.toString());
        }
    }

    public void trace(Object arg0, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.m_log.log(Level.FINEST, arg0.toString(), arg1);
        }
    }

    public void warn(Object arg0) {
        if (this.isWarnEnabled()) {
            this.m_log.warning(arg0.toString());
        }
    }

    public void warn(Object arg0, Throwable arg1) {
        if (this.isWarnEnabled()) {
            this.m_log.log(Level.WARNING, arg0.toString(), arg1);
        }
    }
}

