﻿/*----------------------------------------------------------------------------
  VSK-jpn AutoHotKeyU用スクリプト

  2010/05/20　アルファ版

-----------------------------------------------------------------------------
*/

#IfWinActive ahk_class GbxApp ; this caters for both VskAC32 and Vsk5Online 
gDelay=4
gPress=4
gPlay=0
SetKeyDelay,gDelay,gPress,gPlay 
Pause := 40 ; mS delay used in various places 
Lang := "e" ; デフォルト表示 e:英語 j:日本語

Chat(Msg)
;--------------------------------------------------------------
; チャットへメッセージを書きこむ
;   対象：AutoHotKeyU用
;   条件：チャット入力が非アクティブ
;   不具合対応：日本語と欧文が混在している場合、sendInputを使うと
;     日本語が先に出力されてしまう。このため、sendInputをsendに
;     変更
;--------------------------------------------------------------
{ 
  SetKeyDelay,20,20,0 
  send {Enter}
  send %Msg%
  sleep 40
  send {Enter}
  SetKeyDelay,gDelay,gPress,gPlay 
} 

SendMsg(Msg)
;--------------------------------------------------------------
; チャットへメッセージを書きこむ
;   対象：AutoHotKeyU用
;   条件：チャット入力がアクティブ（hotstringsで呼び出しで利用）
;--------------------------------------------------------------
{ 
  SetKeyDelay,20,20,0 
  send %Msg% 
  SetKeyDelay,gDelay,gPress,gPlay 
} 

;===========================================================================
; HotKeyの登録
;   対象：AutoHotKeyU用
;   同じHotKeyに対し、言語を切り替えることができる
;   言語は、グローバル変数「Lang」で指定する
;     Lang:="j" ; 日本語
;     Lang:="e" ; 英語
;     Lang:="g" ; ドイツ語
;     Lang:="f" ; フランス語;
;     Lang:="i" ; イタリア語;

+j:: Lang:="j" ; Shift+j 日本語にする
+e:: Lang:="e" ; Shift+e 英語にする

; ^ Ctrl
; ! Alt
; + Shift
; # Win

^1::
;--------------------------------------------------------------
;   Ctrl+1
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "Restart coming"
    Msg.j := "リスタートします"
    Chat(Msg[Lang])
return

^2::
;--------------------------------------------------------------
;   Ctrl+2
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "Restart & go at start minus 1:45"
    Msg.j := "リスタート １分４５秒後にスタートします。"
    Chat(Msg[Lang])
return

^3::
;--------------------------------------------------------------
;   Ctrl+3
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "no more restarts"
    Msg.j := "もう、リスタートしません"
    Chat(Msg[Lang])
return

^4::
;--------------------------------------------------------------
;   Ctrl+4
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "NPC - no pen cancel race"
    Msg.j := "NPC - ペナルティは禁止します"
    Chat(Msg[Lang])
return

^5::
;--------------------------------------------------------------
;   Ctrl+5
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "Cancel only wrong pens please"
    Msg.j := "間違ったペナルティ判定の場合だけキャンセルしてください"
    Chat(Msg[Lang])
return

^6::
;--------------------------------------------------------------
;   Ctrl+6
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "this is the start"
    Msg.j := "これは、スタートです"
    Chat(Msg[Lang])
return
 
^8::
;--------------------------------------------------------------
;   Ctrl+7
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "better to$ff0 spin and fin$g than to $ff0fit and quit "
    Msg.j := "better to$ff0 spin and fin$g than to $ff0fit and quit"
    Chat(Msg[Lang])
return
 
^9::
;--------------------------------------------------------------
;   Ctrl+9
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "when did $ff0overlap$g begin?"
    Msg.j := "いつ $ff0オーバーラップ$g しましたか？"
    Chat(Msg[Lang])
return

!a::
;--------------------------------------------------------------
;   Alt+a
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "testing something ... will you help?"
    Msg.j := "テスト中…なにか手つだいますか？"
    Chat(Msg[Lang])
return

^b::
;--------------------------------------------------------------
;   Ctrl+b
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "ty host  ty fleet    $ff0good-bye"
    Msg.j := "ありがとうホスト、ありがとうみなさん $ff0さようなら"
    Chat(Msg[Lang])
return

^c::
;--------------------------------------------------------------
;   Ctrl+c
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "cheers"
    Msg.j := "かん声" ; 歓声の歓が文字化け
    Chat(Msg[Lang])
return

!c::
;--------------------------------------------------------------
;   Alt+c
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "'getting clear' & 'taking a penalty' are $ff0separate$g actions (r44.2)"
    Msg.j := "他の艇から十分離れてから、ペナルティを履行してください（ルール44.2）"
    Chat(Msg[Lang])
return

!d::
;--------------------------------------------------------------
;   Alt+d
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "pen. boat may assert ROW while 'getting clear' not while taking penalty turns"
    Msg.j := "pen. boat may assert ROW while 'getting clear' not while taking penalty turns"
    Chat(Msg[Lang])
return

!e::
;--------------------------------------------------------------
;   Alt+e
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "i had $ff0ROW$g so resp. to keep clear was $ff0KC#g boat's .. not mine"
    Msg.j := "i had $ff0ROW$g so resp. to keep clear was $ff0KC#g boat's .. not mine"
    Chat(Msg[Lang])
return

^f::
;--------------------------------------------------------------
;   Ctrl+f
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "fair winds .. I'll check back later"
    Msg.j := "fair winds .. I'll check back later"
    Chat(Msg[Lang])
return

^g::
;--------------------------------------------------------------
;   Ctrl+g
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "good winds"
    Msg.j := "よい風を"
    Chat(Msg[Lang])
return

^h::
;--------------------------------------------------------------
;   Ctrl+h
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "$0ffkeep clear$g .. not yet on $0ffproper course$g"
    Msg.j := "$0ff避けてください$g .. まだ $0ffプロパーコースではありません$g"
    Chat(Msg[Lang])
return

!h::
;--------------------------------------------------------------
;   Alt+h
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "not hunting. I was racing and observing my right of way"
    Msg.j := "not hunting. I was racing and observing my right of way"
    Chat(Msg[Lang])
return

;i is bound to toggle interface 

;k is bound to toggle camera view 

^l::
;--------------------------------------------------------------
;   Ctrl+l
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "leeward boat .. you must $0ffkeep clear$g"
    Msg.j := "leeward boat .. you must $0ffkeep clear$g"
    Chat(Msg[Lang])
return

!l::
;--------------------------------------------------------------
;   Alt+l
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "last race .. $ff0No more races, sorry!"
    Msg.j := "last race .. $ff0No more races, sorry!"
    Chat(Msg[Lang])
return

^m::
;--------------------------------------------------------------
;   Ctrl+m
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "$0ffMARK ROOM$g please .. $ff0I am overlapped inside"
    Msg.j := "$0ffMARK ROOM$g please .. $ff0I am overlapped inside"
    Chat(Msg[Lang])
return

^n::
;--------------------------------------------------------------
;   Ctrl+n
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "$0ffno room$g here. you $0ffkeep clear$g."
    Msg.j := "$0ffルーム$gはありません $0ff避けてください$g."
    Chat(Msg[Lang])
return

^!n::
;--------------------------------------------------------------
;   Ctrl+Alt+n
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "NPC - no pen cancel race"
    Msg.j := "NPC - ペナルティのキャンセルは禁止です"
    Chat(Msg[Lang])
return

;!n (see PC request guard below)
 
^o::
;--------------------------------------------------------------
;   Ctrl+o
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "room to tack $ff0RTT$g please"
    Msg.j := "タックをするためのルーム $ff0RTT$g をください"
    Chat(Msg[Lang])
return

!o::
;--------------------------------------------------------------
;   Alt+o
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "room for $ff0obstruction$g please"
    Msg.j := "room for $ff0obstruction$g please"
    Chat(Msg[Lang])
return

^p::
;--------------------------------------------------------------
;   Ctrl+p
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "$ff0proper course$g please"
    Msg.j := "$ff0proper course$g please"
    Chat(Msg[Lang])
return

;!p (see PC request guard below)
 
;^!q (see House Rules below)
 
^r::
;--------------------------------------------------------------
;   Ctrl+r
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "room please"
    Msg.j := "room please"
    Chat(Msg[Lang])
return

!r::
;--------------------------------------------------------------
;   Alt+r
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "check the $ff0replay$g if you wish.  i $ff0was$g fair"
    Msg.j := "check the $ff0replay$g if you wish.  i $ff0was$g fair"
    Chat(Msg[Lang])
return

^s::
;--------------------------------------------------------------
;   Ctrl+s
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "starboard"
    Msg.j := "starboard"
    Chat(Msg[Lang])
return

^t::
;--------------------------------------------------------------
;   Ctrl+t
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "tacking"
    Msg.j := "tacking"
    Chat(Msg[Lang])
return

^u::
;--------------------------------------------------------------
;   Ctrl+u
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "Unable"
    Msg.j := "Unable"
    Chat(Msg[Lang])
return

!u::
;--------------------------------------------------------------
;   Alt+u
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "FYI, I saw the 'Falling back to $ff0TCP$g (from UDP)' alert when joining"
    Msg.j := "FYI, I saw the 'Falling back to $ff0TCP$g (from UDP)' alert when joining"
    Chat(Msg[Lang])
return

^w::
;--------------------------------------------------------------
;   Ctrl+w
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "$0ffROOM$g please ... $ff0I have overlap"
    Msg.j := "$0ffROOM$g please ... $ff0I have overlap"
    Chat(Msg[Lang])
return

!w::
;--------------------------------------------------------------
;   Alt+w
;   気象状況の表示
;
;--------------------------------------------------------------
    KeyWait Alt
    send {Escape}
    Sleep, 100
    send {Down}
    Sleep, 50
    send {Down}
    Sleep, 50
    send {Enter} 
return
 
^x::
;--------------------------------------------------------------
;   Ctrl+x
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "thanks for racing everyone"
    Msg.j := "thanks for racing everyone"
    Chat(Msg[Lang])
return

^y::
;--------------------------------------------------------------
;   Ctrl+y
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "you tack"
    Msg.j := "you tack"
    Chat(Msg[Lang])
return

^z::
;--------------------------------------------------------------
;   Ctrl+z
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "please help me receive a penalty .. OK?"
    Msg.j := "please help me receive a penalty .. OK?"
    Chat(Msg[Lang])
return

!z::
;--------------------------------------------------------------
;   Alt+z
;
;--------------------------------------------------------------
    Msg := Object()
    Msg.e := "any $ff0eye-witness$g ... speak please"
    Msg.j := "any $ff0eye-witness$g ... speak please"
    Chat(Msg[Lang])
return

^!q:: 
;--------------------------------------------------------------
; Sailing Instructions  (Ctrl+Alt+Q) 
; 
;--------------------------------------------------------------
KeyWait Control 
KeyWait Alt 
;send {Enter}{Enter} 
BlockInput On 
 Chat("$s$w{=} {=} {=} Sailing Instructions {=} {=} {=}") 
;Chat("Restart is by vote $ff0and only if$g 3min prestart") 
 Chat("do NOT ask for a $ff0restart$g！ Join servers earlier.") 
 Chat("Penalty Cancel request allowed $ff0but$g ... no need to answer") 
;Chat("$nRule 2$m $ff0Unfair player$g is banned") 
 Chat("$nRule 19$m $ff0respond$g to hail for ROOM at an obstruction") 
;Chat("$nRule 21$m $ff0keep clear$g while taking penalty turns") 
;Chat("$nRule 23.1$m $ff0do not interfere$g if not racing$n e.g. missed mark or start") 
;Chat("It is better to $ff0spin and fin$g than to $ff0fit and quit$g") 
 Chat("$s$w{=} {=} {=} enjoy{!} {=} {=} {=}") 
BlockInput Off 
return 

^Space::
+Space::
!Space::
;--------------------------------------------------------------
; チャット用のダイアログを表示します。
; 日本語の入力が直接行えるようになる
;
; Ctrl+Space Shift+Space Alt+Space いづれも入力ボックスが表示される
; Cancel か空文字入力するまで、繰り返す。
;--------------------------------------------------------------
Loop
{
InputBox, UserInput, チャット入力ＢＯＸ,,,640,100
if ErrorLevel <> 0
  return
else if StrLen(UserInput)=0
  return
else
  Sleep, 100
  IME_SetConvMode(16,"ahk_class GbxApp") ; メインのWindowのIMEを半角英数にもどす
  Chat(UserInput)
}

;--------------------------------------------------------------
; ISAF rules (hotstrings not hotkeys) 
; 
#Hotstring EndChars -()[]{}:;'"/\,?!`n `t ; remove period (.) from list of so-called ending characters 

:*:i16::
i16:
    Msg := Object()
    Msg.e := "$n16.1 $ff0ROW$g boat changing course shall give other boat room to keep clear$m"
    Msg.j := "$n16.1 $ff0けん利艇$g がコースを変更する場合、相手艇にたいして避けるためのルームを与えなけらばならない。$m"
    SendMsg(Msg[Lang])
return

:*:i17.1:: 
i171:
    Msg := Object()
    Msg.e := "$n17.1 same tack: overlapped lee boat must not sail above $ff0proper course$g$m"
    Msg.j := "$n17.1 同一タックでオーバラップ 風下艇は$ff0プロパーコース$g$mより風上を帆走してはならない"
    SendMsg(Msg[Lang])
return 

:*:i18.2a:: 
i182a:
    Msg := Object()
    Msg.e := "$n18.2a outside gives mark room to inside $ff0and$g must keep clear$m"
    Msg.j := "$n18.2a 外側の艇は、内側の艇にマークルーム与え、避けなければならない$m"
    SendMsg(Msg[Lang])
return 

:*:i18.2b:: 
i182b: 
    Msg := Object()
    Msg.e := "$n18.2b overlap $ff0before$g zone: original outside gives mark room to inside$m"
    Msg.j := "$n18.2b overlap $ff0before$g zone: original outside gives mark room to inside$m"
    SendMsg(Msg[Lang])
return 

:*:i18.2c:: 
i182c: 
    Msg := Object()
    Msg.e := "$n18.2c overlap $ff0after$g zone: astern gives mark room to ahead. HTW cancels$m"
    Msg.j := "$n18.2c overlap $ff0after$g zone: astern gives mark room to ahead. HTW cancels$m"
    SendMsg(Msg[Lang])
return 

:*:i18.2d:: 
i182d: 
    Msg := Object()
    Msg.e := "$n18.2d ROW changing course to round a mark need not give room $ff0rule 16$g exonertated$m"
    Msg.j := "$n18.2d ROW changing course to round a mark need not give room $ff0rule 16$g exonertated$m"
    SendMsg(Msg[Lang])
return 

:*:i18.3a:: 
i183a: 
    Msg := Object()
    Msg.e := "$n18.3a one tacker + fetcher outside: tacker must allow fetcher to fetch mark$m"
    Msg.j := "$n18.3a one tacker + fetcher outside: tacker must allow fetcher to fetch mark$m"
    SendMsg(Msg[Lang])
return 

:*:i18.3b:: 
i183b: 
    Msg := Object()
    Msg.e := "$n18.3b one tacker + fetcher inside: $ff0no rule 15$g tacker must give mark room to fetcher$m"
    Msg.j := "$n18.3b one tacker + fetcher inside: $ff0no rule 15$g tacker must give mark room to fetcher$m"
    SendMsg(Msg[Lang])
return 

:*:i18.4:: 
i184: 
    Msg := Object()
    Msg.e := "$n18.4 inside ROW needs gybe to sail proper course: don't sail too far from mark$m"
    Msg.j := "$n18.4 inside ROW needs gybe to sail proper course: don't sail too far from mark$m"
    SendMsg(Msg[Lang])
return 

:*:i20.1:: 
i201: 
    Msg := Object()
    Msg.e := "$n20.1 Pen 30.1 boat shall keep clear until completely on pre-start side$m"
    Msg.j := "$n20.1 Pen 30.1 boat shall keep clear until completely on pre-start side$m"
    SendMsg(Msg[Lang])
return 

:*:i20.2:: 
i202: 
    Msg := Object()
    Msg.e := "$n20.2 a boat taking a penalty shall keep clear of one that is not$m"
    Msg.j := "$n20.2 a boat taking a penalty shall keep clear of one that is not$m"
    SendMsg(Msg[Lang])
return 

:*:i20.3:: 
i203: 
    Msg := Object()
    Msg.e := "$n20.3 a boat moving astern shall keep clear of one that is not$m"
    Msg.j := "$n20.3 a boat moving astern shall keep clear of one that is not$m"
    SendMsg(Msg[Lang])
return 

:*:i22.1:: 
i221: 
    Msg := Object()
    Msg.e := "$n22.1 $ff0non-racer$g shall not interfere with a $ff0racer$g$m"
    Msg.j := "$n22.1 $ff0non-racer$g shall not interfere with a $ff0racer$g$m"
    SendMsg(Msg[Lang])
return 

:*:i22.2:: 
i222: 
    Msg := Object()
    Msg.e := "$n22.2 unless on proper course, do not interfere with penalty turns or another leg$m"
    Msg.j := "$n22.2 unless on proper course, do not interfere with penalty turns or another leg$m"
    SendMsg(Msg[Lang])
return 

::i18:: ; list all rule 18 
BlockInput On 
Gosub i182a 
Gosub Routine1 
Gosub i182b 
Gosub Routine1 
Gosub i182c 
Gosub Routine1 
Gosub i182d 
Gosub Routine1 
Gosub i183a 
Gosub Routine1 
Gosub i183b 
Gosub Routine1 
Gosub i184 
Sleep, %Pause% 
send {Enter} 
BlockInput off 
return 

::i22:: ; list all rule 22 
BlockInput On 
Gosub i221 
Gosub Routine1 
Gosub i222 
Sleep, %Pause% 
send {Enter} 
BlockInput off 
return 

Routine1: 
Sleep, %Pause% 
send {Enter} 
Sleep, %Pause% 
send {Enter} 
return 

Routine0: 
Sleep, %Pause% 
send {Enter} 
return 


IME_SetConvMode(ConvMode,WinTitle="")
;-------------------------------------------------------
; IME 入力モードセット
;   in  ConvMode    入力モード
;       WinTitle    (省略時アクティブウィンドウ)
;--------------------------------------------------------
{
    ifEqual WinTitle,,  SetEnv,WinTitle,A
    WinGet,hWnd,ID,%WinTitle%
    DefaultIMEWnd := DllCall("imm32\ImmGetDefaultIMEWnd", Uint,hWnd, Uint)

    ;Message : WM_IME_CONTROL  wParam:IMC_SETCONVERSIONMODE
    DetectSave := A_DetectHiddenWindows
    DetectHiddenWindows,ON
    SendMessage 0x283, 0x002,ConvMode,,ahk_id %DefaultIMEWnd%
    DetectHiddenWindows,%DetectSave%
    Return ErrorLevel
}