/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.ss;

import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSAssignment;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSResources;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSCell
implements XCell {
    private SSSheet ssSheet;
    private SSResources resources;
    private CellUnit cellUnit;
    private Cell cell;

    SSCell(SSSheet ssSheet, CellProvider cellProvider) {
        int rowIndex = cellProvider.row();
        int colIndex = cellProvider.column();
        Sheet sheet = ssSheet.getSheet();
        Row row = sheet.getRow(rowIndex) == null ? sheet.createRow(rowIndex) : sheet.getRow(rowIndex);
        this.cell = row.getCell(colIndex) == null ? row.createCell(colIndex) : row.getCell(colIndex);
        this.ssSheet = ssSheet;
        this.resources = new SSResources(ssSheet);
        this.cellUnit = cellProvider.toCellUnit();
    }

    public <T> T getValue(Class<T> clazz) {
        return SSAssignment.getValue(this.cell, clazz);
    }

    public void setValue(Object value) {
        SSAssignment.setValue(this.cell, value);
    }

    public String getStringValue() {
        return this.cell.getStringCellValue();
    }

    public String getFormula() {
        if (this.cell.getCellType() == 2) {
            return this.cell.getCellFormula();
        }
        return null;
    }

    public void setFormula(String formula) {
        this.cell.setCellType(2);
        this.cell.setCellFormula(formula);
    }

    public XStyle getStyle() {
        return this.resources.getXStyle(this.cell.getCellStyle());
    }

    public void setStyle(XStyle style) {
        this.cell.setCellStyle(this.resources.findCellStyle(style));
    }

    public XSheet getSheet() {
        return this.ssSheet;
    }

    public CellUnit toCellUnit() {
        return this.cellUnit.toCellUnit();
    }

    public int row() {
        return this.cellUnit.row();
    }

    public int column() {
        return this.cellUnit.column();
    }
}

