/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.poi;

import java.util.EnumMap;
import java.util.Map;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.RangeProvider;
import jp.coppermine.voyager.xlsmaker.coord.RangeUnit;
import jp.coppermine.voyager.xlsmaker.enums.BorderStyle;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIAssignment;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIResources;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POISheet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIRange
implements XRange {
    private POISheet ssSheet;
    private POIResources resources;
    private RangeUnit rangeUnit;
    private XStyle xStyle;

    POIRange(POISheet ssSheet, RangeProvider rangeProvider) {
        this.ssSheet = ssSheet;
        this.rangeUnit = rangeProvider.toRangeUnit();
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        HSSFSheet sheet = ssSheet.getSheet();
        int r = first.row();
        while (r <= last.row()) {
            HSSFRow row = sheet.getRow(r) == null ? sheet.createRow(r) : sheet.getRow(r);
            int c = first.column();
            while (c <= last.column()) {
                if (row.getCell((short)c) == null) {
                    row.createCell((short)c);
                }
                ++c;
            }
            ++r;
        }
        this.resources = new POIResources(ssSheet);
        this.xStyle = this.resources.getXStyle(sheet.getRow(first.row()).getCell((short)first.column()).getCellStyle());
    }

    @Override
    public <T> T getValue(Class<T> clazz) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        HSSFCell cell = this.ssSheet.getSheet().getRow(first.row()).getCell((short)first.column());
        cell.setEncoding((short)1);
        return POIAssignment.getValue(cell, clazz);
    }

    @Override
    public void setValue(Object value) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        HSSFCell cell = this.ssSheet.getSheet().getRow(first.row()).getCell((short)first.column());
        cell.setEncoding((short)1);
        POIAssignment.setValue(cell, value);
    }

    @Override
    public String getStringValue() {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        HSSFCell cell = this.ssSheet.getSheet().getRow(first.row()).getCell((short)first.column());
        cell.setEncoding((short)1);
        return cell.getStringCellValue();
    }

    @Override
    public String getFormula() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormula(String formula) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XStyle getStyle() {
        return this.xStyle;
    }

    @Override
    public void setStyle(XStyle style) {
        this.xStyle = style;
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        int rows = last.row() - first.row() + 1;
        int columns = last.column() - first.column() + 1;
        HSSFSheet sheet = this.ssSheet.getSheet();
        Map<Area, XStyle> styles = this.expandStyle(this.xStyle);
        if (rows == 1) {
            if (columns == 1) {
                HSSFCell cell = sheet.getRow(first.row()).getCell((short)first.column());
                cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
            } else if (columns == 2) {
                HSSFCell firstCell = sheet.getRow(first.row()).getCell((short)first.column());
                firstCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                HSSFCell lastCell = sheet.getRow(first.row()).getCell((short)last.column());
                lastCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
            } else {
                HSSFCell firstCell = sheet.getRow(first.row()).getCell((short)first.column());
                firstCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                int c = first.column() + 1;
                while (c < last.column()) {
                    HSSFCell cell = sheet.getRow(first.row()).getCell((short)c);
                    cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                    ++c;
                }
                HSSFCell lastCell = sheet.getRow(first.row()).getCell((short)last.column());
                lastCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
            }
        } else if (rows == 2) {
            if (columns == 1) {
                HSSFCell topCell = sheet.getRow(first.row()).getCell((short)first.column());
                topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                HSSFCell bottomCell = sheet.getRow(last.row()).getCell((short)first.column());
                bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
            } else if (columns == 2) {
                HSSFCell topLeftCell = sheet.getRow(first.row()).getCell((short)first.column());
                topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                HSSFCell topRightCell = sheet.getRow(first.row()).getCell((short)last.column());
                topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                HSSFCell bottomRightCell = sheet.getRow(last.row()).getCell((short)last.column());
                bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                HSSFCell bottomLeftCell = sheet.getRow(last.row()).getCell((short)first.column());
                bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
            } else {
                HSSFCell topLeftCell = sheet.getRow(first.row()).getCell((short)first.column());
                topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                HSSFCell topRightCell = sheet.getRow(first.row()).getCell((short)last.column());
                topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                HSSFCell bottomRightCell = sheet.getRow(last.row()).getCell((short)last.column());
                bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                HSSFCell bottomLeftCell = sheet.getRow(last.row()).getCell((short)first.column());
                bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
                int c = first.column() + 1;
                while (c < last.column()) {
                    HSSFCell topCell = sheet.getRow(first.row()).getCell((short)c);
                    topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                    HSSFCell bottomCell = sheet.getRow(last.row()).getCell((short)c);
                    bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
                    ++c;
                }
            }
        } else if (columns == 1) {
            HSSFCell topCell = sheet.getRow(first.row()).getCell((short)first.column());
            topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
            int r = first.row() + 1;
            while (r < last.row()) {
                HSSFCell innerCell = sheet.getRow(r).getCell((short)first.column());
                innerCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                ++r;
            }
            HSSFCell bottomCell = sheet.getRow(last.row()).getCell((short)first.column());
            bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
        } else if (columns == 2) {
            HSSFCell topLeftCell = sheet.getRow(first.row()).getCell((short)first.column());
            topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
            HSSFCell topRightCell = sheet.getRow(first.row()).getCell((short)last.column());
            topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
            int r = first.row() + 1;
            while (r < last.row()) {
                HSSFCell leftCell = sheet.getRow(r).getCell((short)first.column());
                leftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                HSSFCell rightCell = sheet.getRow(r).getCell((short)last.column());
                rightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
                ++r;
            }
            HSSFCell bottomRightCell = sheet.getRow(last.row()).getCell((short)last.column());
            bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
            HSSFCell bottomLeftCell = sheet.getRow(last.row()).getCell((short)first.column());
            bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
        } else {
            HSSFCell topLeftCell = sheet.getRow(first.row()).getCell((short)first.column());
            topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
            HSSFCell topRightCell = sheet.getRow(first.row()).getCell((short)last.column());
            topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
            HSSFCell bottomRightCell = sheet.getRow(last.row()).getCell((short)last.column());
            bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
            HSSFCell bottomLeftCell = sheet.getRow(last.row()).getCell((short)first.column());
            bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
            int r = first.row();
            while (r <= last.row()) {
                int c = first.column();
                while (c <= last.column()) {
                    HSSFCell cell = sheet.getRow(r).getCell((short)c);
                    if (r == first.row()) {
                        if (c == first.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                        } else if (c == last.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                        } else {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                        }
                    } else if (r == last.row()) {
                        if (c == first.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
                        } else if (c == last.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                        } else {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
                        }
                    } else if (c == first.column()) {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                    } else if (c == last.column()) {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
                    } else {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    @Override
    public XSheet getSheet() {
        return this.ssSheet;
    }

    @Override
    public CellUnit getFirstCellUnit() {
        return this.rangeUnit.getFirstCellUnit();
    }

    @Override
    public CellUnit getLastCellUnit() {
        return this.rangeUnit.getLastCellUnit();
    }

    @Override
    public RangeUnit toRangeUnit() {
        return this.rangeUnit;
    }

    @Override
    public boolean isMerged() {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        Region region = new Region(first.row(), (short)first.column(), last.row(), (short)last.column());
        HSSFSheet sheet = this.ssSheet.getSheet();
        int index = 0;
        while (index < sheet.getNumMergedRegions()) {
            if (region == sheet.getMergedRegionAt(index)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    @Override
    public void setMerged(boolean merged) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        Region region = new Region(first.row(), (short)first.column(), last.row(), (short)last.column());
        HSSFSheet sheet = this.ssSheet.getSheet();
        if (merged) {
            sheet.addMergedRegion(region);
        } else {
            int index = 0;
            while (index < sheet.getNumMergedRegions()) {
                if (region == sheet.getMergedRegionAt(index)) {
                    sheet.removeMergedRegion(index);
                    return;
                }
                ++index;
            }
        }
    }

    Map<Area, XStyle> expandStyle(XStyle xStyle) {
        EnumMap<Area, XStyle> map = new EnumMap<Area, XStyle>(Area.class);
        int rows = this.rangeUnit.getLastCellUnit().row() - this.rangeUnit.getFirstCellUnit().row() + 1;
        int columns = this.rangeUnit.getLastCellUnit().column() - this.rangeUnit.getFirstCellUnit().column() + 1;
        if (rows == 1) {
            if (columns == 1) {
                map.put(Area.INNER, xStyle);
                return map;
            }
            if (columns == 2) {
                map.put(Area.LEFT, XStyle.builder(xStyle).borderRight(BorderStyle.NONE).build());
                map.put(Area.RIGHT, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).build());
            } else {
                map.put(Area.LEFT, XStyle.builder(xStyle).borderRight(BorderStyle.NONE).build());
                map.put(Area.INNER, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.RIGHT, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).build());
            }
        } else if (rows == 2) {
            if (columns == 1) {
                map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).build());
                map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).build());
            } else if (columns == 2) {
                map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            } else {
                map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            }
        } else if (columns == 1) {
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).build());
            map.put(Area.INNER, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).build());
        } else if (columns == 2) {
            map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
        } else {
            map.put(Area.LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.INNER, XStyle.builder(xStyle).border(BorderStyle.NONE).build());
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Area {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        INNER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

