/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans.filter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jp.coppermine.voyager.beans.BeanWrapper;
import jp.coppermine.voyager.beans.filter.ConstructionFilter;
import jp.coppermine.voyager.beans.filter.InputFilter;
import jp.coppermine.voyager.beans.filter.OutputFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredBeanWrapper
extends BeanWrapper {
    private List<ConstructionFilter> createFilters = new CopyOnWriteArrayList<ConstructionFilter>();
    private List<OutputFilter> outputFilters = new CopyOnWriteArrayList<OutputFilter>();
    private List<InputFilter> inputFilters = new CopyOnWriteArrayList<InputFilter>();
    private boolean enableFilters;

    public FilteredBeanWrapper(BeanWrapper bean) {
        super(bean);
    }

    @Override
    public FilteredBeanWrapper wrap(Object obj) {
        for (ConstructionFilter filter : this.createFilters) {
            Annotation annotation = this.getTypeAnnotation(filter.getAnnotation());
            if (annotation == null) continue;
            filter.execute(this.getType(), obj);
        }
        return (FilteredBeanWrapper)super.wrap(obj);
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        T obj = super.newInstance(clazz);
        for (ConstructionFilter filter : this.createFilters) {
            Annotation annotation = this.getTypeAnnotation(filter.getAnnotation());
            if (annotation == null) continue;
            filter.execute(this.getType(), null);
        }
        return obj;
    }

    @Override
    public Object getProperty(String name) {
        Object value = super.getProperty(name);
        for (OutputFilter filter : this.outputFilters) {
            if (!this.isAnnotationPresent(name, filter.getAnnotation())) continue;
            value = filter.getValue(this.getPropertyCollection().getProperty(name), value);
        }
        return value;
    }

    @Override
    public void setProperty(String name, Object value) {
        for (InputFilter filter : this.inputFilters) {
            if (!this.isAnnotationPresent(name, filter.getAnnotation())) continue;
            value = filter.setValue(this.getPropertyCollection().getProperty(name), value);
        }
        super.setProperty(name, value);
    }

    public void addCreateFilters(List<ConstructionFilter> filters) {
        for (ConstructionFilter filter : filters) {
            if (filter == null || this.createFilters.contains(filter)) continue;
            this.createFilters.add(filter);
            this.enableFilters = true;
        }
    }

    public void addCreateFilters(ConstructionFilter ... filters) {
        this.addCreateFilters(Arrays.asList(filters));
    }

    public void addOutputFilters(List<OutputFilter> filters) {
        for (OutputFilter filter : filters) {
            if (filter == null || this.outputFilters.contains(filter)) continue;
            this.outputFilters.add(filter);
            this.enableFilters = true;
        }
    }

    public void addOutputFilters(OutputFilter ... filters) {
        this.addOutputFilters(Arrays.asList(filters));
    }

    public void addInputFilters(List<InputFilter> filters) {
        for (InputFilter filter : filters) {
            if (filter == null || this.inputFilters.contains(filter)) continue;
            this.inputFilters.add(filter);
            this.enableFilters = true;
        }
    }

    public void addInputFilters(InputFilter ... filters) {
        this.addInputFilters(Arrays.asList(filters));
    }

    public List<ConstructionFilter> getCreateFilters() {
        return new ArrayList<ConstructionFilter>(this.createFilters);
    }

    public List<OutputFilter> getOutputFilters() {
        return new ArrayList<OutputFilter>(this.outputFilters);
    }

    public List<InputFilter> getInputFilters() {
        return new ArrayList<InputFilter>(this.inputFilters);
    }

    public void clearCreateFilters() {
        this.createFilters.clear();
        this.enableFilters = !this.createFilters.isEmpty() || !this.outputFilters.isEmpty() || !this.inputFilters.isEmpty();
    }

    public void clearOutputFilters() {
        this.outputFilters.clear();
        this.enableFilters = !this.createFilters.isEmpty() || !this.outputFilters.isEmpty() || !this.inputFilters.isEmpty();
    }

    public void clearInputFilters() {
        this.inputFilters.clear();
        this.enableFilters = !this.createFilters.isEmpty() || !this.outputFilters.isEmpty() || !this.inputFilters.isEmpty();
    }

    public boolean isEnableFilters() {
        return this.enableFilters;
    }

    public void setEnableFilters(boolean enableFilters) {
        this.enableFilters = enableFilters;
    }
}

