/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.ss;

import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.RangeProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XWorkbook;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSCell;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSRange;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SSSheet
implements XSheet {
    private SSWorkbook ssWorkbook;
    private Sheet sheet;

    SSSheet(SSWorkbook ssWorkbook) {
        Workbook workbook = ssWorkbook.getWorkbook();
        this.sheet = workbook.createSheet();
        this.ssWorkbook = ssWorkbook;
    }

    SSSheet(SSWorkbook ssWorkbook, int index) {
        Workbook workbook = ssWorkbook.getWorkbook();
        while (index >= workbook.getNumberOfSheets()) {
            workbook.createSheet();
        }
        this.sheet = workbook.getSheetAt(index);
        this.ssWorkbook = ssWorkbook;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public void setName(String name) {
        Workbook workbook = this.ssWorkbook.getWorkbook();
        int index = 0;
        while (index < workbook.getNumberOfSheets()) {
            if (this.sheet == workbook.getSheetAt(index)) {
                workbook.setSheetName(index, name);
                break;
            }
            ++index;
        }
    }

    public XCell getCell(CellProvider cellProvider) {
        return new SSCell(this, cellProvider);
    }

    public XRange getRange(RangeProvider rangeProvider) {
        return new SSRange(this, rangeProvider);
    }

    public double getRowHeight(RowProvider rowProvider) {
        Row row = this.sheet.getRow(rowProvider.row()) == null ? this.sheet.createRow(rowProvider.row()) : this.sheet.getRow(rowProvider.row());
        return (double)row.getHeight() / 20.0;
    }

    public void setRowHeight(RowProvider rowProvider, double height) {
        Row row = this.sheet.getRow(rowProvider.row()) == null ? this.sheet.createRow(rowProvider.row()) : this.sheet.getRow(rowProvider.row());
        row.setHeight((short)(height * 20.0));
    }

    public double getColumnWidth(ColumnProvider columnProvider) {
        return (double)this.sheet.getColumnWidth(columnProvider.column()) / 256.0;
    }

    public void setColumnWidth(ColumnProvider columnProvider, double width) {
        this.sheet.setColumnWidth(columnProvider.column(), (int)(width * 256.0));
    }

    public XWorkbook getWorkbook() {
        return this.ssWorkbook;
    }

    Sheet getSheet() {
        return this.sheet;
    }
}

