/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.ss;

import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSAssignment;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSResources;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSCell
implements XCell {
    private SSSheet ssSheet;
    private SSResources resources;
    private CellUnit cellUnit;
    private Cell cell;

    SSCell(SSSheet ssSheet, CellProvider cellProvider) {
        int rowIndex = cellProvider.row();
        int colIndex = cellProvider.column();
        Sheet sheet = ssSheet.getSheet();
        Row row = sheet.getRow(rowIndex) == null ? sheet.createRow(rowIndex) : sheet.getRow(rowIndex);
        this.cell = row.getCell(colIndex) == null ? row.createCell(colIndex) : row.getCell(colIndex);
        this.ssSheet = ssSheet;
        this.resources = new SSResources(ssSheet);
        this.cellUnit = cellProvider.toCellUnit();
    }

    @Override
    public <T> T getValue(Class<T> clazz) {
        return SSAssignment.getValue(this.cell, clazz);
    }

    @Override
    public void setValue(Object value) {
        SSAssignment.setValue(this.cell, value);
    }

    @Override
    public String getStringValue() {
        return this.cell.getStringCellValue();
    }

    @Override
    public String getFormula() {
        if (this.cell.getCellType() == 2) {
            return this.cell.getCellFormula();
        }
        return null;
    }

    @Override
    public void setFormula(String formula) {
        this.cell.setCellType(2);
        this.cell.setCellFormula(formula);
    }

    @Override
    public XStyle getStyle() {
        return this.resources.getXStyle(this.cell.getCellStyle());
    }

    @Override
    public void setStyle(XStyle style) {
        this.cell.setCellStyle(this.resources.findCellStyle(style));
    }

    @Override
    public XSheet getSheet() {
        return this.ssSheet;
    }

    @Override
    public CellUnit toCellUnit() {
        return this.cellUnit.toCellUnit();
    }

    @Override
    public int row() {
        return this.cellUnit.row();
    }

    @Override
    public int column() {
        return this.cellUnit.column();
    }
}

