/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.filter;

import java.lang.annotation.Annotation;
import jp.coppermine.voyager.beans.collection.ReadableProperty;
import jp.coppermine.voyager.beans.collection.WritableProperty;
import jp.coppermine.voyager.beans.filter.InputFilter;
import jp.coppermine.voyager.beans.filter.OutputFilter;
import jp.coppermine.voyager.xlsmaker.annotations.Cell;
import jp.coppermine.voyager.xlsmaker.annotations.Range;
import jp.coppermine.voyager.xlsmaker.annotations.Replace;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RangeUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeFilter
implements OutputFilter,
InputFilter {
    private XSheet xSheet;
    private RowUnit rowOffset;
    private ColumnUnit columnOffset;

    public RangeFilter(XSheet xSheet, RowUnit rowOffset, ColumnUnit columnOffset) {
        this.xSheet = xSheet;
        this.rowOffset = rowOffset;
        this.columnOffset = columnOffset;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return Range.class;
    }

    @Override
    public Object setValue(WritableProperty property, Object value) {
        return value;
    }

    @Override
    public Object getValue(ReadableProperty property, Object value) {
        Range range = property.getReadAnnotation(Range.class);
        Cell first = range.first();
        Cell last = range.last();
        CellUnit firstCellUnit = first.value().length() == 0 ? CellUnit.at(first.row(), first.column()) : CellUnit.of(first.value());
        CellUnit lastCellUnit = last.value().length() == 0 ? CellUnit.at(last.row(), last.column()) : CellUnit.of(last.value());
        XRange xRange = this.xSheet.getRange(RangeUnit.from(firstCellUnit, lastCellUnit).shift(this.rowOffset, this.columnOffset));
        xRange.setMerged(range.merge());
        if (property.isReadAnnotationPresent(Replace.class)) {
            Replace replace = property.getReadAnnotation(Replace.class);
            String s = xRange.getValue(String.class);
            String replacement = replace.replacement().replace("{value}", value.toString());
            xRange.setValue(s.replaceFirst(replace.pattern(), replacement));
            return value;
        }
        xRange.setValue(value);
        return value;
    }
}

