/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.coord;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.RangeProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;

public final class RangeUnit
implements RangeProvider,
Serializable {
    private static final long serialVersionUID = 2751474685041827563L;
    private CellUnit first;
    private CellUnit last;

    private RangeUnit(CellUnit first, CellUnit last) {
        this.first = first;
        this.last = last;
    }

    public static RangeUnit from(CellProvider firstCellProvider, CellProvider lastCellProvider) {
        return new RangeUnit(firstCellProvider.toCellUnit(), lastCellProvider.toCellUnit());
    }

    public static RangeUnit from(RangeProvider rangeProvider) {
        return new RangeUnit(rangeProvider.getFirstCellUnit(), rangeProvider.getLastCellUnit());
    }

    public static RangeUnit of(String address) {
        String[] addr = address.split(":");
        return new RangeUnit(CellUnit.of(addr[0]), CellUnit.of(addr[1]));
    }

    public RangeUnit shift(int rows, int columns) {
        return new RangeUnit(this.first.shift(rows, columns), this.last.shift(rows, columns));
    }

    public RangeUnit shift(RowProvider rowProvider, ColumnProvider columnProvider) {
        return new RangeUnit(this.first.shift(rowProvider, columnProvider), this.last.shift(rowProvider, columnProvider));
    }

    public CellUnit getFirstCellUnit() {
        return this.first;
    }

    public CellUnit getLastCellUnit() {
        return this.last;
    }

    public RangeUnit toRangeUnit() {
        return this;
    }

    public String toString() {
        return String.valueOf(this.first.toString()) + ":" + this.last.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeUnit other = (RangeUnit)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.last == null ? other.last != null : !this.last.equals(other.last));
    }
}

